/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.nciso.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.metadata.nciso.bean.Extent;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

public class ThreddsExtentUtil {
    private static Logger _log = LoggerFactory.getLogger(ThreddsExtentUtil.class);

    private static Extent doGetExtent(String url) throws Exception {
        Extent ext = null;
        try (NetcdfDataset ncd = NetcdfDatasets.openDataset((String)url);){
            ext = ThreddsExtentUtil.getExtent(ncd);
        }
        catch (Exception e) {
            e.printStackTrace();
            String err = "Could not load NETCDF file: " + url + " because of Exception. " + e.getLocalizedMessage();
            _log.error(err, (Throwable)e);
        }
        return ext;
    }

    private static boolean variableHasAttribute(Variable var, String attribute, String ... values) {
        if (values == null || values.length == 0) {
            return false;
        }
        Attribute attr = var.attributes().findAttributeIgnoreCase(attribute);
        if (attr == null) {
            return false;
        }
        String attrValue = attr.getStringValue();
        if (attrValue == null) {
            return false;
        }
        for (String value : values) {
            if (!attrValue.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    private static boolean variableHasFullName(Variable var, String ... varNames) {
        if (varNames == null || varNames.length == 0) {
            return false;
        }
        for (String varName : varNames) {
            if (!var.getFullName().equalsIgnoreCase(varName)) continue;
            return true;
        }
        return false;
    }

    private static boolean variableHasStdName(Variable var, String ... stdNames) {
        return ThreddsExtentUtil.variableHasAttribute(var, "standard_name", stdNames);
    }

    private static boolean variableHasUnits(Variable var, String ... unitsArr) {
        return ThreddsExtentUtil.variableHasAttribute(var, "units", unitsArr);
    }

    private static Variable findLatVar(List<Variable> vars) {
        for (Variable var : vars) {
            if (!ThreddsExtentUtil.variableHasStdName(var, "latitude", "grid_latitude")) continue;
            return var;
        }
        for (Variable var : vars) {
            if (!ThreddsExtentUtil.variableHasUnits(var, "degrees_north")) continue;
            return var;
        }
        return null;
    }

    private static Variable findLonVar(List<Variable> vars) {
        for (Variable var : vars) {
            if (!ThreddsExtentUtil.variableHasStdName(var, "longitude", "grid_longitude")) continue;
            return var;
        }
        for (Variable var : vars) {
            if (!ThreddsExtentUtil.variableHasUnits(var, "degrees_east")) continue;
            return var;
        }
        return null;
    }

    private static CoordinateAxis findAxisByType(List<CoordinateAxis> coordAxes, AxisType axisType) {
        for (CoordinateAxis axis : coordAxes) {
            if (axis.getAxisType() != axisType) continue;
            return axis;
        }
        return null;
    }

    private static CoordinateAxis findTimeAxis(List<CoordinateAxis> coordAxes) {
        ArrayList timeAxes = Lists.newArrayList();
        for (CoordinateAxis axis : coordAxes) {
            if (axis.getAxisType() != AxisType.Time || !ThreddsExtentUtil.variableHasStdName((Variable)axis, "time")) continue;
            timeAxes.add(axis);
        }
        if (timeAxes.size() == 1) {
            return (CoordinateAxis)timeAxes.get(0);
        }
        if (timeAxes.size() > 1) {
            for (CoordinateAxis timeAxis : timeAxes) {
                if (!ThreddsExtentUtil.variableHasFullName((Variable)timeAxis, "TIME")) continue;
                return timeAxis;
            }
            return (CoordinateAxis)timeAxes.get(0);
        }
        for (CoordinateAxis axis : coordAxes) {
            if (axis.getAxisType() != AxisType.Time || !ThreddsExtentUtil.variableHasFullName((Variable)axis, "TIME")) continue;
            return axis;
        }
        return null;
    }

    private static CoordinateAxis findHeightAxis(List<CoordinateAxis> coordAxes) {
        for (CoordinateAxis axis : coordAxes) {
            if (axis.getAxisType() != AxisType.Height || !ThreddsExtentUtil.variableHasStdName((Variable)axis, "depth", "height", "altitude")) continue;
            return axis;
        }
        for (CoordinateAxis axis : coordAxes) {
            if (axis.getAxisType() != AxisType.Height || !ThreddsExtentUtil.variableHasFullName((Variable)axis, "depth", "height", "altitude", "z")) continue;
            return axis;
        }
        return null;
    }

    private static Extent doGetExtent(NetcdfDataset ncd) throws Exception {
        double maxLon = -9999.999;
        double minLon = 9999.999;
        double maxLat = -9999.999;
        double minLat = 9999.999;
        Extent ext = new Extent();
        ImmutableList coordAxes = ncd.getCoordinateAxes();
        ImmutableList vars = ncd.getVariables();
        try {
            CoordinateAxis heightAxis;
            CoordinateAxis timeAxis;
            Variable lonVar;
            Variable latVar = ThreddsExtentUtil.findLatVar((List<Variable>)vars);
            if (latVar != null) {
                ext._latUnits = latVar.getUnitsString();
                Array vals = latVar.read();
                long latSize = vals.getSize();
                int i = 0;
                while ((long)i < vals.getSize()) {
                    double lat = vals.getDouble(i);
                    if (lat > maxLat) {
                        maxLat = lat;
                    }
                    if (lat < minLat) {
                        minLat = lat;
                    }
                    ++i;
                }
                if (minLat != 9999.999) {
                    ext._minLat = minLat;
                }
                if (maxLat != 9999.999) {
                    ext._maxLat = maxLat;
                }
                ext._latRes = 0.0;
                if (latSize - 1L > 0L) {
                    ext._latRes = (maxLat - minLat) / (double)(latSize - 1L);
                }
            }
            if ((lonVar = ThreddsExtentUtil.findLonVar((List<Variable>)vars)) != null) {
                ext._lonUnits = lonVar.getUnitsString();
                Array vals = lonVar.read();
                long lonSize = vals.getSize();
                int i = 0;
                while ((long)i < vals.getSize()) {
                    double lon = vals.getDouble(i);
                    if (lon > maxLon) {
                        maxLon = lon;
                    }
                    if (lon < minLon) {
                        minLon = lon;
                    }
                    ++i;
                }
                if (minLon != 9999.999) {
                    ext._minLon = minLon;
                }
                if (maxLon != 9999.999) {
                    ext._maxLon = maxLon;
                }
                ext._lonRes = 0.0;
                if (lonSize - 1L > 0L) {
                    ext._lonRes = (maxLat - minLat) / (double)(lonSize - 1L);
                }
            }
            if ((timeAxis = ThreddsExtentUtil.findTimeAxis((List<CoordinateAxis>)coordAxes)) != null) {
                _log.info("numTimeElems=" + timeAxis.getSize());
                _log.info("axisName=" + timeAxis.getFullName());
                ThreddsExtentUtil.logAvailableMemory("Retrieving Time coordAxis values");
                ext._minTime = Double.toString(timeAxis.getMinValue());
                ext._maxTime = Double.toString(timeAxis.getMaxValue());
                String rawMinTime = Double.toString(timeAxis.getMinValue());
                String rawMaxTime = Double.toString(timeAxis.getMaxValue());
                _log.info("udunits string = " + rawMinTime + " " + timeAxis.getUnitsString());
                Date startDate = DateUnit.getStandardDate((String)(rawMinTime + " " + timeAxis.getUnitsString()));
                Date endDate = DateUnit.getStandardDate((String)(rawMaxTime + " " + timeAxis.getUnitsString()));
                DateFormatter df = new DateFormatter();
                ext._minTime = df.toDateTimeStringISO(startDate);
                ext._maxTime = df.toDateTimeStringISO(endDate);
                long duration = endDate.getTime() - startDate.getTime();
                ext._timeDuration = DurationFormatUtils.formatDurationISO((long)duration);
                double timeRes = 0.0;
                if (timeAxis.getSize() - 1L > 0L) {
                    timeRes = duration / 1000L / (timeAxis.getSize() - 1L);
                }
                ext._timeRes = Double.toString(timeRes);
                ext._timeUnits = "seconds";
            }
            if ((heightAxis = ThreddsExtentUtil.findHeightAxis((List<CoordinateAxis>)coordAxes)) != null) {
                _log.info("axisName=" + heightAxis.getFullName());
                ext._minHeight = heightAxis.getMinValue();
                ext._maxHeight = heightAxis.getMaxValue();
                ext._heightUnits = heightAxis.getUnitsString();
                ext._vOrientation = heightAxis.getPositive();
                ext._heightRes = 0.0;
                if (heightAxis.getSize() - 1L > 0L) {
                    ext._heightRes = (heightAxis.getMaxValue() - heightAxis.getMinValue()) / (double)(heightAxis.getSize() - 1L);
                }
            }
        }
        catch (Exception e) {
            _log.error("Error in doGetExtent", (Throwable)e);
        }
        return ext;
    }

    private static Extent doGetExtentByAxis(NetcdfDataset ncd) throws Exception {
        Extent ext = new Extent();
        ImmutableList coordAxes = ncd.getCoordinateAxes();
        try {
            CoordinateAxis heightAxis;
            CoordinateAxis lonAxis;
            CoordinateAxis latAxis;
            CoordinateAxis timeAxis = ThreddsExtentUtil.findTimeAxis((List<CoordinateAxis>)coordAxes);
            if (timeAxis != null) {
                _log.info("numTimeElems=" + timeAxis.getSize());
                _log.info("axisName=" + timeAxis.getFullName());
                ThreddsExtentUtil.logAvailableMemory("Retrieving Time coordAxis values");
                ext._minTime = Double.toString(timeAxis.getMinValue());
                ext._maxTime = Double.toString(timeAxis.getMaxValue());
                String rawMinTime = Double.toString(timeAxis.getMinValue());
                String rawMaxTime = Double.toString(timeAxis.getMaxValue());
                _log.info("udunits string = " + rawMinTime + " " + timeAxis.getUnitsString());
                Date startDate = DateUnit.getStandardDate((String)(rawMinTime + " " + timeAxis.getUnitsString()));
                Date endDate = DateUnit.getStandardDate((String)(rawMaxTime + " " + timeAxis.getUnitsString()));
                DateFormatter df = new DateFormatter();
                ext._minTime = df.toDateTimeStringISO(startDate);
                ext._maxTime = df.toDateTimeStringISO(endDate);
                long duration = endDate.getTime() - startDate.getTime();
                ext._timeDuration = DurationFormatUtils.formatDurationISO((long)duration);
                double timeRes = 0.0;
                if (timeAxis.getSize() - 1L > 0L) {
                    timeRes = duration / 1000L / (timeAxis.getSize() - 1L);
                }
                ext._timeRes = Double.toString(timeRes);
                ext._timeUnits = "seconds";
            }
            if ((latAxis = ThreddsExtentUtil.findAxisByType((List<CoordinateAxis>)coordAxes, AxisType.Lat)) != null) {
                ext._minLat = latAxis.getMinValue();
                ext._maxLat = latAxis.getMaxValue();
                ext._latUnits = latAxis.getUnitsString();
                ext._latRes = 0.0;
                if (latAxis.getSize() - 1L > 0L) {
                    ext._latRes = (latAxis.getMaxValue() - latAxis.getMinValue()) / (double)(latAxis.getSize() - 1L);
                }
            }
            if ((lonAxis = ThreddsExtentUtil.findAxisByType((List<CoordinateAxis>)coordAxes, AxisType.Lon)) != null) {
                ext._minLon = lonAxis.getMinValue();
                ext._maxLon = lonAxis.getMaxValue();
                ext._lonUnits = lonAxis.getUnitsString();
                ext._lonRes = 0.0;
                if (lonAxis.getSize() - 1L > 0L) {
                    ext._lonRes = (lonAxis.getMaxValue() - lonAxis.getMinValue()) / (double)(lonAxis.getSize() - 1L);
                }
            }
            if ((heightAxis = ThreddsExtentUtil.findHeightAxis((List<CoordinateAxis>)coordAxes)) != null) {
                _log.info("axisName=" + heightAxis.getFullName());
                ext._minHeight = heightAxis.getMinValue();
                ext._maxHeight = heightAxis.getMaxValue();
                ext._heightUnits = heightAxis.getUnitsString();
                ext._vOrientation = heightAxis.getPositive();
                ext._heightRes = 0.0;
                if (heightAxis.getSize() - 1L > 0L) {
                    ext._heightRes = (heightAxis.getMaxValue() - heightAxis.getMinValue()) / (double)(heightAxis.getSize() - 1L);
                }
            }
        }
        catch (Exception e) {
            _log.error("Error in doGetExtentByAxis", (Throwable)e);
        }
        return ext;
    }

    public static Extent getExtent(String url) throws Exception {
        return ThreddsExtentUtil.doGetExtent(url);
    }

    public static Extent getExtent(NetcdfDataset ncd) throws Exception {
        if (FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncd) != null && FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncd) != FeatureType.GRID) {
            _log.info("FeatureType is not null && not a grid getting extent by reading arrays: " + FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncd));
            return ThreddsExtentUtil.doGetExtent(ncd);
        }
        _log.info("FeatureType is null or a GRID getting extent from axes: " + FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncd));
        return ThreddsExtentUtil.doGetExtentByAxis(ncd);
    }

    private static void logAvailableMemory(String message) {
        int mb = 0x100000;
        _log.debug(message);
        _log.info("Total Memory: " + Runtime.getRuntime().totalMemory() / (long)mb);
        _log.info("Free Memory: " + Runtime.getRuntime().freeMemory() / (long)mb);
    }
}

