/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.eds.util;

import gov.noaa.eds.util.FileUtility;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WafScoreCalculator {
    public static void getSummary(String dir) {
        FileUtility fu = new FileUtility(dir);
        String[] wafFiles = fu.fileListing(".html");
        fu.close();
        int total = 0;
        int fileCnt = 0;
        for (String wafFile : wafFiles) {
            System.out.println(wafFile);
            fu = new FileUtility(dir + wafFile);
            int score = WafScoreCalculator.getScore(fu);
            if (score > -1) {
                total += score;
                ++fileCnt;
            }
            fu.close();
        }
        float avgScore = total / fileCnt;
        System.out.println("Number of Files: " + fileCnt + " Mean: " + avgScore);
    }

    private static int getScore(FileUtility fu) {
        int score = -1;
        try {
            String searchString = fu.readFile();
            String expr = "<h2>Total Score: ([^/]+)";
            Pattern patt = Pattern.compile(expr, 33);
            Matcher m3 = patt.matcher(searchString);
            while (m3.find()) {
                System.out.println("Score: " + m3.group(1));
                score = Integer.parseInt(m3.group(1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return score;
    }

    public static void main(String[] args) {
        String dir = "c:/temp/waf/";
        WafScoreCalculator.getSummary(dir);
    }
}

