/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingDefault;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.nc2.write.NetcdfFormatWriter;

@Immutable
public class CFPointWriterConfig {
    private final Nc4Chunking chunking;
    private final boolean noTimeCoverage;
    private final NetcdfFileFormat format;

    public Nc4Chunking getChunking() {
        return this.chunking;
    }

    boolean isNoTimeCoverage() {
        return this.noTimeCoverage;
    }

    public NetcdfFileFormat getFormat() {
        return this.format;
    }

    public NetcdfFileWriter.Version getVersion() {
        return NetcdfFormatWriter.convertToNetcdfFileWriterVersion(this.format);
    }

    private CFPointWriterConfig(Builder builder) {
        this.format = builder.format;
        this.chunking = builder.chunking;
        this.noTimeCoverage = builder.noTimeCoverage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        NetcdfFileFormat format = NetcdfFileFormat.NETCDF3;
        Nc4Chunking chunking = new Nc4ChunkingDefault();
        boolean noTimeCoverage;

        public Builder setFormat(NetcdfFileFormat format) {
            this.format = format;
            return this;
        }

        public Builder setChunking(Nc4Chunking chunking) {
            this.chunking = chunking;
            return this;
        }

        public Builder setNoTimeCoverage(boolean noTimeCoverage) {
            this.noTimeCoverage = noTimeCoverage;
            return this;
        }

        public CFPointWriterConfig build() {
            return new CFPointWriterConfig(this);
        }
    }
}

