/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.RuleBasedCollator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SubstringAfter
extends CollatingFunctionFixed {
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg1 = (StringValue)arguments[0].head();
        StringValue arg2 = (StringValue)arguments[1].head();
        return SubstringAfter.substringAfter(arg1, arg2, this.getStringCollator());
    }

    private static StringValue substringAfter(StringValue arg1, StringValue arg2, StringCollator collator) throws XPathException {
        if (arg1 == null) {
            arg1 = StringValue.EMPTY_STRING;
        }
        if (arg2 == null) {
            arg2 = StringValue.EMPTY_STRING;
        }
        if (arg2.isZeroLength()) {
            return arg1;
        }
        if (arg1.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        String s1 = arg1.getStringValue();
        String s2 = arg2.getStringValue();
        String result = null;
        if (collator instanceof CodepointCollator) {
            int i = s1.indexOf(s2);
            result = i < 0 ? "" : s1.substring(i + s2.length());
        } else {
            if (collator instanceof SimpleCollation && ((SimpleCollation)collator).getComparator() instanceof RuleBasedCollator) {
                collator = new RuleBasedSubstringMatcher(collator.getCollationURI(), (RuleBasedCollator)((SimpleCollation)collator).getComparator());
            }
            if (collator instanceof SubstringMatcher) {
                result = ((SubstringMatcher)collator).substringAfter(s1, s2);
            } else {
                throw new XPathException("The collation requested for fn:substring-after does not support substring matching", "FOCH0004");
            }
        }
        StringValue s3 = StringValue.makeStringValue(result);
        if (arg1.isKnownToContainNoSurrogates()) {
            s3.setContainsNoSurrogates();
        }
        return s3;
    }
}

