/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.eds.threddsutilities.service.impl;

import gov.noaa.eds.threddsutilities.bean.MetadataContainer;
import gov.noaa.eds.threddsutilities.service.iface.ICatalogCrawler;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.server.metadata.nciso.exception.ThreddsUtilitiesException;

public class CatalogCrawlerImpl
implements ICatalogCrawler {
    private static Logger logger = LoggerFactory.getLogger(CatalogCrawlerImpl.class);
    private static Vector<ServiceType> allowableTypes = new Vector(0);
    private Dataset lastParent = null;
    private int _actualDepthCount;
    private int _actualLeafCount;

    @Override
    public synchronized void crawlThredds(String url, int maxDepth, int maxLeaves, Vector<MetadataContainer> mdcs) throws ThreddsUtilitiesException {
        CatalogBuilder factory = new CatalogBuilder();
        Catalog catalog = factory.buildFromLocation(url, null);
        StringBuilder sb = new StringBuilder();
        List<Dataset> threddsDatasets = catalog.getDatasets();
        for (Dataset ds : threddsDatasets) {
            if (ds.hasNestedDatasets()) {
                for (Dataset ds2 : ds.getDatasets()) {
                    this.getDataset(ds2, mdcs, maxDepth, maxLeaves);
                }
                continue;
            }
            this.getDataset(ds, mdcs, maxDepth, maxLeaves);
        }
    }

    private void getDataset(Dataset dataset, Vector<MetadataContainer> mdcs, int maxDepth, int maxLeaves) {
        Dataset parent = null;
        logger.info("maxDepth: " + maxDepth + " depth: " + this._actualDepthCount + " dataset.getFullName():" + dataset.getName() + "; dataset.hasAccess(): " + dataset.hasAccess() + " maxLeaves: " + maxLeaves + " leafcnt: " + this._actualLeafCount);
        if (dataset.hasAccess()) {
            for (Access access : dataset.getAccess()) {
                if (!allowableTypes.contains((Object)access.getService().getType())) continue;
                logger.info("allowable service");
                parent = dataset.getParentDataset();
                MetadataContainer mdc = new MetadataContainer(dataset);
                String lastParentName = "NULL";
                String parentName = "NULL";
                if (this.lastParent != null) {
                    lastParentName = this.lastParent.getName();
                }
                if (parent != null) {
                    parentName = parent.getName();
                }
                if (this.lastParent != null && parent != null && !parent.getName().equals(this.lastParent.getName())) {
                    logger.info("New Parent");
                    this._actualLeafCount = 0;
                }
                ++this._actualLeafCount;
                if (this._actualLeafCount > maxLeaves) break;
                logger.info("adding mdc");
                mdcs.add(mdc);
                this.lastParent = parent;
                break;
            }
        } else if (maxDepth == -1 || maxDepth != this._actualDepthCount) {
            ++this._actualDepthCount;
            if (dataset.hasNestedDatasets()) {
                for (Dataset ds : dataset.getDatasets()) {
                    this.getDataset(ds, mdcs, maxDepth, maxLeaves);
                }
            }
        }
    }

    static {
        allowableTypes.add(ServiceType.DODS);
        allowableTypes.add(ServiceType.OPENDAP);
    }
}

