/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.Iterator;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.trie.ImmutableHashTrieMap;
import net.sf.saxon.ma.trie.ImmutableMap;
import net.sf.saxon.ma.trie.Option;
import net.sf.saxon.ma.trie.Tuple2;
import net.sf.saxon.om.AbstractItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashTrieMap
extends AbstractItem
implements MapItem,
GroundedValue {
    public static final SequenceType SINGLE_MAP_TYPE = SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384);
    private ImmutableMap<AtomicMatchKey, KeyValuePair> imap;
    private AtomicType keyType;
    private ItemType valueType;
    private int valueCardinality;
    private int entries = -1;
    private XPathContext context;

    public HashTrieMap(XPathContext context) {
        this.setContext(context);
        this.imap = ImmutableHashTrieMap.empty();
        this.entries = 0;
    }

    public static HashTrieMap singleton(AtomicValue key, Sequence value, XPathContext context) throws XPathException {
        return new HashTrieMap(context).addEntry(key, value);
    }

    public HashTrieMap(ImmutableMap<AtomicMatchKey, KeyValuePair> imap, XPathContext context) throws NoDynamicContextException {
        this.setContext(context);
        this.imap = imap;
        this.entries = -1;
    }

    public static HashTrieMap copy(MapItem map, XPathContext context) throws XPathException {
        if (map instanceof HashTrieMap) {
            return (HashTrieMap)map;
        }
        HashTrieMap m22 = new HashTrieMap(context);
        ImmutableMap<AtomicMatchKey, KeyValuePair> imap = ImmutableHashTrieMap.empty();
        int entries = 0;
        for (KeyValuePair pair : map) {
            imap = imap.put((Object)m22.makeKey(pair.key), (Object)pair);
            ++entries;
        }
        m22.imap = imap;
        m22.entries = entries;
        m22.computeTypeInformation();
        return m22;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        throw new XPathException("Maps cannot be atomized", "FOTY0013");
    }

    private void setContext(XPathContext context) {
        this.context = context;
    }

    private void updateTypeInformation(AtomicValue key, Sequence val) {
        TypeHierarchy th = this.context.getConfiguration().getTypeHierarchy();
        if (this.keyType == null) {
            this.keyType = key.getItemType();
            this.valueType = SequenceTool.getItemType(val, th);
            this.valueCardinality = SequenceTool.getCardinality(val);
        } else {
            this.keyType = (AtomicType)Type.getCommonSuperType(this.keyType, key.getItemType(), th);
            this.valueType = Type.getCommonSuperType(this.valueType, SequenceTool.getItemType(val, th), th);
            this.valueCardinality = Cardinality.union(this.valueCardinality, SequenceTool.getCardinality(val));
        }
    }

    @Override
    public int size() {
        if (this.entries >= 0) {
            return this.entries;
        }
        int count = 0;
        for (KeyValuePair entry : this) {
            ++count;
        }
        this.entries = count;
        return this.entries;
    }

    @Override
    public boolean isEmpty() {
        return this.entries == 0 || !this.imap.iterator().hasNext();
    }

    @Override
    public AtomicType getKeyType() {
        if (this.isEmpty()) {
            return ErrorType.getInstance();
        }
        this.computeTypeInformation();
        return this.keyType;
    }

    @Override
    public UType getKeyUType() {
        return UType.ANY_ATOMIC.except(UType.QNAME).except(UType.NOTATION);
    }

    private void computeTypeInformation() {
        if (this.keyType == null) {
            TypeHierarchy th = this.context.getConfiguration().getTypeHierarchy();
            for (KeyValuePair kvp : this) {
                AtomicValue key = kvp.key;
                Sequence value = kvp.value;
                if (this.keyType == null) {
                    this.keyType = key.getItemType();
                    this.valueType = SequenceTool.getItemType(value, th);
                    this.valueCardinality = SequenceTool.getCardinality(value);
                    continue;
                }
                this.updateTypeInformation(key, value);
            }
        }
    }

    @Override
    public SequenceType getValueType() {
        if (this.isEmpty()) {
            return SequenceType.VOID;
        }
        this.computeTypeInformation();
        return SequenceType.makeSequenceType(this.valueType, this.valueCardinality);
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    public HashTrieMap addEntry(AtomicValue key, Sequence value) throws XPathException {
        HashTrieMap t2;
        ImmutableMap<AtomicMatchKey, KeyValuePair> imap2 = this.imap.put(this.makeKey(key), new KeyValuePair(key, value));
        try {
            t2 = new HashTrieMap(imap2, this.context);
        }
        catch (NoDynamicContextException e) {
            throw new IllegalStateException(e);
        }
        t2.valueCardinality = this.valueCardinality;
        t2.keyType = this.keyType;
        t2.valueType = this.valueType;
        t2.updateTypeInformation(key, value);
        return t2;
    }

    public boolean initialPut(AtomicValue key, Sequence value) {
        boolean exists = this.get(key) != null;
        this.imap = this.imap.put(this.makeKey(key), new KeyValuePair(key, value));
        this.updateTypeInformation(key, value);
        this.entries = -1;
        return exists;
    }

    private AtomicMatchKey makeKey(AtomicValue key) {
        return key.asMapKey();
    }

    @Override
    public HashTrieMap remove(AtomicValue key) throws XPathException {
        ImmutableMap<AtomicMatchKey, KeyValuePair> m22 = this.imap.remove(this.makeKey(key));
        if (m22 == this.imap) {
            return this;
        }
        HashTrieMap map = new HashTrieMap(m22, this.context);
        return map;
    }

    @Override
    public Sequence get(AtomicValue key) {
        Option<KeyValuePair> o = this.imap.get(this.makeKey(key));
        if (o.isDefined()) {
            return o.get().value;
        }
        return null;
    }

    public KeyValuePair getKeyValuePair(AtomicValue key) {
        Option<KeyValuePair> kvp = this.imap.get(this.makeKey(key));
        if (kvp.isDefined()) {
            return kvp.get();
        }
        return null;
    }

    @Override
    public AtomicIterator keys() {
        return new AtomicIterator(){
            int pos = 0;
            Iterator<Tuple2<AtomicMatchKey, KeyValuePair>> base = HashTrieMap.access$000(HashTrieMap.this).iterator();

            public AtomicValue next() {
                if (this.base.hasNext()) {
                    AtomicValue curr = ((KeyValuePair)this.base.next()._2).key;
                    ++this.pos;
                    return curr;
                }
                this.pos = -1;
                return null;
            }

            public AtomicIterator getAnother() {
                return HashTrieMap.this.keys();
            }

            public void close() {
            }

            public int getProperties() {
                return 0;
            }
        };
    }

    @Override
    public Iterator<KeyValuePair> iterator() {
        return new Iterator<KeyValuePair>(){
            Iterator<Tuple2<AtomicMatchKey, KeyValuePair>> base;
            {
                this.base = HashTrieMap.this.imap.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public KeyValuePair next() {
                return (KeyValuePair)this.base.next()._2;
            }

            @Override
            public void remove() {
                this.base.remove();
            }
        };
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        return MapType.ANY_MAP_TYPE;
    }

    @Override
    public StructuredQName getFunctionName() {
        return null;
    }

    @Override
    public String getDescription() {
        return "map";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        AtomicValue key = (AtomicValue)args[0].head();
        Sequence value = this.get(key);
        if (value == null) {
            return EmptySequence.getInstance();
        }
        return value;
    }

    @Override
    public String getStringValue() {
        throw new UnsupportedOperationException("A map has no string value");
    }

    @Override
    public CharSequence getStringValueCS() {
        throw new UnsupportedOperationException("A map has no string value");
    }

    public SequenceIterator getTypedValue() throws XPathException {
        throw new XPathException("A map has no typed value");
    }

    @Override
    public boolean deepEquals(Function other, XPathContext context, AtomicComparer comparer, int flags) throws XPathException {
        if (other instanceof MapItem && ((MapItem)other).size() == this.size()) {
            AtomicValue key;
            AtomicIterator keys = this.keys();
            while ((key = keys.next()) != null) {
                Sequence thisValue = this.get(key);
                Sequence otherValue = ((MapItem)other).get(key);
                if (otherValue == null) {
                    return false;
                }
                if (DeepEqual.deepEqual(otherValue.iterate(), thisValue.iterate(), comparer, context, flags)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public MapItem itemAt(int n) {
        return n == 0 ? this : null;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("A map item has no effective boolean value");
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("map");
        out.emitAttribute("size", this.size() + "");
        out.endElement();
    }

    @Override
    public boolean isTrustedResultType() {
        return false;
    }
}

