/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public class DurationValue
extends AtomicValue
implements AtomicMatchKey {
    protected boolean negative = false;
    protected int months = 0;
    protected long seconds = 0L;
    protected int microseconds = 0;

    protected DurationValue() {
    }

    public DurationValue(boolean positive, int years, int months, int days, int hours, int minutes, long seconds, int microseconds) throws IllegalArgumentException {
        this(positive, years, months, days, hours, minutes, seconds, microseconds, BuiltInAtomicType.DURATION);
    }

    public DurationValue(boolean positive, int years, int months, int days, int hours, int minutes, long seconds, int microseconds, AtomicType type) {
        boolean bl = this.negative = !positive;
        if (years < 0 || months < 0 || days < 0 || hours < 0 || minutes < 0 || seconds < 0L || microseconds < 0) {
            throw new IllegalArgumentException("Negative component value");
        }
        if ((double)years * 12.0 + (double)months > 2.147483647E9) {
            throw new IllegalArgumentException("Duration months limit exceeded");
        }
        if ((double)days * 86400.0 + (double)hours * 3600.0 + (double)minutes * 60.0 + (double)seconds > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this.months = years * 12 + months;
        long h2 = (long)days * 24L + (long)hours;
        long m3 = h2 * 60L + (long)minutes;
        this.seconds = m3 * 60L + seconds;
        this.microseconds = microseconds;
        this.normalizeZeroDuration();
        this.typeLabel = type;
    }

    protected void normalizeZeroDuration() {
        if (this.months == 0 && this.seconds == 0L && this.microseconds == 0) {
            this.negative = false;
        }
    }

    public static ConversionResult makeDuration(CharSequence s2) {
        return DurationValue.makeDuration(s2, true, true);
    }

    protected static ConversionResult makeDuration(CharSequence s2, boolean allowYM, boolean allowDT) {
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int microseconds = 0;
        boolean negative = false;
        StringTokenizer tok = new StringTokenizer(Whitespace.trimWhitespace(s2).toString(), "-+.PYMDTHS", true);
        int components = 0;
        if (!tok.hasMoreElements()) {
            return DurationValue.badDuration("empty string", s2);
        }
        String part = (String)tok.nextElement();
        if ("+".equals(part)) {
            return DurationValue.badDuration("+ sign not allowed in a duration", s2);
        }
        if ("-".equals(part)) {
            negative = true;
            part = (String)tok.nextElement();
        }
        if (!"P".equals(part)) {
            return DurationValue.badDuration("missing 'P'", s2);
        }
        int state = 0;
        block10: while (tok.hasMoreElements()) {
            int value;
            part = (String)tok.nextElement();
            if ("T".equals(part)) {
                state = 4;
                if (!tok.hasMoreElements()) {
                    return DurationValue.badDuration("T must be followed by time components", s2);
                }
                part = (String)tok.nextElement();
            }
            if ((value = DurationValue.simpleInteger(part)) < 0) {
                if (value == -2) {
                    return DurationValue.badDuration("component of duration exceeds Saxon limits", s2, "FODT0002");
                }
                return DurationValue.badDuration("invalid or non-numeric component", s2);
            }
            if (!tok.hasMoreElements()) {
                return DurationValue.badDuration("missing unit letter at end", s2);
            }
            char delim = ((String)tok.nextElement()).charAt(0);
            switch (delim) {
                case 'Y': {
                    if (state > 0) {
                        return DurationValue.badDuration("Y is out of sequence", s2);
                    }
                    if (!allowYM) {
                        return DurationValue.badDuration("Year component is not allowed in dayTimeDuration", s2);
                    }
                    years = value;
                    state = 1;
                    ++components;
                    continue block10;
                }
                case 'M': {
                    if (state == 4 || state == 5) {
                        if (!allowDT) {
                            return DurationValue.badDuration("Minute component is not allowed in yearMonthDuration", s2);
                        }
                        minutes = value;
                        state = 6;
                        ++components;
                        continue block10;
                    }
                    if (state == 0 || state == 1) {
                        if (!allowYM) {
                            return DurationValue.badDuration("Month component is not allowed in dayTimeDuration", s2);
                        }
                        months = value;
                        state = 2;
                        ++components;
                        continue block10;
                    }
                    return DurationValue.badDuration("M is out of sequence", s2);
                }
                case 'D': {
                    if (state > 2) {
                        return DurationValue.badDuration("D is out of sequence", s2);
                    }
                    if (!allowDT) {
                        return DurationValue.badDuration("Day component is not allowed in yearMonthDuration", s2);
                    }
                    days = value;
                    state = 3;
                    ++components;
                    continue block10;
                }
                case 'H': {
                    if (state != 4) {
                        return DurationValue.badDuration("H is out of sequence", s2);
                    }
                    if (!allowDT) {
                        return DurationValue.badDuration("Hour component is not allowed in yearMonthDuration", s2);
                    }
                    hours = value;
                    state = 5;
                    ++components;
                    continue block10;
                }
                case '.': {
                    if (state < 4 || state > 6) {
                        return DurationValue.badDuration("misplaced decimal point", s2);
                    }
                    seconds = value;
                    state = 7;
                    continue block10;
                }
                case 'S': {
                    if (state < 4 || state > 7) {
                        return DurationValue.badDuration("S is out of sequence", s2);
                    }
                    if (!allowDT) {
                        return DurationValue.badDuration("Seconds component is not allowed in yearMonthDuration", s2);
                    }
                    if (state == 7) {
                        while (part.length() < 6) {
                            part = part + "0";
                        }
                        if (part.length() > 6) {
                            part = part.substring(0, 6);
                        }
                        if ((value = DurationValue.simpleInteger(part)) < 0) {
                            return DurationValue.badDuration("non-numeric fractional seconds", s2);
                        }
                        microseconds = value;
                    } else {
                        seconds = value;
                    }
                    state = 8;
                    ++components;
                    continue block10;
                }
            }
            return DurationValue.badDuration("misplaced " + delim, s2);
        }
        if (components == 0) {
            return DurationValue.badDuration("Duration specifies no components", s2);
        }
        try {
            return new DurationValue(!negative, years, months, days, hours, minutes, seconds, microseconds, BuiltInAtomicType.DURATION);
        }
        catch (IllegalArgumentException err) {
            return new ValidationFailure(err.getMessage());
        }
    }

    protected static ValidationFailure badDuration(String msg, CharSequence s2) {
        ValidationFailure err = new ValidationFailure("Invalid duration value '" + s2 + "' (" + msg + ')');
        err.setErrorCode("FORG0001");
        return err;
    }

    protected static ValidationFailure badDuration(String msg, CharSequence s2, String errorCode) {
        ValidationFailure err = new ValidationFailure("Invalid duration value '" + s2 + "' (" + msg + ')');
        err.setErrorCode(errorCode);
        return err;
    }

    protected static int simpleInteger(String s2) {
        long result = 0L;
        int len = s2.length();
        if (len == 0) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                if ((result = result * 10L + (long)(c - 48)) <= Integer.MAX_VALUE) continue;
                return -2;
            }
            return -1;
        }
        return (int)result;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new DurationValue(!this.negative, 0, this.months, 0, 0, 0, this.seconds, this.microseconds, typeLabel);
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DURATION;
    }

    public int signum() {
        if (this.negative) {
            return -1;
        }
        if (this.months == 0 && this.seconds == 0L && this.microseconds == 0) {
            return 0;
        }
        return 1;
    }

    public int getYears() {
        return this.months / 12;
    }

    public int getMonths() {
        return this.months % 12;
    }

    public int getDays() {
        return (int)(this.seconds / 86400L);
    }

    public int getHours() {
        return (int)(this.seconds % 86400L / 3600L);
    }

    public int getMinutes() {
        return (int)(this.seconds % 3600L / 60L);
    }

    public int getSeconds() {
        return (int)(this.seconds % 60L);
    }

    public int getMicroseconds() {
        return this.microseconds;
    }

    public int getTotalMonths() {
        return this.negative ? -this.months : this.months;
    }

    public BigDecimal getTotalSeconds() {
        BigDecimal dec = new BigDecimal(this.negative ? -this.seconds : this.seconds);
        if (this.microseconds != 0) {
            dec = dec.add(new BigDecimal(BigInteger.valueOf(this.negative ? (long)(-this.microseconds) : (long)this.microseconds), -6));
        }
        return dec;
    }

    public CharSequence getPrimitiveStringValue() {
        if (this.months == 0 && this.seconds == 0L && this.microseconds == 0) {
            return "PT0S";
        }
        FastStringBuffer sb = new FastStringBuffer(32);
        if (this.negative) {
            sb.append('-');
        }
        int years = this.getYears();
        int months = this.getMonths();
        int days = this.getDays();
        int hours = this.getHours();
        int minutes = this.getMinutes();
        int seconds = this.getSeconds();
        sb.append("P");
        if (years != 0) {
            sb.append(years + "Y");
        }
        if (months != 0) {
            sb.append(months + "M");
        }
        if (days != 0) {
            sb.append(days + "D");
        }
        if (hours != 0 || minutes != 0 || seconds != 0 || this.microseconds != 0) {
            sb.append("T");
        }
        if (hours != 0) {
            sb.append(hours + "H");
        }
        if (minutes != 0) {
            sb.append(minutes + "M");
        }
        if (seconds != 0 || this.microseconds != 0) {
            if (seconds != 0 && this.microseconds == 0) {
                sb.append(seconds + "S");
            } else {
                long ms = seconds * 1000000 + this.microseconds;
                String mss = ms + "";
                if (seconds == 0) {
                    mss = "0000000" + mss;
                    mss = mss.substring(mss.length() - 7);
                }
                sb.append(mss.substring(0, mss.length() - 6));
                sb.append('.');
                int lastSigDigit = mss.length() - 1;
                while (mss.charAt(lastSigDigit) == '0') {
                    --lastSigDigit;
                }
                sb.append(mss.substring(mss.length() - 6, lastSigDigit + 1));
                sb.append('S');
            }
        }
        return sb;
    }

    public double getLengthInSeconds() {
        double a = (double)this.months * 30.43684991666667 * 24.0 * 60.0 * 60.0 + (double)this.seconds + (double)this.microseconds / 1000000.0;
        return this.negative ? -a : a;
    }

    public AtomicValue getComponent(AccessorFn.Component component) throws XPathException {
        switch (component) {
            case YEAR: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getYears()) : (long)this.getYears());
            }
            case MONTH: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getMonths()) : (long)this.getMonths());
            }
            case DAY: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getDays()) : (long)this.getDays());
            }
            case HOURS: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getHours()) : (long)this.getHours());
            }
            case MINUTES: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getMinutes()) : (long)this.getMinutes());
            }
            case SECONDS: {
                FastStringBuffer sb = new FastStringBuffer(16);
                String ms = "000000" + this.microseconds;
                ms = ms.substring(ms.length() - 6);
                sb.append((this.negative ? "-" : "") + this.getSeconds() + '.' + ms);
                return (AtomicValue)DecimalValue.makeDecimalValue(sb, false);
            }
            case WHOLE_SECONDS: {
                return Int64Value.makeIntegerValue(this.negative ? -this.seconds : this.seconds);
            }
            case MICROSECONDS: {
                return new Int64Value(this.negative ? (long)(-this.microseconds) : (long)this.microseconds);
            }
        }
        throw new IllegalArgumentException("Unknown component for duration: " + (Object)((Object)component));
    }

    public AtomicMatchKey getXPathComparable(boolean ordered, StringCollator collator, int implicitTimezone) {
        return ordered ? null : this;
    }

    public boolean equals(Object other) {
        if (other instanceof DurationValue) {
            DurationValue d1 = this;
            DurationValue d2 = (DurationValue)other;
            return d1.negative == d2.negative && d1.months == d2.months && d1.seconds == d2.seconds && d1.microseconds == d2.microseconds;
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.getLengthInSeconds()).hashCode();
    }

    public DurationValue add(DurationValue other) throws XPathException {
        XPathException err = new XPathException("Only subtypes of xs:duration can be added");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public DurationValue subtract(DurationValue other) throws XPathException {
        XPathException err = new XPathException("Only subtypes of xs:duration can be subtracted");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public DurationValue negate() {
        return new DurationValue(this.negative, 0, this.months, 0, 0, 0, this.seconds, this.microseconds, this.typeLabel);
    }

    public DurationValue multiply(double factor) throws XPathException {
        XPathException err = new XPathException("Only subtypes of xs:duration can be multiplied by a number");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public DecimalValue divide(DurationValue other) throws XPathException {
        XPathException err = new XPathException("Only subtypes of xs:duration can be divided by another duration");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public Comparable getSchemaComparable() {
        return DurationValue.getSchemaComparable(this);
    }

    public static Comparable getSchemaComparable(DurationValue value) {
        int m3 = value.months;
        double s2 = (double)value.seconds + (double)value.microseconds / 1000000.0;
        if (value.negative) {
            s2 = -s2;
            m3 = -m3;
        }
        return new DurationComparable(m3, s2);
    }

    private static class DurationComparable
    implements Comparable {
        private int months;
        private double seconds;

        public DurationComparable(int m3, double s2) {
            this.months = m3;
            this.seconds = s2;
        }

        public int compareTo(Object o) {
            DurationComparable other;
            if (o instanceof DurationComparable) {
                other = (DurationComparable)o;
            } else if (o instanceof YearMonthDurationValue) {
                other = (DurationComparable)DurationValue.getSchemaComparable((YearMonthDurationValue)o);
            } else if (o instanceof DayTimeDurationValue) {
                other = (DurationComparable)DurationValue.getSchemaComparable((DayTimeDurationValue)o);
            } else {
                return Integer.MIN_VALUE;
            }
            if (this.months == other.months) {
                return Double.compare(this.seconds, other.seconds);
            }
            if (this.seconds == other.seconds) {
                return this.months == other.months ? 0 : (this.months < other.months ? -1 : 1);
            }
            double oneDay = 86400.0;
            double min0 = (double)this.monthsToDaysMinimum(this.months) * oneDay + this.seconds;
            double max0 = (double)this.monthsToDaysMaximum(this.months) * oneDay + this.seconds;
            double min1 = (double)this.monthsToDaysMinimum(other.months) * oneDay + other.seconds;
            double max1 = (double)this.monthsToDaysMaximum(other.months) * oneDay + other.seconds;
            if (max0 < min1) {
                return -1;
            }
            if (min0 > max1) {
                return 1;
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return this.months ^ (int)this.seconds;
        }

        private int monthsToDaysMinimum(int months) {
            if (months < 0) {
                return -this.monthsToDaysMaximum(-months);
            }
            if (months < 12) {
                int[] shortest = new int[]{0, 28, 59, 89, 120, 150, 181, 212, 242, 273, 303, 334};
                return shortest[months];
            }
            int years = months / 12;
            int remainingMonths = months % 12;
            int yearDays = years * 365 + years % 4 - years % 100 + years % 400 - 1;
            return yearDays + this.monthsToDaysMinimum(remainingMonths);
        }

        private int monthsToDaysMaximum(int months) {
            if (months < 0) {
                return -this.monthsToDaysMinimum(-months);
            }
            if (months < 12) {
                int[] longest = new int[]{0, 31, 62, 92, 123, 153, 184, 215, 245, 276, 306, 337};
                return longest[months];
            }
            int years = months / 12;
            int remainingMonths = months % 12;
            int yearDays = years * 365 + years % 4 - years % 100 + years % 400 + 1;
            return yearDays + this.monthsToDaysMaximum(remainingMonths);
        }
    }
}

