/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.nciso.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLUtil {
    private static final Logger _log = LoggerFactory.getLogger(XMLUtil.class);
    private Document _doc = null;

    public XMLUtil(String fileName) {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setExpandEntities(false);
        try {
            this._doc = saxBuilder.build(fileName);
        }
        catch (JDOMException jde) {
            _log.error("JDOMException in XMLUtil: ", jde);
        }
        catch (IOException ioe) {
            _log.error("IOException in XMLUtil: ", ioe);
        }
    }

    public XMLUtil(InputStream is) {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setExpandEntities(false);
        try {
            this._doc = saxBuilder.build(is);
        }
        catch (JDOMException jde) {
            _log.error("JDOMException in XMLUtil: ", jde);
        }
        catch (IOException ioe) {
            _log.error("IOException in XMLUtil: ", ioe);
        }
    }

    public Document getDocument() {
        return this._doc;
    }

    public void listElements(List<Element> es, String indent) {
        for (Element e : es) {
            this.listElement(e, indent);
        }
    }

    public void listElement(Element e, String indent) {
        _log.debug(indent + "*Element, name:" + e.getName() + ", text:" + e.getText().trim());
        List<Attribute> as = e.getAttributes();
        XMLUtil.listAttributes(as, indent + " ");
        List<Element> c = e.getChildren();
        this.listElements(c, indent + " ");
    }

    public static void listAttributes(List<Attribute> as, String indent) {
        for (Attribute a : as) {
            System.out.println(indent + "*Attribute, name:" + a.getName() + ", value:" + a.getValue());
        }
    }

    public List<Element> elemFinder(String xPathExpr, String prefix, String nameSpace) {
        Namespace ns = Namespace.getNamespace(prefix, nameSpace);
        XPathExpression<Element> xpath = XPathFactory.instance().compile(xPathExpr, Filters.element(), null, ns);
        return xpath.evaluate(this._doc);
    }

    public void sortElements(Element parent, Comparator<Element> c) {
        List<Element> children = parent.getChildren();
        this.sort(children, c);
        ListIterator<Element> childrenIter = children.listIterator();
        ArrayList<Content> content = new ArrayList<Content>(parent.getContent());
        ListIterator<Element> contentIter = content.listIterator();
        while (contentIter.hasNext()) {
            Object obj = contentIter.next();
            if (!(obj instanceof Element)) continue;
            Element origChildElement = childrenIter.next();
            Element cloneChildElement = origChildElement.clone();
            cloneChildElement.detach();
            contentIter.set(cloneChildElement);
        }
        ArrayList emptyList = new ArrayList();
        parent.setContent(emptyList);
        parent.setContent(content);
    }

    private void sort(List<Element> list, Comparator<Element> c) {
        Element[] a = list.toArray(new Element[0]);
        Arrays.sort(a, c);
        for (Element element : a) {
            element.detach();
        }
        Collections.addAll(list, a);
    }

    public void write(String fileName) {
        try {
            FileWriter writer = new FileWriter(fileName);
            this.doWrite(writer);
        }
        catch (IOException e) {
            _log.error("IOException in XMLUtil: ", e);
        }
    }

    public void write(Writer writer) {
        this.doWrite(writer);
    }

    private void doWrite(Writer writer) {
        try {
            XMLOutputter outputter = new XMLOutputter();
            Format newFormat = Format.getCompactFormat();
            newFormat.setIndent("  ");
            outputter.setFormat(newFormat);
            outputter.output(this._doc, writer);
        }
        catch (IOException e) {
            _log.error("IOException in XMLUtil: ", e);
        }
    }
}

