/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.projection.Sinusoidal;

public class HdfEosModisConvention
extends CoordSysBuilder {
    private static final String CRS = "Projection";
    private static final String DATA_GROUP = "Data_Fields";
    private static final String DIMX_NAME = "XDim";
    private static final String DIMY_NAME = "YDim";
    private static final String TIME_NAME = "time";
    private boolean addTimeCoord;

    public static boolean isMine(NetcdfFile ncfile) {
        if (!ncfile.getFileTypeId().equals("HDF4-EOS")) {
            return false;
        }
        String typeName = ncfile.findAttValueIgnoreCase(null, "featureType", null);
        if (typeName == null) {
            return false;
        }
        if (!typeName.equals(FeatureType.GRID.toString()) && !typeName.equals(FeatureType.SWATH.toString())) {
            return false;
        }
        return HdfEosModisConvention.checkGroup(ncfile.getRootGroup());
    }

    private static boolean checkGroup(Group g2) {
        Variable crs = g2.findVariableLocal("_HDFEOS_CRS");
        Group dataG = g2.findGroupLocal(DATA_GROUP);
        if (crs != null && dataG != null) {
            Attribute att = crs.findAttribute(CRS);
            if (att == null) {
                return false;
            }
            if (!att.getStringValue().equals("GCTP_SNSOID") && !att.getStringValue().equals("GCTP_GEO")) {
                return false;
            }
            return dataG.findDimensionLocal(DIMX_NAME) != null && dataG.findDimensionLocal(DIMY_NAME) != null;
        }
        for (Group ng : g2.getGroups()) {
            if (!HdfEosModisConvention.checkGroup(ng)) continue;
            return true;
        }
        return false;
    }

    public HdfEosModisConvention() {
        this.conventionName = "HDF4-EOS-MODIS";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        this.addTimeCoord = this.addTimeCoordinate(ds);
        this.augmentGroup(ds, ds.getRootGroup());
        ds.addAttribute(ds.getRootGroup(), new Attribute("Conventions", "CF-1.0"));
        ds.finish();
    }

    private boolean addTimeCoordinate(NetcdfDataset ds) {
        CalendarDate cd2 = this.parseFilenameForDate(ds.getLocation());
        if (cd2 == null) {
            return false;
        }
        ds.addAttribute(ds.getRootGroup(), new Attribute("_MODIS_Date", cd2.toString()));
        int nTimesDim = 1;
        Dimension newDim = new Dimension(TIME_NAME, nTimesDim);
        ds.addDimension(null, newDim);
        String units = "seconds since " + cd2;
        String desc = "time coordinate";
        Array data = Array.makeArray(DataType.DOUBLE, 1, 0.0, 0.0);
        CoordinateAxis1D timeCoord = new CoordinateAxis1D(ds, null, TIME_NAME, DataType.DOUBLE, "", units, desc);
        timeCoord.setCachedData(data, true);
        timeCoord.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ds.addCoordinateAxis(timeCoord);
        return true;
    }

    private CalendarDate parseFilenameForDate(String filename) {
        String[] tokes = filename.split("\\.");
        if (tokes.length < 2) {
            return null;
        }
        if (tokes[1].length() < 8) {
            return null;
        }
        String want = tokes[1];
        String yearS = want.substring(1, 5);
        String jdayS = want.substring(5, 8);
        try {
            int year = Integer.parseInt(yearS);
            int jday = Integer.parseInt(jdayS);
            return CalendarDate.withDoy(null, year, jday, 0, 0, 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void augmentGroup(NetcdfDataset ds, Group g2) {
        Variable crs = g2.findVariableLocal("_HDFEOS_CRS");
        if (crs != null) {
            this.augmentGroupWithProjectionInfo(ds, g2);
        }
        for (Group ng : g2.getGroups()) {
            this.augmentGroup(ds, ng);
        }
    }

    private void augmentGroupWithProjectionInfo(NetcdfDataset ds, Group g2) {
        Dimension dimX = null;
        Dimension dimY = null;
        Group dataG = g2.findGroupLocal(DATA_GROUP);
        if (dataG != null) {
            dimX = dataG.findDimensionLocal(DIMX_NAME);
            dimY = dataG.findDimensionLocal(DIMY_NAME);
        }
        if (dimX == null || dimY == null) {
            return;
        }
        Variable crs = g2.findVariableLocal("_HDFEOS_CRS");
        Attribute projAtt = crs.findAttribute(CRS);
        if (projAtt != null) {
            Attribute upperLeft = crs.findAttribute("UpperLeftPointMtrs");
            Attribute lowerRight = crs.findAttribute("LowerRightMtrs");
            Attribute projParams = crs.findAttribute("ProjParams");
            double minX = upperLeft.getNumericValue(0).doubleValue();
            double minY = upperLeft.getNumericValue(1).doubleValue();
            double maxX = lowerRight.getNumericValue(0).doubleValue();
            double maxY = lowerRight.getNumericValue(1).doubleValue();
            boolean hasProjection = false;
            String coordinates = null;
            if (projAtt.getStringValue().equals("GCTP_SNSOID")) {
                hasProjection = true;
                ProjectionCT ct = this.makeSinusoidalProjection(CRS, projParams);
                VariableDS crss = this.makeCoordinateTransformVariable(ds, ct);
                crss.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
                ds.addVariable(dataG, crss);
                ds.addCoordinateAxis(this.makeCoordAxis(ds, dataG, DIMX_NAME, dimX.getLength(), minX, maxX, true));
                ds.addCoordinateAxis(this.makeCoordAxis(ds, dataG, DIMY_NAME, dimY.getLength(), minY, maxY, false));
                coordinates = this.addTimeCoord ? "time XDim YDim" : "XDim YDim";
            } else if (projAtt.getStringValue().equals("GCTP_GEO")) {
                ds.addCoordinateAxis(this.makeLatLonCoordAxis(ds, dataG, dimX.getLength(), minX * 1.0E-6, maxX * 1.0E-6, true));
                ds.addCoordinateAxis(this.makeLatLonCoordAxis(ds, dataG, dimY.getLength(), minY * 1.0E-6, maxY * 1.0E-6, false));
                coordinates = this.addTimeCoord ? "time Lat Lon" : "Lat Lon";
            }
            for (Variable v : dataG.getVariables()) {
                if (v.getRank() != 2 || !v.getDimension(0).equals(dimY) || !v.getDimension(1).equals(dimX)) continue;
                if (coordinates != null) {
                    v.addAttribute(new Attribute("coordinates", coordinates));
                }
                if (!hasProjection) continue;
                v.addAttribute(new Attribute("grid_mapping", CRS));
            }
        }
    }

    private CoordinateAxis makeCoordAxis(NetcdfDataset ds, Group g2, String name, int n, double start, double end, boolean isX) {
        CoordinateAxis1D v = new CoordinateAxis1D(ds, g2, name, DataType.DOUBLE, name, "km", isX ? "x coordinate" : "y coordinate");
        double incr = (end - start) / (double)n;
        v.setValues(n, start * 0.001, incr * 0.001);
        v.addAttribute(new Attribute("_CoordinateAxisType", isX ? AxisType.GeoX.toString() : AxisType.GeoY.toString()));
        return v;
    }

    private CoordinateAxis makeLatLonCoordAxis(NetcdfDataset ds, Group g2, int n, double start, double end, boolean isLon) {
        String name = isLon ? AxisType.Lon.toString() : AxisType.Lat.toString();
        String dimName = isLon ? DIMX_NAME : DIMY_NAME;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, g2, name, DataType.DOUBLE, dimName, isLon ? "degrees_east" : "degrees_north", null);
        double incr = (end - start) / (double)n;
        v.setValues(n, start, incr);
        v.addAttribute(new Attribute("_CoordinateAxisType", name));
        return v;
    }

    private ProjectionCT makeSinusoidalProjection(String name, Attribute projParams) {
        double radius = projParams.getNumericValue(0).doubleValue();
        double centMer = projParams.getNumericValue(4).doubleValue();
        double falseEast = projParams.getNumericValue(6).doubleValue();
        double falseNorth = projParams.getNumericValue(7).doubleValue();
        Sinusoidal proj = new Sinusoidal(centMer, falseEast * 0.001, falseNorth * 0.001, radius * 0.001);
        return new ProjectionCT(name, "FGDC", proj);
    }
}

