/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCCC;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;

public class FlattenedDatasetPointCollection
extends PointCollectionImpl {
    private final FeatureDatasetPoint fdPoint;

    public FlattenedDatasetPointCollection(FeatureDatasetPoint fdPoint) throws IllegalArgumentException {
        super(fdPoint.getLocation(), CalendarDateUnit.unixDateUnit, null);
        this.fdPoint = fdPoint;
        List<DsgFeatureCollection> featCols = fdPoint.getPointFeatureCollectionList();
        if (!featCols.isEmpty()) {
            DsgFeatureCollection firstFeatCol = featCols.get(0);
            this.copyFieldsFrom(firstFeatCol);
        }
    }

    private void copyFieldsFrom(DsgFeatureCollection featCol) {
        this.timeUnit = featCol.getTimeUnit();
        this.altUnits = featCol.getAltUnits();
    }

    @Override
    public PointFeatureIterator getPointFeatureIterator() {
        return new FlattenedDatasetPointIterator(this.fdPoint);
    }

    protected class FlattenedDatasetPointIterator
    extends PointIteratorAbstract {
        private final Iterator<DsgFeatureCollection> dsgFeatColIter;
        private PointFeatureIterator pfIter;
        private IOIterator<PointFeatureCollection> pfcIter;
        private IOIterator<PointFeatureCC> pfccIter;
        private boolean finished;

        public FlattenedDatasetPointIterator(FeatureDatasetPoint fdPoint) {
            this.dsgFeatColIter = fdPoint.getPointFeatureCollectionList().iterator();
            this.setCalculateBounds(FlattenedDatasetPointCollection.this.getInfo());
        }

        @Override
        public boolean hasNext() {
            try {
                while (!this.pfIterHasNext()) {
                    if (this.loadNextDsgFeatureCollection()) continue;
                    this.close();
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean pfIterHasNext() throws IOException {
            if (this.pfIter != null) {
                if (this.pfIter.hasNext()) {
                    return true;
                }
                this.pfIter.close();
            }
            while (this.pfcIterHasNext()) {
                this.pfIter = this.pfcIter.next().getPointFeatureIterator();
                if (!this.pfIter.hasNext()) continue;
                return true;
            }
            return false;
        }

        private boolean pfcIterHasNext() throws IOException {
            if (this.pfcIter != null && this.pfcIter.hasNext()) {
                return true;
            }
            while (this.pfccIter != null && this.pfccIter.hasNext()) {
                this.pfcIter = this.pfccIter.next().getCollectionIterator();
                if (!this.pfcIter.hasNext()) continue;
                return true;
            }
            return false;
        }

        private boolean loadNextDsgFeatureCollection() throws IOException {
            if (!this.dsgFeatColIter.hasNext()) {
                return false;
            }
            this.pfIter = null;
            this.pfcIter = null;
            this.pfccIter = null;
            DsgFeatureCollection dsgFeatCol = this.dsgFeatColIter.next();
            if (dsgFeatCol instanceof PointFeatureCollection) {
                this.pfIter = ((PointFeatureCollection)dsgFeatCol).getPointFeatureIterator();
            } else if (dsgFeatCol instanceof PointFeatureCC) {
                this.pfcIter = ((PointFeatureCC)dsgFeatCol).getCollectionIterator();
            } else if (dsgFeatCol instanceof PointFeatureCCC) {
                this.pfccIter = ((PointFeatureCCC)dsgFeatCol).getCollectionIterator();
            } else {
                throw new AssertionError((Object)"CAN'T HAPPEN: FeatureDatasetPoint.getPointFeatureCollectionList() only contains PointFeatureCollection, PointFeatureCC, or PointFeatureCCC.");
            }
            return true;
        }

        @Override
        public PointFeature next() {
            if (this.pfIter == null) {
                return null;
            }
            PointFeature pointFeat = this.pfIter.next();
            this.calcBounds(pointFeat);
            return pointFeat;
        }

        @Override
        public void close() {
            if (this.finished) {
                return;
            }
            if (this.pfIter != null) {
                this.pfIter.close();
            }
            this.finishCalcBounds();
            this.finished = true;
        }
    }
}

