/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public final class ItemChecker
extends UnaryExpression {
    private ItemType requiredItemType;
    private RoleDiagnostic role;

    public ItemChecker(Expression sequence, ItemType itemType, RoleDiagnostic role) {
        super(sequence);
        this.requiredItemType = itemType;
        this.role = role;
    }

    public ItemType getRequiredType() {
        return this.requiredItemType;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public RoleDiagnostic getRoleLocator() {
        return this.role;
    }

    public Expression simplify() throws XPathException {
        Expression operand = this.getBaseExpression().simplify();
        if (this.requiredItemType instanceof AnyItemType) {
            return operand;
        }
        this.setBaseExpression(operand);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression operand = this.getBaseExpression();
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        int card = operand.getCardinality();
        if (card == 8192) {
            return operand;
        }
        ItemType supplied = operand.getItemType();
        int relation = th.relationship(this.requiredItemType, supplied);
        if (relation == 0 || relation == 1) {
            return operand;
        }
        if (relation == 4) {
            if (Cardinality.allowsZero(card)) {
                if (!(operand instanceof Literal)) {
                    String message = this.role.composeErrorMessage(this.requiredItemType, operand.getItemType());
                    visitor.getStaticContext().issueWarning("The only value that can pass type-checking is an empty sequence. " + message, this.getLocation());
                }
            } else {
                if (this.requiredItemType.equals(BuiltInAtomicType.STRING) && th.isSubType(supplied, BuiltInAtomicType.ANY_URI)) {
                    return operand;
                }
                String message = this.role.composeErrorMessage(this.requiredItemType, operand.getItemType());
                XPathException err = new XPathException(message);
                err.setErrorCode(this.role.getErrorCode());
                err.setLocation(this.getLocation());
                err.setIsTypeError(this.role.isTypeError());
                throw err;
            }
        }
        return this;
    }

    public int getImplementationMethod() {
        int m4 = 22;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m4 |= 1;
        }
        return m4;
    }

    public IntegerValue[] getIntegerBounds() {
        return this.getBaseExpression().getIntegerBounds();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.getBaseExpression().iterate(context);
        return new ItemMappingIterator(base, this.getMappingFunction(context), true);
    }

    public ItemMappingFunction getMappingFunction(XPathContext context) {
        return new ItemTypeCheckingFunction(this.requiredItemType, this.role, this.getLocation(), context.getConfiguration());
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        Item item = this.getBaseExpression().evaluateItem(context);
        if (item == null) {
            return null;
        }
        if (this.requiredItemType.matches(item, th)) {
            return item;
        }
        if (this.requiredItemType.getUType().subsumes(UType.STRING) && BuiltInAtomicType.ANY_URI.matches(item, th)) {
            return item;
        }
        String message = this.role.composeErrorMessage(this.requiredItemType, Type.getItemType(item, th));
        String errorCode = this.role.getErrorCode();
        if ("XPDY0050".equals(errorCode)) {
            this.dynamicError(message, errorCode, context);
        } else {
            this.typeError(message, errorCode, context);
        }
        return null;
    }

    public void process(XPathContext context) throws XPathException {
        Expression next = this.getBaseExpression();
        int card = 57344;
        if (next instanceof CardinalityChecker) {
            card = ((CardinalityChecker)next).getRequiredCardinality();
            next = ((CardinalityChecker)next).getBaseExpression();
        }
        if ((next.getImplementationMethod() & 4) != 0 && !(this.requiredItemType instanceof DocumentNodeTest)) {
            SequenceReceiver out = context.getReceiver();
            TypeCheckingFilter filter = new TypeCheckingFilter(out);
            filter.setRequiredType(this.requiredItemType, card, this.role, this.getLocation());
            context.setReceiver(filter);
            next.process(context);
            filter.close();
            context.setReceiver(out);
        } else {
            super.process(context);
        }
    }

    public Expression copy(RebindingMap rebindings) {
        ItemChecker exp = new ItemChecker(this.getBaseExpression().copy(rebindings), this.requiredItemType, this.role);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    public ItemType getItemType() {
        ItemType operandType = this.getBaseExpression().getItemType();
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        int relationship = th.relationship(this.requiredItemType, operandType);
        switch (relationship) {
            case 3: {
                if (this.requiredItemType instanceof NodeTest && operandType instanceof NodeTest) {
                    return new CombinedNodeTest((NodeTest)this.requiredItemType, 23, (NodeTest)operandType);
                }
                return this.requiredItemType;
            }
            case 0: 
            case 1: {
                return operandType;
            }
        }
        return this.requiredItemType;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType == ((ItemChecker)other).requiredItemType;
    }

    public int hashCode() {
        return super.hashCode() ^ this.requiredItemType.hashCode();
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("treat", this);
        out.emitAttribute("as", this.requiredItemType.toString());
        if ("JS".equals(out.getOption("target"))) {
            out.emitAttribute("jsTest", this.requiredItemType.generateJavaScriptItemTypeTest(this.getBaseExpression().getItemType()));
        }
        out.emitAttribute("diag", this.role.save());
        this.getBaseExpression().export(out);
        out.endElement();
    }

    public String getExpressionName() {
        return "TreatAs";
    }

    public String toString() {
        String typeDesc = this.requiredItemType.toString();
        return "(" + this.getBaseExpression().toString() + ") treat as " + typeDesc;
    }

    public String toShortString() {
        return this.getBaseExpression().toShortString();
    }

    public Expression optimizeForType(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression base = this.getBaseExpression();
        if (base instanceof ContextItemExpression && this.requiredItemType.equals(contextItemType.getItemType())) {
            return base;
        }
        return this;
    }
}

