/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.eds.threddsutilities.bean;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;

public class MetadataContainer {
    private Map<String, String> _map = new HashMap<String, String>();
    private Dataset _dataset;
    private static Vector<ServiceType> additionalServiceTypes = new Vector(0);

    public MetadataContainer(Dataset threddsDataset) {
        this._dataset = threddsDataset;
        this.processMetadata();
    }

    public String getOpenDapUrl() {
        return this._map.get("opendap");
    }

    public Map<String, String> getMetadataMap() {
        return this._map;
    }

    public void processMetadata() {
        for (Access access : this._dataset.getAccess()) {
            if (!additionalServiceTypes.contains(access.getService().getType())) continue;
            int pos = access.getStandardUrlName().indexOf("/", 7);
            String serviceBaseUrl = access.getStandardUrlName().substring(0, pos) + access.getService().getBase() + access.getUrlPath();
            if (access.getService().getType().equals((Object)ServiceType.OPENDAP)) {
                this._map.put(access.getService().getType().toString().toLowerCase(), access.getStandardUrlName());
            }
            if (access.getService().getType().equals((Object)ServiceType.WMS)) {
                this._map.put(access.getService().getType().toString().toLowerCase(), serviceBaseUrl + "?service=WMS&version=1.3.0&request=GetCapabilities");
            }
            if (access.getService().getType().equals((Object)ServiceType.WCS)) {
                this._map.put(access.getService().getType().toString().toLowerCase(), serviceBaseUrl + "?service=WCS&version=1.0.0&request=GetCapabilities");
            }
            if (!access.getService().getType().equals((Object)ServiceType.NetcdfSubset)) continue;
            this._map.put(access.getService().getType().toString().toLowerCase(), serviceBaseUrl);
        }
    }

    public Dataset getDataset() {
        return this._dataset;
    }

    static {
        additionalServiceTypes.add(ServiceType.OPENDAP);
        additionalServiceTypes.add(ServiceType.WMS);
        additionalServiceTypes.add(ServiceType.WCS);
        additionalServiceTypes.add(ServiceType.WFS);
        additionalServiceTypes.add(ServiceType.NetcdfSubset);
    }
}

