/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLToJsonTransform
extends SystemFunction {
    public static final String STYLESHEET_BASIC_URI = "xml-to-json.xsl";
    public static final String STYLESHEET_INDENT_URI = "xml-to-json-indent.xsl";
    public static final String JSON_NS = "http://www.w3.org/2005/xpath-functions/json";
    public static final String XML_TO_JSON = "xml-to-json";
    public static String[] paramNames = new String[]{"key-delimiter", "string-delimiter", "start-array", "end-array", "start-map", "end-map", "key-value-separator", "array-separator", "map-separator"};
    private static final String ERR_OPTIONS = "XTDE3260";
    public XsltTransformer transform_basic = null;
    public XsltTransformer transform_indent = null;

    private void error(String message, String code) throws XPathException {
        throw new XPathException(message, code);
    }

    private XsltTransformer makeTransform(XsltCompiler xslt, String uri) throws XPathException {
        try {
            EntityURIResolver res = new EntityURIResolver();
            xslt.setURIResolver(res);
            XsltTransformer t2 = xslt.compile(res.resolve(uri, null)).load();
            t2.setInitialTemplate(new QName(JSON_NS, XML_TO_JSON));
            return t2;
        }
        catch (SaxonApiException e) {
            this.error("cannot compile/load " + uri + ":" + e.getMessage(), "Error1234");
        }
        catch (TransformerException e) {
            this.error("cannot find/transform " + uri + ":" + e.getMessage(), "Error1234");
            e.printStackTrace();
        }
        return null;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return new StringValue("a string");
    }

    private String getOption(MapItem options, String option, XPathContext context, String defaultValue) throws XPathException {
        StringValue ov = new StringValue(option);
        Sequence val = options.get(ov);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof AtomicValue) {
            return ((AtomicValue)val).getStringValue();
        }
        this.error("Value of option '" + option + "' is not xs:string", ERR_OPTIONS);
        return defaultValue;
    }

    private boolean getOption(MapItem options, String option, XPathContext context, boolean defaultValue) throws XPathException {
        StringValue ov = new StringValue(option);
        Sequence val = options.get(ov);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof BooleanValue) {
            return ((BooleanValue)val).getBooleanValue();
        }
        this.error("Value of option '" + option + "' is not xs:boolean", ERR_OPTIONS);
        return defaultValue;
    }

    class EntityURIResolver
    implements URIResolver {
        EntityURIResolver() {
        }

        public Source resolve(String href, String base) throws TransformerException {
            InputSource is = null;
            try {
                is = StandardEntityResolver.getInstance().resolveEntity(null, href);
                is.setSystemId(href);
            }
            catch (SAXException e) {
                throw new TransformerException(e);
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
            return new SAXSource(is);
        }
    }
}

