/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCatalog {
    List<Source> packages = new ArrayList<Source>();
    Processor processor;

    public PackageCatalog(Processor processor) {
        this.processor = processor;
    }

    public PackageCatalog(Processor processor, Source s2) throws SaxonApiException {
        this(processor);
        this.addCatalog(s2);
    }

    public void addCatalog(Source s2) throws SaxonApiException {
        DocumentBuilder catbuilder = this.processor.newDocumentBuilder();
        catbuilder.setTreeModel(TreeModel.TINY_TREE);
        XdmNode catalog = catbuilder.build(s2);
        XPathCompiler xpc = this.processor.newXPathCompiler();
        for (XdmItem href : xpc.evaluate("//package/@href", catalog)) {
            this.packages.add(new StreamSource(catalog.getBaseURI().resolve(href.getStringValue()).toString()));
        }
    }

    public List<Source> getSources() {
        return this.packages;
    }
}

