/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Whitespace;

public final class DecimalValue
extends NumericValue {
    public static final int DIVIDE_PRECISION = 18;
    private BigDecimal value;
    private Double doubleValue;
    public static final BigDecimal BIG_DECIMAL_ONE_MILLION = BigDecimal.valueOf(1000000L);
    public static final DecimalValue ZERO = new DecimalValue(BigDecimal.valueOf(0L));
    public static final DecimalValue ONE = new DecimalValue(BigDecimal.valueOf(1L));
    public static final DecimalValue TWO = new DecimalValue(BigDecimal.valueOf(2L));
    public static final DecimalValue THREE = new DecimalValue(BigDecimal.valueOf(3L));
    private static final Pattern decimalPattern = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");

    public DecimalValue(BigDecimal value) {
        this.value = value.stripTrailingZeros();
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public static ConversionResult makeDecimalValue(CharSequence in, boolean validate) {
        try {
            FastStringBuffer digits = new FastStringBuffer(in.length());
            int scale = 0;
            int state = 0;
            boolean foundDigit = false;
            int len = in.length();
            block9: for (int i = 0; i < len; ++i) {
                char c = in.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (state == 0) continue block9;
                        state = 5;
                        continue block9;
                    }
                    case '+': {
                        if (state != 0) {
                            throw new NumberFormatException("unexpected sign");
                        }
                        state = 1;
                        continue block9;
                    }
                    case '-': {
                        if (state != 0) {
                            throw new NumberFormatException("unexpected sign");
                        }
                        state = 1;
                        digits.append(c);
                        continue block9;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (state == 0) {
                            state = 1;
                        } else if (state >= 3) {
                            ++scale;
                        }
                        if (state == 5) {
                            throw new NumberFormatException("contains embedded whitespace");
                        }
                        digits.append(c);
                        foundDigit = true;
                        continue block9;
                    }
                    case '.': {
                        if (state == 5) {
                            throw new NumberFormatException("contains embedded whitespace");
                        }
                        if (state >= 3) {
                            throw new NumberFormatException("more than one decimal point");
                        }
                        state = 3;
                        continue block9;
                    }
                    default: {
                        throw new NumberFormatException("invalid character '" + c + "'");
                    }
                }
            }
            if (!foundDigit) {
                throw new NumberFormatException("no digits in value");
            }
            while (scale > 0 && digits.charAt(digits.length() - 1) == '0') {
                digits.setLength(digits.length() - 1);
                --scale;
            }
            if (digits.length() == 0 || digits.length() == 1 && digits.charAt(0) == '-') {
                return ZERO;
            }
            BigInteger bigInt = new BigInteger(digits.toString());
            BigDecimal bigDec = new BigDecimal(bigInt, scale);
            return new DecimalValue(bigDec);
        }
        catch (NumberFormatException err) {
            ValidationFailure e = new ValidationFailure("Cannot convert string " + Err.wrap(Whitespace.trim(in), 4) + " to xs:decimal: " + err.getMessage());
            e.setErrorCode("FORG0001");
            return e;
        }
    }

    public static boolean castableAsDecimal(CharSequence in) {
        CharSequence trimmed = Whitespace.trimWhitespace(in);
        return decimalPattern.matcher(trimmed).matches();
    }

    public DecimalValue(double in) throws ValidationException {
        try {
            BigDecimal d = new BigDecimal(in);
            this.value = d.stripTrailingZeros();
        }
        catch (NumberFormatException err) {
            ValidationException e = new ValidationException("Cannot convert double " + Err.wrap(in + "", 4) + " to decimal");
            e.setErrorCode("FOCA0002");
            throw e;
        }
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public DecimalValue(long in) {
        this.value = BigDecimal.valueOf(in);
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DecimalValue v = new DecimalValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DECIMAL;
    }

    public double getDoubleValue() {
        if (this.doubleValue == null) {
            double d = this.value.doubleValue();
            this.doubleValue = d;
            return d;
        }
        return this.doubleValue;
    }

    public float getFloatValue() {
        return (float)this.value.doubleValue();
    }

    public long longValue() throws XPathException {
        return (long)this.value.doubleValue();
    }

    public BigDecimal getDecimalValue() {
        return this.value;
    }

    public int hashCode() {
        BigDecimal round = this.value.setScale(0, 1);
        long value = round.longValue();
        if (value > Integer.MIN_VALUE && value < Integer.MAX_VALUE) {
            return (int)value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean effectiveBooleanValue() {
        return this.value.signum() != 0;
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        String s2 = this.getStringValue();
        if (s2.indexOf(46) < 0) {
            s2 = s2 + ".0";
        }
        return s2;
    }

    public CharSequence getPrimitiveStringValue() {
        return DecimalValue.decimalToString(this.value, new FastStringBuffer(16));
    }

    public static FastStringBuffer decimalToString(BigDecimal value, FastStringBuffer fsb) {
        int scale = value.scale();
        if (scale == 0) {
            fsb.append(value.toString());
            return fsb;
        }
        if (scale < 0) {
            String s2 = value.abs().unscaledValue().toString();
            if (s2.equals("0")) {
                fsb.append('0');
                return fsb;
            }
            if (value.signum() < 0) {
                fsb.append('-');
            }
            fsb.append(s2);
            for (int i = 0; i < -scale; ++i) {
                fsb.append('0');
            }
            return fsb;
        }
        String s3 = value.abs().unscaledValue().toString();
        if (s3.equals("0")) {
            fsb.append('0');
            return fsb;
        }
        int len = s3.length();
        if (value.signum() < 0) {
            fsb.append('-');
        }
        if (scale >= len) {
            fsb.append("0.");
            for (int i = len; i < scale; ++i) {
                fsb.append('0');
            }
            fsb.append(s3);
        } else {
            fsb.append(s3.substring(0, len - scale));
            fsb.append('.');
            fsb.append(s3.substring(len - scale));
        }
        return fsb;
    }

    public NumericValue negate() {
        return new DecimalValue(this.value.negate());
    }

    public NumericValue floor() {
        return new DecimalValue(this.value.setScale(0, 3));
    }

    public NumericValue ceiling() {
        return new DecimalValue(this.value.setScale(0, 2));
    }

    public NumericValue round(int scale) {
        switch (this.value.signum()) {
            case -1: {
                return new DecimalValue(this.value.setScale(scale, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new DecimalValue(this.value.setScale(scale, 4));
            }
        }
        return this;
    }

    public NumericValue roundHalfToEven(int scale) {
        BigDecimal scaledValue = this.value.setScale(scale, 6);
        return new DecimalValue(scaledValue.stripTrailingZeros());
    }

    public int signum() {
        return this.value.signum();
    }

    public boolean isWholeNumber() {
        return this.value.scale() == 0 || this.value.compareTo(this.value.setScale(0, 1)) == 0;
    }

    public NumericValue abs() {
        if (this.value.signum() > 0) {
            return this;
        }
        return new DecimalValue(this.value.negate());
    }

    public int compareTo(Object other) {
        if (NumericValue.isInteger((NumericValue)other)) {
            try {
                return this.value.compareTo(((NumericValue)other).getDecimalValue());
            }
            catch (XPathException err) {
                throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
            }
        }
        if (other instanceof DecimalValue) {
            return this.value.compareTo(((DecimalValue)other).value);
        }
        if (other instanceof FloatValue) {
            return 0 - ((FloatValue)other).compareTo(this);
        }
        return super.compareTo(other);
    }

    public int compareTo(long other) {
        if (other == 0L) {
            return this.value.signum();
        }
        return this.value.compareTo(BigDecimal.valueOf(other));
    }

    public Comparable getSchemaComparable() {
        return new DecimalComparable(this);
    }

    public boolean isIdentical(AtomicValue v) {
        return v instanceof DecimalValue && this.equals(v);
    }

    protected static class DecimalComparable
    implements Comparable {
        protected DecimalValue value;

        public DecimalComparable(DecimalValue value) {
            this.value = value;
        }

        public BigDecimal asBigDecimal() {
            return this.value.getDecimalValue();
        }

        public int compareTo(Object o) {
            if (o instanceof DecimalComparable) {
                return this.asBigDecimal().compareTo(((DecimalComparable)o).asBigDecimal());
            }
            if (o instanceof Int64Value.Int64Comparable) {
                return this.asBigDecimal().compareTo(BigDecimal.valueOf(((Int64Value.Int64Comparable)o).asLong()));
            }
            if (o instanceof BigIntegerValue.BigIntegerComparable) {
                return this.value.compareTo(new BigDecimal(((BigIntegerValue.BigIntegerComparable)o).asBigInteger()));
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            if (this.value.isWholeNumber()) {
                try {
                    IntegerValue iv = (IntegerValue)Converter.DECIMAL_TO_INTEGER.convert(this.value).asAtomic();
                    return iv.getSchemaComparable().hashCode();
                }
                catch (ValidationException e) {
                    return 12345678;
                }
            }
            return this.value.hashCode();
        }
    }
}

