/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.RangeComposite;
import ucar.ma2.RangeIterator;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoordAxisHelper;
import ucar.nc2.ft2.coverage.CoordInterval;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.Indent;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;
import ucar.nc2.util.Optional;
import ucar.unidata.util.Format;

@Immutable
public class CoverageCoordAxis1D
extends CoverageCoordAxis {
    protected final Range range;
    protected final RangeComposite crange;

    public CoverageCoordAxis1D(CoverageCoordAxisBuilder builder) {
        super(builder);
        String rangeName;
        if (this.axisType == null && builder.dependenceType == CoverageCoordAxis.DependenceType.independent) {
            throw new IllegalArgumentException("independent axis must have type");
        }
        String string = rangeName = this.axisType != null ? this.axisType.toString() : null;
        this.range = builder.range != null ? (rangeName != null ? builder.range.copyWithName(rangeName) : builder.range) : Range.make(rangeName, this.getNcoords());
        this.crange = builder.crange;
    }

    @Override
    public RangeIterator getRangeIterator() {
        return this.crange != null ? this.crange : this.range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void toString(Formatter f, Indent indent) {
        super.toString(f, indent);
        f.format("%s range=%s isSubset=%s", indent, this.range, this.isSubset());
        f.format("%n", new Object[0]);
    }

    @Override
    public String getSummary() {
        if (this.axisType != AxisType.RunTime) {
            return super.getSummary();
        }
        if (this.ncoords < 7) {
            Formatter f = new Formatter();
            for (int i = 0; i < this.ncoords; ++i) {
                CalendarDate cd2 = this.makeDate(this.getCoordMidpoint(i));
                if (i > 0) {
                    f.format(", ", new Object[0]);
                }
                f.format("%s", cd2);
            }
            return f.toString();
        }
        Formatter f = new Formatter();
        CalendarDate start = this.makeDate(this.getStartValue());
        f.format("start=%s", start);
        CalendarDate end = this.makeDate(this.getEndValue());
        f.format(", end=%s", end);
        f.format(" (npts=%d spacing=%s)", new Object[]{this.getNcoords(), this.getSpacing()});
        return f.toString();
    }

    public boolean isAscending() {
        this.loadValuesIfNeeded();
        switch (this.spacing) {
            case regularInterval: 
            case regularPoint: {
                return this.getResolution() >= 0.0;
            }
            case irregularPoint: {
                return this.values[0] <= this.values[this.ncoords - 1];
            }
            case contiguousInterval: {
                return this.values[0] <= this.values[this.ncoords];
            }
            case discontiguousInterval: {
                return this.values[0] <= this.values[2 * this.ncoords - 1];
            }
        }
        throw new IllegalStateException("unknown spacing" + (Object)((Object)this.spacing));
    }

    public double getCoord(int index) {
        if (index < 0 || index >= this.getNcoords()) {
            throw new IllegalArgumentException("Index out of range=" + index);
        }
        this.loadValuesIfNeeded();
        switch (this.spacing) {
            case regularInterval: 
            case regularPoint: {
                return this.startValue + (double)index * this.getResolution();
            }
            case irregularPoint: 
            case contiguousInterval: 
            case discontiguousInterval: {
                return this.values[index];
            }
        }
        throw new IllegalStateException("Unknown spacing=" + (Object)((Object)this.spacing));
    }

    public double getCoordMidpoint(int index) {
        if (index < 0 || index >= this.getNcoords()) {
            throw new IllegalArgumentException("Index out of range=" + index);
        }
        this.loadValuesIfNeeded();
        switch (this.spacing) {
            case regularPoint: {
                return this.startValue + (double)index * this.getResolution();
            }
            case irregularPoint: {
                return this.values[index];
            }
            case regularInterval: {
                return this.startValue + ((double)index + 0.5) * this.getResolution();
            }
            case contiguousInterval: 
            case discontiguousInterval: {
                return (this.getCoordEdge1(index) + this.getCoordEdge2(index)) / 2.0;
            }
        }
        throw new IllegalStateException("Unknown spacing=" + (Object)((Object)this.spacing));
    }

    public double getCoordEdge1(int index) {
        if (index < 0 || index >= this.getNcoords()) {
            throw new IllegalArgumentException("Index out of range=" + index);
        }
        this.loadValuesIfNeeded();
        switch (this.spacing) {
            case regularPoint: {
                return this.startValue + ((double)index - 0.5) * this.getResolution();
            }
            case regularInterval: {
                return this.startValue + (double)index * this.getResolution();
            }
            case irregularPoint: {
                if (index > 0) {
                    return (this.values[index - 1] + this.values[index]) / 2.0;
                }
                return this.values[0] - (this.values[1] - this.values[0]) / 2.0;
            }
            case contiguousInterval: {
                return this.values[index];
            }
            case discontiguousInterval: {
                return this.values[2 * index];
            }
        }
        throw new IllegalStateException("Unknown spacing=" + (Object)((Object)this.spacing));
    }

    public double getCoordEdge2(int index) {
        if (index < 0 || index >= this.getNcoords()) {
            throw new IllegalArgumentException("Index out of range=" + index);
        }
        this.loadValuesIfNeeded();
        switch (this.spacing) {
            case regularPoint: {
                if (index < 0 || index >= this.ncoords) {
                    throw new IllegalArgumentException("Index out of range " + index);
                }
                return this.startValue + ((double)index + 0.5) * this.getResolution();
            }
            case regularInterval: {
                return this.startValue + (double)(index + 1) * this.getResolution();
            }
            case irregularPoint: {
                if (index < this.ncoords - 1) {
                    return (this.values[index] + this.values[index + 1]) / 2.0;
                }
                return this.values[index] + (this.values[index] - this.values[index - 1]) / 2.0;
            }
            case contiguousInterval: {
                return this.values[index + 1];
            }
            case discontiguousInterval: {
                return this.values[2 * index + 1];
            }
        }
        throw new IllegalStateException("Unknown spacing=" + (Object)((Object)this.spacing));
    }

    public double getCoordEdgeFirst() {
        return this.getCoordEdge1(0);
    }

    public double getCoordEdgeLast() {
        return this.getCoordEdge2(this.ncoords - 1);
    }

    @Override
    public Array getCoordsAsArray() {
        Array result = this.dependenceType == CoverageCoordAxis.DependenceType.scalar ? Array.factory(this.getDataType(), new int[0]) : Array.factory(this.getDataType(), new int[]{this.ncoords});
        for (int i = 0; i < this.ncoords; ++i) {
            result.setDouble(i, this.getCoordMidpoint(i));
        }
        return result;
    }

    @Override
    public Array getCoordBoundsAsArray() {
        Array result = Array.factory(this.getDataType(), new int[]{this.ncoords, 2});
        int count = 0;
        for (int i = 0; i < this.ncoords; ++i) {
            result.setDouble(count++, this.getCoordEdge1(i));
            result.setDouble(count++, this.getCoordEdge2(i));
        }
        return result;
    }

    @Override
    public Optional<CoverageCoordAxis> subset(double minValue, double maxValue, int stride) {
        CoordAxisHelper helper = new CoordAxisHelper(this);
        Optional<CoverageCoordAxisBuilder> buildero = helper.subset(minValue, maxValue, stride);
        return !buildero.isPresent() ? Optional.empty(buildero.getErrorMessage()) : Optional.of(new CoverageCoordAxis1D(buildero.get()));
    }

    public Object getCoordObject(int index) {
        if (this.axisType == AxisType.RunTime) {
            return this.makeDate(this.getCoordMidpoint(index));
        }
        if (this.isInterval()) {
            return new double[]{this.getCoordEdge1(index), this.getCoordEdge2(index)};
        }
        return this.getCoordMidpoint(index);
    }

    @Deprecated
    public List<NamedObject> getCoordValueNames() {
        this.loadValuesIfNeeded();
        if (this.timeHelper != null) {
            return this.timeHelper.getCoordValueNames(this);
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (int i = 0; i < this.ncoords; ++i) {
            Object value = null;
            switch (this.spacing) {
                case regularPoint: 
                case irregularPoint: {
                    value = Format.d(this.getCoordMidpoint(i), 3);
                    break;
                }
                case regularInterval: 
                case contiguousInterval: 
                case discontiguousInterval: {
                    value = new CoordInterval(this.getCoordEdge1(i), this.getCoordEdge2(i), 3);
                }
            }
            result.add(new NamedAnything(value, value + " " + this.getUnits()));
        }
        return result;
    }

    @Override
    public CoverageCoordAxis copy() {
        return new CoverageCoordAxis1D(new CoverageCoordAxisBuilder(this));
    }

    @Override
    public Optional<CoverageCoordAxis> subset(SubsetParams params) {
        Optional<CoverageCoordAxisBuilder> buildero = this.subsetBuilder(params);
        return !buildero.isPresent() ? Optional.empty(buildero.getErrorMessage()) : Optional.of(new CoverageCoordAxis1D(buildero.get()));
    }

    public Optional<CoverageCoordAxis> subsetByIntervals(List<MAMath.MinMax> lonIntvs, int stride) {
        if (this.axisType != AxisType.Lon) {
            return Optional.empty("subsetByIntervals only for longitude");
        }
        if (!this.isRegular()) {
            return Optional.empty("subsetByIntervals only for regular longitude");
        }
        double subsetResolution = stride > 1 ? (double)stride * this.resolution : this.resolution;
        CoordAxisHelper helper = new CoordAxisHelper(this);
        double start = Double.NaN;
        boolean first = true;
        ArrayList<RangeIterator> ranges = new ArrayList<RangeIterator>();
        for (MAMath.MinMax lonIntv : lonIntvs) {
            if (first) {
                start = lonIntv.min;
            }
            first = false;
            Optional<RangeIterator> opt = helper.makeRange(lonIntv.min, lonIntv.max, stride);
            if (!opt.isPresent()) {
                return Optional.empty(opt.getErrorMessage());
            }
            ranges.add(opt.get());
        }
        RangeComposite compositeRange = new RangeComposite(AxisType.Lon.toString(), ranges);
        int npts = compositeRange.length();
        double end = start + (double)npts * subsetResolution;
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this);
        builder.subset(npts, start, end, subsetResolution, null);
        builder.setRange(null);
        builder.setCompositeRange(compositeRange);
        return Optional.of(new CoverageCoordAxis1D(builder));
    }

    public Optional<CoverageCoordAxis> subsetByIndex(Range range) {
        try {
            CoordAxisHelper helper = new CoordAxisHelper(this);
            CoverageCoordAxisBuilder builder = helper.subsetByIndex(range);
            return Optional.of(new CoverageCoordAxis1D(builder));
        }
        catch (InvalidRangeException e) {
            return Optional.empty(e.getMessage());
        }
    }

    protected Optional<CoverageCoordAxisBuilder> subsetBuilder(SubsetParams params) {
        if (params == null) {
            return Optional.of(new CoverageCoordAxisBuilder(this));
        }
        CoordAxisHelper helper = new CoordAxisHelper(this);
        switch (this.getAxisType()) {
            case GeoZ: 
            case Pressure: 
            case Height: {
                Double dval = params.getVertCoord();
                if (dval != null) {
                    return Optional.of(helper.subsetClosest(dval));
                }
                double[] intv = params.getVertCoordIntv();
                if (intv != null) {
                    return Optional.of(helper.subsetClosest((intv[0] + intv[1]) / 2.0));
                }
                double[] vertRange = params.getVertRange();
                if (vertRange == null) break;
                return helper.subset(vertRange[0], vertRange[1], 1);
            }
            case Ensemble: {
                Double eval = params.getDouble("ensCoord");
                if (eval == null) break;
                return Optional.of(helper.subsetClosest(eval));
            }
            case GeoX: 
            case GeoY: 
            case Lat: 
            case Lon: {
                throw new IllegalArgumentException();
            }
            case Time: {
                CalendarDateRange dateRange;
                if (params.isTrue("timePresent")) {
                    return Optional.of(helper.subsetClosest(CalendarDate.present()));
                }
                CalendarDate date = (CalendarDate)params.get("time");
                if (date != null) {
                    return Optional.of(helper.subsetClosest(date));
                }
                Integer stride = (Integer)params.get("timeStride");
                if (stride == null || stride < 0) {
                    stride = 1;
                }
                if ((dateRange = (CalendarDateRange)params.get("timeRange")) != null) {
                    return helper.subset(dateRange, stride);
                }
                Double timeOffset = params.getTimeOffset();
                CalendarDate runtime = params.getRunTime();
                if (timeOffset != null) {
                    if (runtime != null) {
                        date = this.makeDateInTimeUnits(runtime, timeOffset);
                        return Optional.of(helper.subsetClosest(date));
                    }
                    return Optional.of(helper.subsetClosest(timeOffset));
                }
                double[] timeOffsetIntv = params.getTimeOffsetIntv();
                if (timeOffsetIntv != null && runtime != null) {
                    CalendarDate[] dateIntv = new CalendarDate[]{this.makeDateInTimeUnits(runtime, timeOffsetIntv[0]), this.makeDateInTimeUnits(runtime, timeOffsetIntv[1])};
                    return Optional.of(helper.subsetClosest(dateIntv));
                }
                if (stride == 1) break;
                try {
                    return Optional.of(helper.subsetByIndex(this.getRange().copyWithStride(stride)));
                }
                catch (InvalidRangeException e) {
                    return Optional.empty(e.getMessage());
                }
            }
            case RunTime: {
                CalendarDate rundate = (CalendarDate)params.get("runtime");
                if (rundate != null) {
                    return Optional.of(helper.subsetClosest(rundate));
                }
                if (params.isTrue("runtimeAll")) break;
                return Optional.of(helper.subsetLatest());
            }
            case TimeOffset: {
                Double oval = params.getDouble("timeOffset");
                if (oval != null) {
                    return Optional.of(helper.subsetClosest(oval));
                }
                double[] timeOffsetIntv = params.getTimeOffsetIntv();
                if (timeOffsetIntv != null) {
                    return Optional.of(helper.subsetClosest((timeOffsetIntv[0] + timeOffsetIntv[1]) / 2.0));
                }
                if (!params.isTrue("timeOffsetFirst")) break;
                try {
                    return Optional.of(helper.subsetByIndex(new Range(1)));
                }
                catch (InvalidRangeException e) {
                    return Optional.empty(e.getMessage());
                }
            }
        }
        return Optional.of(new CoverageCoordAxisBuilder(this));
    }

    @Override
    public Optional<CoverageCoordAxis> subsetDependent(CoverageCoordAxis1D dependsOn) {
        CoverageCoordAxisBuilder builder;
        try {
            builder = new CoordAxisHelper(this).subsetByIndex(dependsOn.getRange());
        }
        catch (InvalidRangeException e) {
            return Optional.empty(e.getMessage());
        }
        return Optional.of(new CoverageCoordAxis1D(builder));
    }

    public Iterator<Object> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<Object> {
        private int current;
        private int ncoords;

        private MyIterator() {
            this.ncoords = CoverageCoordAxis1D.this.getNcoords();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.ncoords;
        }

        @Override
        public Object next() {
            return CoverageCoordAxis1D.this.getCoordMidpoint(this.current++);
        }
    }
}

