/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.netcdf3;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.netcdf3.N3headerNew;
import ucar.nc2.internal.iosp.netcdf3.N3headerWriter;
import ucar.nc2.internal.iosp.netcdf3.N3iospNew;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.LayoutRegularSegmented;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class N3iospWriter
extends N3iospNew
implements IOServiceProviderWriter {
    private static final byte NC_FILL_BYTE = -127;
    private static final char NC_FILL_CHAR = '\u0000';
    private static final short NC_FILL_SHORT = -32767;
    private static final int NC_FILL_INT = -2147483647;
    private static final float NC_FILL_FLOAT = 9.96921E36f;
    private static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    private boolean fill = true;
    private IOServiceProvider iosp = null;

    public N3iospWriter(IOServiceProvider iosp) {
        this.iosp = iosp;
    }

    @Override
    public void openForWriting(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        File file;
        this.raf = raf;
        this.location = raf != null ? raf.getLocation() : null;
        this.ncfile = ncfile;
        String location = raf.getLocation();
        if (!location.startsWith("http:") && (file = new File(location)).exists()) {
            this.lastModified = file.lastModified();
        }
        raf.order(0);
        this.header = new N3headerWriter(this, raf, ncfile);
        Group.Builder rootGroup = Group.builder().setName("").setNcfile(ncfile);
        this.header.read(raf, rootGroup, null);
        ncfile.setRootGroup(rootGroup.build());
        ncfile.finish();
    }

    @Override
    public void setFill(boolean fill) {
        this.fill = fill;
    }

    @Override
    public void create(String filename, NetcdfFile ncfile, int extra, long preallocateSize, boolean largeFile) throws IOException {
        this.ncfile = ncfile;
        ncfile.finish();
        this.raf = new RandomAccessFile(filename, "rw");
        this.raf.order(0);
        if (preallocateSize > 0L) {
            java.io.RandomAccessFile myRaf = this.raf.getRandomAccessFile();
            myRaf.setLength(preallocateSize);
        }
        N3headerWriter headerw = new N3headerWriter(this, this.raf, ncfile);
        headerw.create(extra, largeFile, null);
        this.header = headerw;
        if (this.fill) {
            this.fillNonRecordVariables();
        }
    }

    @Override
    public boolean rewriteHeader(boolean largeFile) throws IOException {
        return ((N3headerWriter)this.header).rewriteHeader(largeFile, null);
    }

    @Override
    public void writeData(Variable v2, Section section, Array values) throws IOException, InvalidRangeException {
        N3headerNew.Vinfo vinfo = (N3headerNew.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        if (v2.isUnlimited()) {
            Range firstRange = section.getRange(0);
            this.setNumrecs(firstRange.last() + 1);
        }
        if (v2 instanceof Structure) {
            if (!(values instanceof ArrayStructure)) {
                throw new IllegalArgumentException("writeData for Structure: data must be ArrayStructure");
            }
            if (v2.getRank() == 0) {
                throw new IllegalArgumentException("writeData for Structure: must have rank > 0");
            }
            Dimension d = v2.getDimension(0);
            if (!d.isUnlimited()) {
                throw new IllegalArgumentException("writeData for Structure: must have unlimited dimension");
            }
            this.writeRecordData((Structure)v2, section, (ArrayStructure)values);
        } else {
            Layout layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
            this.writeData(values, layout, dataType);
        }
    }

    @Override
    public int appendStructureData(Structure s2, StructureData sdata) throws IOException, InvalidRangeException {
        int recnum = this.header.numrecs;
        this.setNumrecs(recnum + 1);
        this.writeRecordData(s2, recnum, sdata);
        return recnum;
    }

    private void writeRecordData(Structure s2, Section section, ArrayStructure structureArray) throws IOException, InvalidRangeException {
        int countSrcRecnum = 0;
        Range recordRange = section.getRange(0);
        for (int recnum : recordRange) {
            StructureData sdata = structureArray.getStructureData(countSrcRecnum);
            this.writeRecordData(s2, recnum, sdata);
            ++countSrcRecnum;
        }
    }

    private void writeRecordData(Structure s2, int recnum, StructureData sdata) throws IOException, InvalidRangeException {
        StructureMembers members = sdata.getStructureMembers();
        for (Variable vm : s2.getVariables()) {
            StructureMembers.Member m4 = members.findMember(vm.getShortName());
            if (null == m4) continue;
            Array data = sdata.getArray(m4);
            if (data instanceof ArrayObject && vm.getDataType() == DataType.CHAR && vm.getRank() > 0) {
                int strlen = vm.getShape(vm.getRank() - 1);
                data = ArrayChar.makeFromStringArray((ArrayObject)data, strlen);
            }
            N3headerNew.Vinfo vinfo = (N3headerNew.Vinfo)vm.getSPobject();
            long begin = vinfo.begin + (long)recnum * this.header.recsize;
            Section memberSection = vm.getShapeAsSection();
            LayoutRegular layout = new LayoutRegular(begin, vm.getElementSize(), vm.getShape(), memberSection);
            try {
                this.writeData(data, layout, vm.getDataType());
            }
            catch (Exception e) {
                log.error("Error writing member=" + vm.getShortName() + " in struct=" + s2.getFullName(), e);
                throw new IOException(e);
            }
        }
    }

    private void writeData(Array values, Layout index, DataType dataType) throws IOException {
        if (dataType == DataType.BYTE || dataType == DataType.CHAR) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                this.raf.seek(chunk.getSrcPos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.write(ii.getByteNext());
                }
            }
            return;
        }
        if (dataType == DataType.STRING) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                this.raf.seek(chunk.getSrcPos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    String val = (String)ii.getObjectNext();
                    if (val == null) continue;
                    this.raf.write(val.getBytes(StandardCharsets.UTF_8));
                }
            }
            return;
        }
        if (dataType == DataType.SHORT) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                this.raf.seek(chunk.getSrcPos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.writeShort(ii.getShortNext());
                }
            }
            return;
        }
        if (dataType == DataType.INT) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                this.raf.seek(chunk.getSrcPos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.writeInt(ii.getIntNext());
                }
            }
            return;
        }
        if (dataType == DataType.FLOAT) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                this.raf.seek(chunk.getSrcPos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.writeFloat(ii.getFloatNext());
                }
            }
            return;
        }
        if (dataType == DataType.DOUBLE) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                this.raf.seek(chunk.getSrcPos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.writeDouble(ii.getDoubleNext());
                }
            }
            return;
        }
        throw new IllegalStateException("dataType= " + (Object)((Object)dataType));
    }

    private void setNumrecs(int n) throws IOException, InvalidRangeException {
        if (n <= this.header.numrecs) {
            return;
        }
        int startRec = this.header.numrecs;
        ((N3headerWriter)this.header).setNumrecs(n);
        for (Dimension dim : this.ncfile.getRootGroup().getDimensions()) {
            if (!dim.isUnlimited()) continue;
            dim.setLength(n);
        }
        for (Variable v : this.ncfile.getVariables()) {
            if (!v.isUnlimited()) continue;
            v.resetShape();
            v.setCachedData(null, false);
        }
        if (this.fill) {
            this.fillRecordVariables(startRec, n);
        } else {
            this.raf.setMinLength(this.header.calcFileSize());
        }
    }

    @Override
    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        ((N3headerWriter)this.header).updateAttribute(v2, att);
    }

    @Override
    public void flush() throws IOException {
        if (this.raf != null) {
            this.raf.flush();
            ((N3headerWriter)this.header).writeNumrecs();
            this.raf.flush();
        }
    }

    private void fillNonRecordVariables() throws IOException {
        for (Variable v : this.ncfile.getVariables()) {
            if (v.isUnlimited()) continue;
            try {
                this.writeData(v, v.getShapeAsSection(), this.makeConstantArray(v));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
    }

    private void fillRecordVariables(int recStart, int recEnd) throws IOException, InvalidRangeException {
        for (int i = recStart; i < recEnd; ++i) {
            Range r = new Range(i, i);
            for (Variable v : this.ncfile.getVariables()) {
                if (!v.isUnlimited() || v instanceof Structure) continue;
                Section.Builder recordSection = Section.builder().appendRanges(v.getRanges());
                recordSection.setRange(0, r);
                this.writeData(v, recordSection.build(), this.makeConstantArray(v));
            }
        }
    }

    private Array makeConstantArray(Variable v) {
        Class classType = v.getDataType().getPrimitiveClassType();
        Attribute att = v.findAttribute("_FillValue");
        Object[] storage = null;
        if (classType == Double.TYPE) {
            double[] storageP = new double[]{att == null ? (double)9.96921E36f : att.getNumericValue().doubleValue()};
            storage = storageP;
        } else if (classType == Float.TYPE) {
            float[] storageP = new float[]{att == null ? 9.96921E36f : att.getNumericValue().floatValue()};
            storage = storageP;
        } else if (classType == Integer.TYPE) {
            int[] storageP = new int[]{att == null ? -2147483647 : att.getNumericValue().intValue()};
            storage = storageP;
        } else if (classType == Short.TYPE) {
            short[] storageP = new short[]{att == null ? (short)-32767 : (short)att.getNumericValue().shortValue()};
            storage = storageP;
        } else if (classType == Byte.TYPE) {
            byte[] storageP = new byte[]{att == null ? (byte)-127 : (byte)att.getNumericValue().byteValue()};
            storage = storageP;
        } else if (classType == Character.TYPE) {
            char[] storageP = new char[]{att != null && !att.getStringValue().isEmpty() ? att.getStringValue().charAt(0) : (char)'\u0000'};
            storage = storageP;
        }
        return Array.factoryConstant(v.getDataType(), v.getShape(), storage);
    }

    @Override
    public boolean syncExtend() throws IOException {
        boolean result = ((N3headerWriter)this.header).synchNumrecs();
        if (result && log.isDebugEnabled()) {
            log.debug(" N3iosp syncExtend " + this.raf.getLocation() + " numrecs =" + this.header.numrecs);
        }
        return result;
    }
}

