/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.Date;
import java.util.Formatter;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class CalendarDateUnit {
    public static final CalendarDateUnit unixDateUnit = CalendarDateUnit.of(null, CalendarPeriod.Field.Second, CalendarDate.parseISOformat(null, "1970-01-01T00:00:00"));
    private static final String byCalendarString = "calendar ";
    public static final String udunitPatternString = "(\\w*)\\s*since\\s*([\\+\\-?\\d]+)([ t]([\\.\\:?\\d]*)([ \\+\\-]\\S*)?z?)?$";
    private static final Pattern udunitPattern = Pattern.compile("(\\w*)\\s*since\\s*([\\+\\-?\\d]+)([ t]([\\.\\:?\\d]*)([ \\+\\-]\\S*)?z?)?$");
    private final Calendar cal;
    private final CalendarPeriod period;
    private final CalendarPeriod.Field periodField;
    private final CalendarDate baseDate;
    private final boolean isCalendarField;

    public static CalendarDateUnit of(String calendarName, String udunitString) {
        Calendar calt = Calendar.get(calendarName);
        if (calt == null) {
            calt = Calendar.getDefault();
        }
        return new CalendarDateUnit(calt, udunitString);
    }

    public static CalendarDateUnit withCalendar(Calendar calt, String udunitString) {
        if (calt == null) {
            calt = Calendar.getDefault();
        }
        return new CalendarDateUnit(calt, udunitString);
    }

    public static CalendarDateUnit of(Calendar calt, CalendarPeriod.Field periodField, CalendarDate baseDate) {
        if (calt == null) {
            calt = Calendar.getDefault();
        }
        return new CalendarDateUnit(calt, periodField, baseDate);
    }

    private CalendarDateUnit(Calendar calt, String dateUnitString) {
        Matcher m;
        dateUnitString = dateUnitString.trim();
        dateUnitString = dateUnitString.replaceAll("\\s+", " ");
        dateUnitString = dateUnitString.toLowerCase();
        this.isCalendarField = dateUnitString.startsWith(byCalendarString);
        if (this.isCalendarField) {
            dateUnitString = dateUnitString.substring(byCalendarString.length()).trim();
        }
        if (!(m = udunitPattern.matcher(dateUnitString)).matches()) {
            throw new IllegalArgumentException(dateUnitString + " does not match " + udunitPatternString);
        }
        String unitString = m.group(1);
        this.period = CalendarPeriod.of(unitString);
        this.periodField = CalendarPeriod.fromUnitString(unitString);
        int pos = dateUnitString.indexOf("since");
        String iso = dateUnitString.substring(pos + 5);
        this.baseDate = CalendarDateFormatter.isoStringToCalendarDate(calt, iso);
        this.cal = calt = this.baseDate.getCalendar();
    }

    private CalendarDateUnit(Calendar calt, CalendarPeriod.Field periodField, CalendarDate baseDate) {
        this.cal = calt;
        this.periodField = periodField;
        this.period = CalendarPeriod.of(1, periodField);
        this.baseDate = baseDate;
        this.isCalendarField = periodField == CalendarPeriod.Field.Month || periodField == CalendarPeriod.Field.Year;
    }

    public double makeOffsetFromRefDate(CalendarDate date) {
        if (this.isCalendarField) {
            if (date.equals(this.baseDate)) {
                return 0.0;
            }
            return date.getDifference(this.baseDate, this.periodField);
        }
        long msecs = date.getDifferenceInMsecs(this.baseDate);
        return (double)msecs / this.period.getValueInMillisecs();
    }

    public CalendarDate makeCalendarDate(double value) {
        if (this.isCalendarField) {
            return this.baseDate.add(CalendarPeriod.of((int)value, this.periodField));
        }
        return this.baseDate.add(value, this.periodField);
    }

    public CalendarDate makeCalendarDate(int value) {
        if (this.isCalendarField) {
            return this.baseDate.add(CalendarPeriod.of(value, this.periodField));
        }
        return this.baseDate.add(value, this.periodField);
    }

    public String getUdUnit() {
        return this.toString();
    }

    public CalendarDate getBaseCalendarDate() {
        return this.baseDate;
    }

    public CalendarPeriod getCalendarPeriod() {
        return this.period;
    }

    public CalendarPeriod.Field getCalendarField() {
        return this.periodField;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public boolean isCalendarField() {
        return this.isCalendarField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarDateUnit that = (CalendarDateUnit)o;
        return this.isCalendarField == that.isCalendarField && this.cal == that.cal && this.period.equals(that.period) && this.periodField == that.periodField && this.baseDate.equals(that.baseDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cal, this.period, this.periodField, this.baseDate, this.isCalendarField});
    }

    public String toString() {
        Formatter f = new Formatter();
        if (this.isCalendarField) {
            f.format("%s", byCalendarString);
        }
        f.format("%s since %s", new Object[]{this.periodField, CalendarDateFormatter.toDateTimeStringISO(this.baseDate)});
        return f.toString();
    }

    Date getBaseDate() {
        return this.baseDate.toDate();
    }
}

