/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Dataset;
import thredds.server.metadata.nciso.bean.Extent;
import thredds.server.metadata.nciso.util.ElementNameComparator;
import thredds.server.metadata.nciso.util.NCMLModifier;
import thredds.server.metadata.nciso.util.ThreddsExtentUtil;
import thredds.server.metadata.nciso.util.XMLUtil;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.write.NcmlWriter;

public class EnhancedMetadataService {
    private static Logger _log = LoggerFactory.getLogger(EnhancedMetadataService.class);

    public static void enhance(NetcdfDataset dataset, Dataset ids, Writer writer) throws Exception {
        Extent ext = null;
        NCMLModifier ncmlMod = new NCMLModifier();
        ext = ThreddsExtentUtil.getExtent((NetcdfDataset)dataset);
        NcmlWriter ncMLWriter = new NcmlWriter();
        ByteArrayOutputStream dsToNcml = new ByteArrayOutputStream();
        dataset.writeNcml((OutputStream)dsToNcml, null);
        ByteArrayInputStream ncmlIs = new ByteArrayInputStream(dsToNcml.toByteArray());
        XMLUtil xmlUtil = new XMLUtil((InputStream)ncmlIs);
        List list = xmlUtil.elemFinder("//ncml:netcdf", "ncml", "http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
        Element rootElem = (Element)list.get(0);
        Element cfGroupElem = ncmlMod.doAddGroupElem(rootElem, "CFMetadata");
        ncmlMod.addCFMetadata(ext, cfGroupElem);
        Element ncIsoGroupElem = ncmlMod.doAddGroupElem(rootElem, "NCISOMetadata");
        ncmlMod.addNcIsoMetadata(ncIsoGroupElem);
        if (ids != null) {
            Element threddsGroupElem = ncmlMod.doAddGroupElem(rootElem, "THREDDSMetadata");
            ncmlMod.addThreddsMetadata(ids, threddsGroupElem);
        }
        Attribute locAttr = rootElem.getAttribute("location");
        String openDapService = ncmlMod.getOpenDapService() == null ? "Not provided because of security concerns." : ncmlMod.getOpenDapService();
        locAttr.setValue(openDapService);
        xmlUtil.sortElements(rootElem, (Comparator)new ElementNameComparator());
        xmlUtil.write(writer);
    }
}

