/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;

public final class AnyChildNodeTest
extends NodeTest {
    private static final AnyChildNodeTest THE_INSTANCE = new AnyChildNodeTest();

    public static AnyChildNodeTest getInstance() {
        return THE_INSTANCE;
    }

    private AnyChildNodeTest() {
    }

    public UType getUType() {
        return UType.CHILD_NODE_KINDS;
    }

    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return nodeKind == 1 || nodeKind == 3 || nodeKind == 8 || nodeKind == 7;
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        byte nodeKind = tree.nodeKind[nodeNr];
        return nodeKind == 1 || nodeKind == 3 || nodeKind == 4 || nodeKind == 8 || nodeKind == 7;
    }

    public boolean matchesNode(NodeInfo node) {
        int nodeKind = node.getNodeKind();
        return nodeKind == 1 || nodeKind == 3 || nodeKind == 8 || nodeKind == 7;
    }

    public double getDefaultPriority() {
        return -0.5;
    }

    public int getNodeKindMask() {
        return 394;
    }

    public String toString() {
        return "( element() | text() | comment() | processing-instruction() )";
    }

    public int hashCode() {
        return "AnyChildNodeTest".hashCode();
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe) {
        return "return SaxonJS.U.isNode(item) && (item.nodeType==1 || item.nodeType==3 || item.nodeType==7 || item.nodeType==8);";
    }
}

