/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.nciso.util;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.xml.XmlEscapers;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import thredds.server.metadata.nciso.bean.Extent;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class NCMLModifier {
    private static Logger logger = LoggerFactory.getLogger(NCMLModifier.class);
    private String _openDapService = null;
    private String _version = "2.4";
    private static DecimalFormat dFmt = new DecimalFormat(".#####");
    private Escaper xmlEscaper = XmlEscapers.xmlAttributeEscaper();
    private Escaper htmlEscaper = HtmlEscapers.htmlEscaper();

    public static String format(Double dbl) {
        return dFmt.format(dbl);
    }

    public void addCFMetadata(Extent ext, Element groupElem) {
        if (ext._minLon != null) {
            this.addElem(groupElem, "geospatial_lon_min", NCMLModifier.format(ext._minLon), "float");
        }
        if (ext._minLat != null) {
            this.addElem(groupElem, "geospatial_lat_min", NCMLModifier.format(ext._minLat), "float");
        }
        if (ext._maxLon != null) {
            this.addElem(groupElem, "geospatial_lon_max", NCMLModifier.format(ext._maxLon), "float");
        }
        if (ext._maxLat != null) {
            this.addElem(groupElem, "geospatial_lat_max", NCMLModifier.format(ext._maxLat), "float");
        }
        if (ext._lonUnits != null) {
            this.addElem(groupElem, "geospatial_lon_units", ext._lonUnits);
        }
        if (ext._latUnits != null) {
            this.addElem(groupElem, "geospatial_lat_units", ext._latUnits);
        }
        if (ext._lonRes != null) {
            this.addElem(groupElem, "geospatial_lon_resolution", ext._lonRes.toString());
        }
        if (ext._latRes != null) {
            this.addElem(groupElem, "geospatial_lat_resolution", ext._latRes.toString());
        }
        if (ext._minHeight != null) {
            this.addElem(groupElem, "geospatial_vertical_min", ext._minHeight.toString());
        }
        if (ext._maxHeight != null) {
            this.addElem(groupElem, "geospatial_vertical_max", ext._maxHeight.toString());
        }
        if (ext._heightUnits != null) {
            this.addElem(groupElem, "geospatial_vertical_units", ext._heightUnits);
        }
        if (ext._heightRes != null) {
            this.addElem(groupElem, "geospatial_vertical_resolution", ext._heightRes.toString());
        }
        if (ext._vOrientation != null) {
            this.addElem(groupElem, "geospatial_vertical_positive", ext._vOrientation);
        }
        if (ext._minTime != null) {
            this.addElem(groupElem, "time_coverage_start", ext._minTime.toString());
        }
        if (ext._maxTime != null) {
            this.addElem(groupElem, "time_coverage_end", ext._maxTime.toString());
        }
        if (ext._timeUnits != null) {
            this.addElem(groupElem, "time_coverage_units", ext._timeUnits.toString());
        }
        if (ext._timeRes != null) {
            this.addElem(groupElem, "time_coverage_resolution", ext._timeRes.toString());
        }
        if (ext._timeRes != null) {
            this.addElem(groupElem, "time_coverage_duration", ext._timeDuration.toString());
        }
    }

    public void addThreddsMetadata(Dataset ids, Element groupElem) throws Exception {
        List props;
        List metadata;
        DateRange tc;
        ThreddsMetadata.GeospatialCoverage gc;
        List vars;
        List publishers;
        List creators;
        List projects;
        List dates;
        List keywords;
        List contributors;
        List access;
        List docs;
        if (ids == null) {
            return;
        }
        if (ids.getID() != null) {
            this.addElem(groupElem, "id", ids.getID());
        }
        if (ids.getName() != null) {
            this.addElem(groupElem, "full_name", ids.getName());
        }
        if (ids.getDataFormatType() != null) {
            this.addElem(groupElem, "data_format_type", this.xmlEscaper.escape(ids.getDataFormatType().toString()));
        }
        if (ids.getDataFormatType() != null && ids.getFeatureType() != FeatureType.ANY) {
            this.addElem(groupElem, "data_type", this.xmlEscaper.escape(ids.getDataFormatName()));
        }
        if (ids.getCollectionType() != null) {
            this.addElem(groupElem, "collection_type", this.xmlEscaper.escape(ids.getCollectionType().toString()));
        }
        if (ids.getAuthority() != null) {
            this.addElem(groupElem, "authority", this.xmlEscaper.escape(ids.getAuthority()));
        }
        if ((docs = ids.getDocumentation()).size() > 0) {
            Element docsGrp = this.doAddGroupElem(groupElem, "documentation");
            for (Documentation doc : docs) {
                Element docGrp = this.doAddGroupElem(docsGrp, "document");
                String type = doc.getType() == null ? "" : this.xmlEscaper.escape(doc.getType());
                String inline = doc.getInlineContent();
                String xlink = null;
                String xlinkTitle = null;
                if (inline != null && inline.length() > 0) {
                    inline = this.xmlEscaper.escape(inline);
                }
                this.addElem(docGrp, "inline", inline, type);
                if (!doc.hasXlink()) continue;
                xlink = doc.getXlinkHref();
                xlinkTitle = doc.getXlinkTitle();
                this.addElem(docGrp, "xlink", xlink, type);
            }
        }
        if ((access = ids.getAccess()).size() > 0) {
            Element servicesGrp = this.doAddGroupElem(groupElem, "services");
            for (Access a : access) {
                Service s = a.getService();
                String urlString = a.getStandardUrlName();
                Object fullUrlString = urlString;
                ServiceType stype = s.getType();
                logger.debug("THREDDS service type=" + stype);
                if (stype == ServiceType.OPENDAP || stype == ServiceType.DODS) {
                    this.addElem(servicesGrp, "opendap_service", (String)fullUrlString);
                    this._openDapService = fullUrlString;
                    continue;
                }
                if (stype == ServiceType.HTTPServer) {
                    this.addElem(servicesGrp, "httpserver_service", (String)fullUrlString);
                    continue;
                }
                if (stype == ServiceType.WCS) {
                    fullUrlString = (String)fullUrlString + "?service=WCS&version=1.0.0&request=GetCapabilities";
                    this.addElem(servicesGrp, "wcs_service", (String)fullUrlString);
                    continue;
                }
                if (stype == ServiceType.WMS) {
                    fullUrlString = (String)fullUrlString + "?service=WMS&version=1.3.0&request=GetCapabilities";
                    this.addElem(servicesGrp, "wms_service", (String)fullUrlString);
                    continue;
                }
                if (stype == ServiceType.NetcdfSubset) {
                    fullUrlString = (String)fullUrlString + "/dataset.html";
                    this.addElem(servicesGrp, "nccs_service", (String)fullUrlString);
                    continue;
                }
                if (stype == ServiceType.CdmRemote || stype == ServiceType.CdmrFeature) {
                    fullUrlString = (String)fullUrlString + "?req=form";
                    this.addElem(servicesGrp, "cdmremote_service", (String)fullUrlString);
                    continue;
                }
                if (!stype.toString().equals("SOS")) continue;
                fullUrlString = (String)fullUrlString + "?service=SOS&version=1.0.0&request=GetCapabilities";
                this.addElem(servicesGrp, "sos_service", (String)fullUrlString);
            }
        }
        if ((contributors = ids.getContributors()).size() > 0) {
            Element contributorsGrp = this.doAddGroupElem(groupElem, "contributors");
            for (ThreddsMetadata.Contributor t : contributors) {
                Element contributorGrp = this.doAddGroupElem(contributorsGrp, "contributor");
                String role = t.getRole() == null ? "" : this.htmlEscaper.escape(t.getRole());
                this.addElem(contributorGrp, "role", role);
                String name = t.getName() == null ? "" : this.xmlEscaper.escape(t.getName());
                this.addElem(contributorGrp, "name", name);
            }
        }
        if ((keywords = ids.getKeywords()).size() > 0) {
            Element keywordsGrp = this.doAddGroupElem(groupElem, "keywords");
            for (ThreddsMetadata.Vocab t : keywords) {
                String vocab = t.getVocabulary() == null ? "" : this.xmlEscaper.escape(t.getVocabulary());
                String text = this.xmlEscaper.escape(t.getText());
                this.addElem(keywordsGrp, "keyword", text);
                if (vocab.equals("")) continue;
                this.addElem(keywordsGrp, "vocab", vocab);
            }
        }
        if ((dates = ids.getDates()).size() > 0) {
            Element datesGrp = this.doAddGroupElem(groupElem, "dates");
            for (DateType d : dates) {
                String type = d.getType() == null ? "" : this.xmlEscaper.escape(d.getType());
                String text = this.xmlEscaper.escape(d.getText());
                this.addElem(datesGrp, "date", text, type);
            }
        }
        if ((projects = ids.getProjects()).size() > 0) {
            Element projectsGrp = this.doAddGroupElem(groupElem, "projects");
            for (ThreddsMetadata.Vocab t : projects) {
                String vocab = t.getVocabulary() == null ? "" : this.xmlEscaper.escape(t.getVocabulary());
                String text = this.xmlEscaper.escape(t.getText());
                this.addElem(projectsGrp, "project", text);
                if (vocab.equals("")) continue;
                this.addElem(projectsGrp, "vocab", vocab);
            }
        }
        if ((creators = ids.getCreators()).size() > 0) {
            Element creatorsGrp = this.doAddGroupElem(groupElem, "creators");
            for (Object t : creators) {
                Element creatorGrp = this.doAddGroupElem(creatorsGrp, "creator");
                String name = this.xmlEscaper.escape(t.getName());
                String email = this.xmlEscaper.escape(t.getEmail());
                String url = t.getUrl() != null ? "" : t.getUrl();
                this.addElem(creatorGrp, "name", name);
                this.addElem(creatorGrp, "email", email);
                this.addElem(creatorGrp, "url", url);
            }
        }
        if ((publishers = ids.getPublishers()).size() > 0) {
            Element publishersGrp = this.doAddGroupElem(groupElem, "publishers");
            for (ThreddsMetadata.Source t : publishers) {
                Element publisherGrp = this.doAddGroupElem(publishersGrp, "publisher");
                String name = this.xmlEscaper.escape(t.getName());
                String email = this.xmlEscaper.escape(t.getEmail());
                String url = t.getUrl() != null ? "" : t.getUrl();
                this.addElem(publisherGrp, "name", name);
                this.addElem(publisherGrp, "email", email);
                this.addElem(publisherGrp, "url", url);
            }
        }
        if ((vars = ids.getVariables()).size() > 0) {
            for (ThreddsMetadata.Source t : vars) {
                String uri = t.getVocabUri() == null ? "" : t.getVocabUri().toString();
                this.addElem(groupElem, "standard_name_vocabulary", t.getVocabulary(), uri);
            }
        }
        if ((gc = ids.getGeospatialCoverage()) != null && gc.isValid()) {
            List nlist;
            this.addElem(groupElem, "geospatial_lon_min", Double.toString(gc.getBoundingBox().getLonMin()));
            this.addElem(groupElem, "geospatial_lat_min", Double.toString(gc.getBoundingBox().getLatMin()));
            this.addElem(groupElem, "geospatial_lon_max", Double.toString(gc.getBoundingBox().getLonMax()));
            this.addElem(groupElem, "geospatial_lat_max", Double.toString(gc.getBoundingBox().getLatMax()));
            if (gc.getUpDownRange() != null) {
                double minHeight = 0.0;
                double maxHeight = 0.0;
                if (gc.isZPositiveUp()) {
                    minHeight = gc.getHeightStart();
                    maxHeight = minHeight + gc.getHeightExtent();
                } else {
                    minHeight = gc.getHeightStart() * -1.0;
                    maxHeight = minHeight - gc.getHeightExtent();
                }
                double heightRes = gc.getHeightResolution();
                String heightUnits = gc.getUpDownRange().getUnits();
                this.addElem(groupElem, "geospatial_vertical_min", Double.toString(minHeight));
                this.addElem(groupElem, "geospatial_vertical_max", Double.toString(maxHeight));
                if (heightUnits != null) {
                    this.addElem(groupElem, "geospatial_vertical_units", heightUnits);
                }
                this.addElem(groupElem, "geospatial_vertical_resolution", Double.toString(heightRes));
                this.addElem(groupElem, "geospatial_vertical_positive", gc.getZPositive());
            }
            if ((nlist = gc.getNames()) != null && nlist.size() > 0) {
                Element vocabGrp = this.doAddGroupElem(groupElem, "vocab");
                for (ThreddsMetadata.Vocab elem : nlist) {
                    this.addElem(vocabGrp, "name", this.xmlEscaper.escape(elem.getText()));
                }
            }
        }
        if ((tc = ids.getTimeCoverage()) != null) {
            DateType end;
            DateType start = tc.getStart();
            if (start != null && !start.isBlank()) {
                this.addElem(groupElem, "time_coverage_start", start.toDateTimeString());
            }
            if ((end = tc.getEnd()) != null && !end.isBlank()) {
                this.addElem(groupElem, "time_coverage_end", end.toDateTimeString());
            }
            TimeDuration resolution = tc.getResolution();
            if (tc.useResolution() && resolution != null && !resolution.isBlank()) {
                this.addElem(groupElem, "time_coverage_resolution", this.xmlEscaper.escape(resolution.toString()));
            }
            TimeDuration duration = tc.getDuration();
            if (tc.useDuration() && duration != null && !duration.isBlank()) {
                this.addElem(groupElem, "time_coverage_duration", this.xmlEscaper.escape(duration.toString()));
            }
        }
        if ((metadata = ids.getMetadataOther()).size() > 0) {
            Element metaGrp = this.doAddGroupElem(groupElem, "metadata");
            for (ThreddsMetadata.MetadataOther m : metadata) {
                String type = m.getType() == null ? "" : m.getType();
                Object title = m.getTitle() == null ? "Type " + type : m.getTitle();
                this.addElem(metaGrp, (String)title, m.getXlinkHref());
            }
        }
        if ((props = ids.getProperties()).size() > 0) {
            Element propsGrp = this.doAddGroupElem(groupElem, "properties");
            for (Property p : props) {
                this.addElem(propsGrp, p.getName(), p.getValue());
            }
        }
    }

    public void addNcIsoMetadata(Element groupElem) {
        Date dateStamp = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String metadata_creation_date = sdf.format(dateStamp);
        this.addElem(groupElem, "metadata_creation", metadata_creation_date);
        this.addElem(groupElem, "nciso_version", this.getVersion());
    }

    String getVersion() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("project.properties"));
            String version = properties.getProperty("version");
            return version == null ? this._version : version;
        }
        catch (IOException e) {
            return this._version;
        }
    }

    private Element newGroupElement() {
        return new Element("group");
    }

    private Element newAttributeElement() {
        return new Element("attribute");
    }

    public Element doAddGroupElem(Element rootElem, String name) {
        Namespace ns = Namespace.getNamespace("http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
        Element groupElem = this.newGroupElement();
        groupElem.setAttribute("name", name);
        groupElem.setNamespace(ns);
        rootElem.addContent(groupElem);
        return groupElem;
    }

    private void doAddElem(Element groupElem, String name, String value, String type) {
        Namespace ns = Namespace.getNamespace("http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
        Element elem = this.newAttributeElement();
        elem.setAttribute("name", name);
        elem.setAttribute("value", value);
        if (type != null) {
            elem.setAttribute("type", type);
        }
        elem.setNamespace(ns);
        groupElem.addContent(elem);
    }

    private void addElem(Element rootElem, String name, String value) {
        this.doAddElem(rootElem, name, value, null);
    }

    private void addElem(Element rootElem, String name, String value, String type) {
        this.doAddElem(rootElem, name, value, type);
    }

    public String getOpenDapService() {
        return this._openDapService;
    }
}

