/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.controller;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import thredds.client.catalog.Dataset;
import thredds.core.TdsRequestedDataset;
import thredds.server.metadata.controller.IMetadataContoller;

public abstract class AbstractMetadataController
implements ServletContextAware,
IMetadataContoller {
    private static Logger _log = LoggerFactory.getLogger(AbstractMetadataController.class);
    protected static Logger _logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    protected boolean _allow = false;
    protected String _metadataServiceType = "";
    protected String _servletPath = "";
    protected ServletContext sc;

    public void setServletContext(ServletContext sc) {
        this.sc = sc;
    }

    protected void isAllowed(boolean allow, String metadataServiceType, HttpServletResponse res) throws Exception {
        if (!allow) {
            res.sendError(403, metadataServiceType + " service not supported");
            return;
        }
    }

    protected void returnError(String message, String metadataServiceType, HttpServletResponse res) throws Exception {
        res.sendError(500, metadataServiceType + " service failed. " + message);
    }

    @Override
    public void handleMetadataRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
    }

    protected Dataset getThreddsDataset(HttpServletRequest req, HttpServletResponse res) {
        try {
            return (Dataset)TdsRequestedDataset.getGridDataset((HttpServletRequest)req, (HttpServletResponse)res, null);
        }
        catch (IOException e) {
            _log.error("IOException while trying to get GridDataset:\n" + e.getLocalizedMessage());
            return null;
        }
    }

    protected abstract String getPath();

    protected String getInfoPath(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        String pathInfo = servletPath.substring(this.getPath().length(), servletPath.length());
        return pathInfo;
    }
}

