/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.controller;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.catalog.InvDataset;
import thredds.server.metadata.controller.AbstractMetadataController;
import thredds.server.metadata.exception.ThreddsUtilitiesException;
import thredds.server.metadata.service.EnhancedMetadataService;
import thredds.server.metadata.util.DatasetHandlerAdapter;
import thredds.server.metadata.util.ThreddsTranslatorUtil;
import thredds.servlet.ThreddsConfig;
import thredds.util.ContentType;
import ucar.nc2.dataset.NetcdfDataset;

@Controller
@RequestMapping(value={"/uddc/"})
public class UddcController
extends AbstractMetadataController
implements InitializingBean {
    private static Logger _log = LoggerFactory.getLogger(UddcController.class);

    @Override
    protected String getPath() {
        return this._metadataServiceType + "/";
    }

    public void afterPropertiesSet() throws ServletException {
        this._metadataServiceType = "UDDC";
        this._servletPath = "/uddc";
        _logServerStartup.info("Metadata UDDC - initialization start");
        this._allow = ThreddsConfig.getBoolean((String)"NCISO.uddcAllow", (boolean)false);
        _logServerStartup.info("NCISO.uddcAllow = " + this._allow);
        String ncIsoXslFilePath = this.sc.getRealPath("/WEB-INF/classes/resources/xsl/nciso") + "/UnidataDDCount-HTML.xsl";
        this.xslFile = new File(ncIsoXslFilePath);
    }

    public void destroy() {
        NetcdfDataset.shutdown();
        _logServerStartup.info("Metadata UDDC - destroy done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @RequestMapping(value={"**"}, params={})
    public void handleMetadataRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        block13: {
            _log.info("Handling UDDC metadata request.");
            NetcdfDataset netCdfDataset = null;
            try {
                this._allow = ThreddsConfig.getBoolean((String)"NCISO.isoAllow", (boolean)false);
                this.isAllowed(this._allow, this._metadataServiceType, res);
                res.setContentType(ContentType.html.getContentHeader());
                netCdfDataset = DatasetHandlerAdapter.openDataset(req, res, this.getInfoPath(req));
                if (netCdfDataset == null) {
                    res.sendError(404, "ThreddsIso Extension: Requested resource not found.");
                } else {
                    StringWriter writer = new StringWriter();
                    InvDataset ids = this.getThreddsDataset(req);
                    EnhancedMetadataService.enhance(netCdfDataset, ids, writer);
                    String ncml = ((Object)writer).toString();
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    ByteArrayInputStream is = new ByteArrayInputStream(ncml.getBytes("UTF-8"));
                    ThreddsTranslatorUtil.transform(this.xslFile, (InputStream)is, (Writer)res.getWriter());
                    res.getWriter().flush();
                }
                DatasetHandlerAdapter.closeDataset(netCdfDataset);
            }
            catch (ThreddsUtilitiesException tue) {
                String errMsg = "Error in UDDCController: " + req.getQueryString();
                _log.error(errMsg, (Throwable)tue);
                try {
                    this.returnError(errMsg, this._metadataServiceType, res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                String errMsg = "Error in UDDCController: " + req.getQueryString();
                _log.error(errMsg, (Throwable)e);
                try {
                    this.returnError(errMsg, this._metadataServiceType, res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                break block13;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DatasetHandlerAdapter.closeDataset(netCdfDataset);
            }
        }
    }
}

