/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;

public class DatasetHandlerAdapter {
    private static Logger _log = Logger.getLogger(DatasetHandlerAdapter.class);

    public static NetcdfDataset openDataset(HttpServletRequest req, HttpServletResponse res, String datasetPath) throws Exception {
        NetcdfFile netcdfFile = null;
        NetcdfDataset dataset = null;
        if (datasetPath == null) {
            datasetPath = ServletUtil.getParameterIgnoreCase((HttpServletRequest)req, (String)"dataset");
            _log.debug((Object)("opendap datasetPath: " + datasetPath));
            try {
                dataset = NetcdfDataset.openDataset((String)datasetPath);
            }
            catch (IOException e) {
                res.setStatus(404);
                _log.debug((Object)("Failed to open dataset <" + datasetPath + ">: " + e.getMessage()));
            }
        } else {
            try {
                netcdfFile = DatasetHandler.getNetcdfFile((HttpServletRequest)req, (HttpServletResponse)res, (String)datasetPath);
                _log.debug((Object)("datasetPath: " + datasetPath + " netcdfFile location: " + netcdfFile.getLocation()));
                dataset = new NetcdfDataset(netcdfFile);
            }
            catch (FileNotFoundException fnfe) {
                res.setStatus(404);
                _log.debug((Object)("Failed to get NetcdfFile <" + datasetPath + ">: " + fnfe.getMessage()), (Throwable)fnfe);
            }
            catch (IOException ioe) {
                res.setStatus(404);
                _log.debug((Object)("Failed to get NetcdfFile <" + datasetPath + "> using " + netcdfFile.getLocation() + ": " + ioe.getMessage()), (Throwable)ioe);
            }
        }
        return dataset;
    }

    public static void closeDataset(NetcdfDataset dataset) {
        if (dataset == null) {
            return;
        }
        try {
            dataset.close();
        }
        catch (IOException ioe) {
            _log.warn((Object)"Failed to properly close the dataset", (Throwable)ioe);
        }
    }
}

