/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.util;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.metadata.bean.Extent;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

public class ThreddsExtentUtil {
    private static Logger _log = LoggerFactory.getLogger(ThreddsExtentUtil.class);

    private static Extent doGetExtent(String url) throws Exception {
        Extent ext = null;
        try {
            NetcdfDataset ncd = NetcdfDataset.openDataset((String)url);
            ext = ThreddsExtentUtil.getExtent(ncd);
        }
        catch (Exception e) {
            e.printStackTrace();
            String err = "Could not load NETCDF file: " + url + " because of Exception. " + e.getLocalizedMessage();
            _log.error(err, (Throwable)e);
        }
        return ext;
    }

    private static boolean isLatCoord(Attribute att) {
        if (att.getName().equals("standard_name") && (att.getStringValue().equals("latitude") || att.getStringValue().equals("grid_latitude"))) {
            return true;
        }
        return att.getName().equals("units") && att.getStringValue().equals("degrees_north");
    }

    private static boolean isLonCoord(Attribute att) {
        if (att.getName().equals("standard_name") && (att.getStringValue().equals("longitude") || att.getStringValue().equals("grid_longitude"))) {
            return true;
        }
        return att.getName().equals("units") && att.getStringValue().equals("degrees_east");
    }

    private static Extent doGetExtent(NetcdfDataset ncd) throws Exception {
        double maxLon = -9999.999;
        double minLon = 9999.999;
        double maxLat = -9999.999;
        double minLat = 9999.999;
        String latUnits = null;
        String lonUnits = null;
        Extent ext = new Extent();
        List coordAxes = ncd.getCoordinateAxes();
        try {
            List vars = ncd.getVariables();
            for (Variable var : vars) {
                List atts = var.getAttributes();
                for (Attribute att : atts) {
                    int i;
                    Array vals;
                    if (ThreddsExtentUtil.isLatCoord(att)) {
                        latUnits = var.getUnitsString();
                        vals = var.read();
                        long latSize = vals.getSize();
                        i = 0;
                        while ((long)i < vals.getSize()) {
                            double lat = vals.getDouble(i);
                            if (lat > maxLat) {
                                maxLat = lat;
                            }
                            if (lat < minLat) {
                                minLat = lat;
                            }
                            ++i;
                        }
                        if (minLat != 9999.999) {
                            ext._minLat = minLat;
                        }
                        if (maxLat != 9999.999) {
                            ext._maxLat = maxLat;
                        }
                        ext._latRes = 0.0;
                        if (latSize - 1L > 0L) {
                            ext._latRes = (maxLat - minLat) / (double)(latSize - 1L);
                        }
                    }
                    if (!ThreddsExtentUtil.isLonCoord(att)) continue;
                    lonUnits = var.getUnitsString();
                    vals = var.read();
                    long lonSize = vals.getSize();
                    i = 0;
                    while ((long)i < vals.getSize()) {
                        double lon = vals.getDouble(i);
                        if (lon > maxLon) {
                            maxLon = lon;
                        }
                        if (lon < minLon) {
                            minLon = lon;
                        }
                        ++i;
                    }
                    if (minLon != 9999.999) {
                        ext._minLon = minLon;
                    }
                    if (maxLon != 9999.999) {
                        ext._maxLon = maxLon;
                    }
                    ext._lonRes = 0.0;
                    if (lonSize - 1L <= 0L) continue;
                    ext._lonRes = (maxLat - minLat) / (double)(lonSize - 1L);
                }
            }
            for (CoordinateAxis coordAxis : coordAxes) {
                if (coordAxis.getAxisType() == AxisType.Time && coordAxis.getFullName().equalsIgnoreCase("TIME")) {
                    _log.info("numTimeElems=" + coordAxis.getSize());
                    _log.info("axisName=" + coordAxis.getFullName());
                    ThreddsExtentUtil.logAvailableMemory("Retrieving Time coordAxis values");
                    ext._minTime = Double.toString(coordAxis.getMinValue());
                    ext._maxTime = Double.toString(coordAxis.getMaxValue());
                    String rawMinTime = Double.toString(coordAxis.getMinValue());
                    String rawMaxTime = Double.toString(coordAxis.getMaxValue());
                    _log.info("udunits string = " + rawMinTime + " " + coordAxis.getUnitsString());
                    Date startDate = DateUnit.getStandardDate((String)(rawMinTime + " " + coordAxis.getUnitsString()));
                    Date endDate = DateUnit.getStandardDate((String)(rawMaxTime + " " + coordAxis.getUnitsString()));
                    DateFormatter df = new DateFormatter();
                    ext._minTime = df.toDateTimeStringISO(startDate);
                    ext._maxTime = df.toDateTimeStringISO(endDate);
                    long duration = endDate.getTime() - startDate.getTime();
                    ext._timeDuration = DurationFormatUtils.formatDurationISO((long)duration);
                    double timeRes = 0.0;
                    if (coordAxis.getSize() - 1L > 0L) {
                        timeRes = duration / 1000L / (coordAxis.getSize() - 1L);
                    }
                    ext._timeRes = Double.toString(timeRes);
                    ext._timeUnits = "seconds";
                }
                if (coordAxis.getAxisType() != AxisType.Height || !coordAxis.getFullName().equalsIgnoreCase("DEPTH")) continue;
                _log.info("axisName=" + coordAxis.getFullName());
                ext._minHeight = coordAxis.getMinValue();
                ext._maxHeight = coordAxis.getMaxValue();
                ext._heightUnits = coordAxis.getUnitsString();
                ext._vOrientation = coordAxis.getPositive();
                ext._heightRes = 0.0;
                if (coordAxis.getSize() - 1L <= 0L) continue;
                ext._heightRes = (coordAxis.getMaxValue() - coordAxis.getMinValue()) / (double)coordAxis.getSize() - 1.0;
            }
        }
        catch (Exception e) {
            _log.error("Error in doGetExtent", (Throwable)e);
        }
        return ext;
    }

    private static Extent doGetExtentByAxis(NetcdfDataset ncd) throws Exception {
        Extent ext = new Extent();
        List coordAxes = ncd.getCoordinateAxes();
        try {
            for (CoordinateAxis coordAxis : coordAxes) {
                if (coordAxis.getAxisType() == AxisType.Lat) {
                    ext._minLat = coordAxis.getMinValue();
                    ext._maxLat = coordAxis.getMaxValue();
                    ext._latUnits = coordAxis.getUnitsString();
                    ext._latRes = 0.0;
                    if (coordAxis.getSize() - 1L > 0L) {
                        ext._latRes = (coordAxis.getMaxValue() - coordAxis.getMinValue()) / (double)(coordAxis.getSize() - 1L);
                    }
                }
                if (coordAxis.getAxisType() == AxisType.Lon) {
                    ext._minLon = coordAxis.getMinValue();
                    ext._maxLon = coordAxis.getMaxValue();
                    ext._lonUnits = coordAxis.getUnitsString();
                    ext._lonRes = 0.0;
                    if (coordAxis.getSize() - 1L > 0L) {
                        ext._lonRes = (coordAxis.getMaxValue() - coordAxis.getMinValue()) / (double)(coordAxis.getSize() - 1L);
                    }
                }
                if (coordAxis.getAxisType() == AxisType.Time && coordAxis.getFullName().equalsIgnoreCase("TIME")) {
                    _log.info("numTimeElems=" + coordAxis.getSize());
                    _log.info("axisName=" + coordAxis.getFullName());
                    ThreddsExtentUtil.logAvailableMemory("Retrieving Time coordAxis values");
                    ext._minTime = Double.toString(coordAxis.getMinValue());
                    ext._maxTime = Double.toString(coordAxis.getMaxValue());
                    String rawMinTime = Double.toString(coordAxis.getMinValue());
                    String rawMaxTime = Double.toString(coordAxis.getMaxValue());
                    _log.info("udunits string = " + rawMinTime + " " + coordAxis.getUnitsString());
                    Date startDate = DateUnit.getStandardDate((String)(rawMinTime + " " + coordAxis.getUnitsString()));
                    Date endDate = DateUnit.getStandardDate((String)(rawMaxTime + " " + coordAxis.getUnitsString()));
                    DateFormatter df = new DateFormatter();
                    ext._minTime = df.toDateTimeStringISO(startDate);
                    ext._maxTime = df.toDateTimeStringISO(endDate);
                    long duration = endDate.getTime() - startDate.getTime();
                    ext._timeDuration = DurationFormatUtils.formatDurationISO((long)duration);
                    double timeRes = 0.0;
                    if (coordAxis.getSize() - 1L > 0L) {
                        timeRes = duration / 1000L / (coordAxis.getSize() - 1L);
                    }
                    ext._timeRes = Double.toString(timeRes);
                    ext._timeUnits = "seconds";
                }
                if (coordAxis.getAxisType() != AxisType.Height || !coordAxis.getFullName().equalsIgnoreCase("DEPTH")) continue;
                _log.info("axisName=" + coordAxis.getFullName());
                ext._minHeight = coordAxis.getMinValue();
                ext._maxHeight = coordAxis.getMaxValue();
                ext._heightUnits = coordAxis.getUnitsString();
                ext._vOrientation = coordAxis.getPositive();
                ext._heightRes = 0.0;
                if (coordAxis.getSize() - 1L <= 0L) continue;
                ext._heightRes = (coordAxis.getMaxValue() - coordAxis.getMinValue()) / (double)coordAxis.getSize() - 1.0;
            }
        }
        catch (Exception e) {
            _log.error("Error in doGetExtentByAxis", (Throwable)e);
        }
        return ext;
    }

    public static Extent getExtent(String url) throws Exception {
        return ThreddsExtentUtil.doGetExtent(url);
    }

    public static Extent getExtent(NetcdfDataset ncd) throws Exception {
        if (FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncd) != null && FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncd) != FeatureType.GRID) {
            _log.info("FeatureType is not null && not a grid getting extent by reading arrays: " + FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncd));
            return ThreddsExtentUtil.doGetExtent(ncd);
        }
        _log.info("FeatureType is null or a GRID getting extent from axes: " + FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncd));
        return ThreddsExtentUtil.doGetExtentByAxis(ncd);
    }

    private static void logAvailableMemory(String message) {
        int mb = 0x100000;
        _log.debug(message);
        _log.info("Total Memory: " + Runtime.getRuntime().totalMemory() / (long)mb);
        _log.info("Free Memory: " + Runtime.getRuntime().freeMemory() / (long)mb);
    }
}

