/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.catalog.InvDataset;
import thredds.server.metadata.controller.AbstractMetadataController;
import thredds.server.metadata.service.EnhancedMetadataService;
import thredds.server.metadata.util.DatasetHandlerAdapter;
import thredds.servlet.ThreddsConfig;
import thredds.util.ContentType;
import ucar.nc2.dataset.NetcdfDataset;

@Controller
@RequestMapping(value={"/ncml/"})
public class NcmlController
extends AbstractMetadataController
implements InitializingBean {
    private static Logger _log = LoggerFactory.getLogger(NcmlController.class);

    @Override
    protected String getPath() {
        return this._metadataServiceType + "/";
    }

    public void afterPropertiesSet() throws ServletException {
        this._metadataServiceType = "NCML";
        this._servletPath = "/ncml";
        _logServerStartup.info("Metadata NCML - initialization start");
        this._allow = ThreddsConfig.getBoolean((String)"NCISO.ncmlAllow", (boolean)false);
        _logServerStartup.info("NCISO.ncmlAllow = " + this._allow);
    }

    public void destroy() {
        NetcdfDataset.shutdown();
        _logServerStartup.info("Metadata NCML - destroy done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequestMapping(value={"**"}, params={})
    public void handleMetadataRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        NetcdfDataset netCdfDataset;
        block7: {
            _log.info("Handling NCML metadata request.");
            netCdfDataset = null;
            try {
                this._allow = ThreddsConfig.getBoolean((String)"NCISO.isoAllow", (boolean)false);
                this.isAllowed(this._allow, this._metadataServiceType, res);
                res.setContentType(ContentType.xml.getContentHeader());
                netCdfDataset = DatasetHandlerAdapter.openDataset(req, res, this.getInfoPath(req));
                if (netCdfDataset == null) {
                    res.sendError(404, "ThreddsIso Extension: Requested resource not found.");
                    break block7;
                }
                PrintWriter writer = res.getWriter();
                InvDataset ids = this.getThreddsDataset(req);
                EnhancedMetadataService.enhance(netCdfDataset, ids, writer);
                ((Writer)writer).flush();
            }
            catch (Exception e) {
                try {
                    String errMsg = "Error in " + this._metadataServiceType + ": " + req.getQueryString();
                    _log.error(errMsg, (Throwable)e);
                    try {
                        this.returnError(errMsg, this._metadataServiceType, res);
                    }
                    catch (Exception fe) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    DatasetHandlerAdapter.closeDataset(netCdfDataset);
                    throw throwable;
                }
                DatasetHandlerAdapter.closeDataset(netCdfDataset);
            }
        }
        DatasetHandlerAdapter.closeDataset(netCdfDataset);
    }
}

