/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.iosp.bufr.tables.NcepMnemonic;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.iosp.bufr.tables.WmoXmlReader;
import ucar.nc2.util.TableParser;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class BufrTables {
    static final String RESOURCE_PATH = "/resources/bufrTables/";
    private static final String canonicalLookup = "resource:/resources/bufrTables/local/tablelookup.csv";
    private static final String version14 = "wmo.v14";
    private static final Logger log = LoggerFactory.getLogger(BufrTables.class);
    private static final boolean debugTable = false;
    private static final boolean showTables = false;
    private static final boolean showReadErrs = true;
    private static List<TableConfig> tables;
    private static final Map<String, TableB> tablesB;
    private static final Map<String, TableD> tablesD;
    private static List<String> lookups;
    private static TableB latestWmoB;
    private static TableD latestWmoD;
    private static final Pattern threeInts;
    private static final Pattern negOne;

    public static void addLookupFile(String filename) throws FileNotFoundException {
        File f;
        if (lookups == null) {
            lookups = new ArrayList<String>();
        }
        if (!(f = new File(filename)).exists()) {
            throw new FileNotFoundException(filename + " not found");
        }
        lookups.add(filename);
    }

    private static void readLookupTable() {
        tables = new ArrayList<TableConfig>();
        if (lookups != null) {
            lookups.add(canonicalLookup);
            for (String fname : lookups) {
                BufrTables.readLookupTable(fname);
            }
        } else {
            BufrTables.readLookupTable(canonicalLookup);
        }
    }

    private static void readLookupTable(String filename) {
        try {
            String line;
            InputStream ios = BufrTables.openStream(filename);
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, Charset.forName("UTF8")));
            int count = 0;
            while ((line = dataIS.readLine()) != null) {
                if (line.startsWith("#")) continue;
                ++count;
                String[] flds = line.split(",");
                if (flds.length < 8) {
                    System.out.printf("%d BAD line == %s%n", count, line);
                    continue;
                }
                int fldidx = 0;
                try {
                    TableConfig table = new TableConfig();
                    table.name = flds[fldidx++].trim();
                    table.center = Integer.parseInt(flds[fldidx++].trim());
                    table.subcenter = Integer.parseInt(flds[fldidx++].trim());
                    table.master = Integer.parseInt(flds[fldidx++].trim());
                    table.local = Integer.parseInt(flds[fldidx++].trim());
                    table.cat = Integer.parseInt(flds[fldidx++].trim());
                    table.tableBname = flds[fldidx++].trim();
                    table.tableBformat = BufrTables.getFormat(flds[fldidx++].trim(), line);
                    if (table.tableBformat == null) continue;
                    table.tableDname = flds[fldidx++].trim();
                    table.tableDformat = BufrTables.getFormat(flds[fldidx++].trim(), line);
                    if (fldidx < flds.length) {
                        String modes;
                        if ((modes = flds[fldidx++].trim()).equalsIgnoreCase("wmoLocal")) {
                            table.mode = Mode.wmoLocal;
                        } else if (modes.equalsIgnoreCase("localWmo")) {
                            table.mode = Mode.localOverride;
                        }
                    }
                    tables.add(table);
                }
                catch (Exception e) {
                    System.out.printf("%d %d BAD line == %s (%s)%n", count, fldidx, line, e.getMessage());
                }
            }
            dataIS.close();
        }
        catch (IOException ioe) {
            String mess = "Need BUFR tables in path; looking for " + filename;
            throw new RuntimeException(mess, ioe);
        }
    }

    private static Format getFormat(String formatS, String line) {
        if (formatS.length() == 0) {
            return null;
        }
        Format result = Format.valueOf(formatS);
        if (result == null) {
            System.out.printf("BAD format = %s line == %s%n", formatS, line);
            return null;
        }
        return result;
    }

    public static List<TableConfig> getTables() {
        if (tables == null) {
            BufrTables.readLookupTable();
        }
        return tables;
    }

    private static TableConfig matchTableConfig(int center, int subcenter, int master, int local, int cat) {
        if (tables == null) {
            BufrTables.readLookupTable();
        }
        for (TableConfig tc : tables) {
            if (!tc.matches(center, subcenter, master, local, cat)) continue;
            return tc;
        }
        return null;
    }

    private static TableConfig matchTableConfig(BufrIdentificationSection ids) {
        if (tables == null) {
            BufrTables.readLookupTable();
        }
        int center = ids.getCenterId();
        int subcenter = ids.getSubCenterId();
        int master = ids.getMasterTableVersion();
        int local = ids.getLocalTableVersion();
        int cat = ids.getCategory();
        return BufrTables.matchTableConfig(center, subcenter, master, local, cat);
    }

    public static Tables getLocalTables(BufrIdentificationSection ids) throws IOException {
        TableConfig tc = BufrTables.matchTableConfig(ids);
        if (tc == null) {
            return null;
        }
        if (tc.tableBformat == Format.ncep_nm) {
            TableB b = tablesB.get(tc.tableBname);
            TableD d = tablesD.get(tc.tableBname);
            if (b != null && d != null) {
                return new Tables(b, d, tc.mode);
            }
            b = new TableB(tc.tableBname, tc.tableBname);
            d = new TableD(tc.tableBname, tc.tableBname);
            Tables t = new Tables(b, d, tc.mode);
            InputStream ios = BufrTables.openStream(tc.tableBname);
            NcepMnemonic.read(ios, t);
            tablesB.put(tc.tableBname, t.b);
            tablesD.put(tc.tableBname, t.d);
            return t;
        }
        Tables tables = new Tables();
        tables.b = BufrTables.readTableB(tc.tableBname, tc.tableBformat, false);
        tables.d = BufrTables.readTableD(tc.tableDname, tc.tableDformat, false);
        tables.mode = tc.mode;
        return tables;
    }

    public static TableB getWmoTableBlatest() {
        if (latestWmoB == null) {
            try {
                latestWmoB = BufrTables.getWmoTableB(16);
            }
            catch (IOException ioe) {
                log.error("Cant open latest WMO ", (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
        }
        return latestWmoB;
    }

    public static TableB getWmoTableB(BufrIdentificationSection ids) throws IOException {
        return BufrTables.getWmoTableB(ids.getMasterTableVersion());
    }

    public static TableB getWmoTableBold(int version) throws IOException {
        String version13 = "wmo.v13.composite";
        String tableName = version == 14 ? version14 : version13;
        TableB tb = tablesB.get(tableName);
        if (tb != null) {
            return tb;
        }
        TableConfig tc14 = BufrTables.matchTableConfig(0, 0, 14, 0, -1);
        TableB result = BufrTables.readTableB(tc14.tableBname, tc14.tableBformat, false);
        tablesB.put(version14, result);
        if (version < 14) {
            TableConfig tc = BufrTables.matchTableConfig(0, 0, 13, 0, -1);
            TableB b13 = BufrTables.readTableB(tc.tableBname, tc.tableBformat, false);
            TableB.Composite bb = new TableB.Composite(version13, version13);
            bb.addTable(b13);
            bb.addTable(result);
            result = bb;
            tablesB.put(version13, result);
        }
        return result;
    }

    public static TableB getWmoTableB(int version) throws IOException {
        TableConfig tc = BufrTables.matchTableConfig(0, 0, version, 0, -1);
        if (tc != null) {
            return BufrTables.readTableB(tc.tableBname, tc.tableBformat, false);
        }
        return null;
    }

    public static TableB readTableB(String location, Format format, boolean force) throws IOException {
        TableB tb;
        if (!force && (tb = tablesB.get(location)) != null) {
            return tb;
        }
        InputStream ios = BufrTables.openStream(location);
        TableB b = new TableB(location, location);
        switch (format) {
            case cypher: {
                BufrTables.readCypherTableB(ios, b);
                break;
            }
            case ecmwf: {
                BufrTables.readEcmwfTableB(ios, b);
                break;
            }
            case embed: {
                ios.close();
                b = BufrTables.readEmbeddedTableB(location);
                break;
            }
            case ncep: {
                BufrTables.readNcepTableB(ios, b);
                break;
            }
            case ncep_nm: {
                Tables t = new Tables(b, null, null);
                NcepMnemonic.read(ios, t);
                break;
            }
            case mel_bufr: {
                BufrTables.readMelbufrTableB(ios, b);
                break;
            }
            case mel_tabs: {
                BufrTables.readMeltabTableB(ios, b);
                break;
            }
            case opera: {
                BufrTables.readOperaTableB(ios, b);
                break;
            }
            case ukmet: {
                BufrTables.readBmetTableB(ios, b);
                break;
            }
            case wmo_csv: {
                BufrTables.readWmoCsvTableB(ios, b);
                break;
            }
            case wmo_xml: {
                WmoXmlReader.readWmoXmlTableB(ios, b);
            }
        }
        if (b != null) {
            tablesB.put(location, b);
        }
        return b;
    }

    private static void readWmoCsvTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, Charset.forName("UTF8")));
        int count = 0;
        while ((line = dataIS.readLine()) != null) {
            String[] flds;
            if (line.startsWith("#") || ++count == 1) continue;
            int pos1 = line.indexOf(34);
            if (pos1 >= 0) {
                int pos2 = line.indexOf(34, pos1 + 1);
                StringBuffer sb = new StringBuffer(line);
                for (int i = pos1; i < pos2; ++i) {
                    if (sb.charAt(i) != ',') continue;
                    sb.setCharAt(i, ' ');
                }
                line = sb.toString();
            }
            if ((flds = line.split(",")).length < 7) {
                System.out.printf("%d BAD split == %s%n", count, line);
                continue;
            }
            int fldidx = 0;
            try {
                int classId = Integer.parseInt(flds[fldidx++].trim());
                int xy = Integer.parseInt(flds[fldidx++].trim());
                String name = StringUtil2.remove((String)flds[fldidx++], (int)34);
                String units = StringUtil2.filter((String)flds[fldidx++], (String)" %+-_/()*");
                int scale = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int refVal = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int width = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int x = xy / 1000;
                int y = xy % 1000;
                b.addDescriptor((short)x, (short)y, scale, refVal, width, name, units, null);
            }
            catch (Exception e) {
                System.out.printf("%d %d BAD line == %s%n", count, fldidx, line);
            }
        }
        dataIS.close();
    }

    private static String clean(String s) {
        return StringUtil2.remove((String)s, (int)32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableB readEmbeddedTableB(String location) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(location, "r");
            MessageScanner scan = new MessageScanner(raf);
            TableLookup lookup = scan.getTableLookup();
            if (lookup != null) {
                TableB tableB = lookup.getLocalTableB();
                return tableB;
            }
            TableB tableB = null;
            return tableB;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableD readEmbeddedTableD(String location) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(location, "r");
            MessageScanner scan = new MessageScanner(raf);
            TableLookup lookup = scan.getTableLookup();
            if (lookup != null) {
                TableD tableD = lookup.getLocalTableD();
                return tableD;
            }
            TableD tableD = null;
            return tableD;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    private static TableB readMelbufrTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.length() == 0) continue;
            try {
                String[] split = line.split(";");
                short x = Short.parseShort(split[1].trim());
                short y = Short.parseShort(split[2].trim());
                int scale = Integer.parseInt(split[3].trim());
                int refVal = Integer.parseInt(split[4].trim());
                int width = Integer.parseInt(split[5].trim());
                b.addDescriptor(x, y, scale, refVal, width, split[7], split[6], null);
            }
            catch (Exception e) {
                log.error("Bad table B entry: table=" + b.getName() + " entry=<" + line + ">", (Object)e.getMessage());
            }
        }
        dataIS.close();
        return b;
    }

    private static TableB readCypherTableB(InputStream ios, TableB b) throws IOException {
        String line;
        boolean startMode = false;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("<")) continue;
            if (line.startsWith("#")) {
                startMode = true;
                continue;
            }
            if (!startMode) continue;
            try {
                String xys = line.substring(0, 8).trim();
                int xy = Integer.parseInt(xys);
                short x = (short)(xy / 1000);
                short y = (short)(xy % 1000);
                String name = WmoXmlReader.cleanName(line.substring(8));
                String units = WmoXmlReader.cleanUnit(dataIS.readLine());
                line = dataIS.readLine();
                line = StringUtil2.remove((String)line, (int)42);
                String[] split = StringUtil2.splitString((String)line);
                int scale = Integer.parseInt(split[0].trim());
                int refVal = Integer.parseInt(split[1].trim());
                int width = Integer.parseInt(split[2].trim());
                b.addDescriptor(x, y, scale, refVal, width, name, units, null);
                startMode = false;
            }
            catch (Exception e) {
                log.error("Bad table B entry: table=" + b.getName() + " entry=<" + line + ">", (Object)e.getMessage());
            }
        }
        dataIS.close();
        return b;
    }

    private static TableB readMeltabTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.length() == 0) continue;
            try {
                String[] split = line.split("\t");
                short x = Short.parseShort(split[1].trim());
                short y = Short.parseShort(split[2].trim());
                int scale = Integer.parseInt(split[3].trim());
                int refVal = Integer.parseInt(split[4].trim());
                int width = Integer.parseInt(split[5].trim());
                b.addDescriptor(x, y, scale, refVal, width, split[7], split[6], null);
            }
            catch (Exception e) {
                log.error("Bad table " + b.getName() + " entry=<" + line + ">", (Throwable)e);
            }
        }
        dataIS.close();
        return b;
    }

    private static TableB readNcepTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        dataIS.readLine();
        boolean count = false;
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.length() == 0) continue;
            try {
                String[] flds = line.split("[\\|;]");
                if (flds[0].equals("END")) break;
                if (flds.length < 8) {
                    log.error("Bad line in table " + b.getName() + " entry=<" + line + ">");
                    continue;
                }
                String fxys = flds[0];
                int scale = Integer.parseInt(BufrTables.clean(flds[1]));
                int refVal = Integer.parseInt(BufrTables.clean(flds[2]));
                int width = Integer.parseInt(BufrTables.clean(flds[3]));
                String units = StringUtil2.remove((String)flds[4], (int)34);
                String name = StringUtil2.remove((String)flds[5], (int)34);
                String desc = StringUtil2.remove((String)flds[7], (int)34);
                String[] xyflds = fxys.split("-");
                short x = Short.parseShort(BufrTables.clean(xyflds[1]));
                short y = Short.parseShort(BufrTables.clean(xyflds[2]));
                b.addDescriptor(x, y, scale, refVal, width, name, units, desc);
            }
            catch (Exception e) {
                log.error("Bad table " + b.getName() + " entry=<" + line + ">", (Throwable)e);
            }
        }
        dataIS.close();
        return b;
    }

    private static void readOperaTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, Charset.forName("UTF8")));
        int count = 0;
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#")) continue;
            ++count;
            String[] flds = line.split(";");
            if (flds.length < 8) {
                System.out.printf("%d BAD split == %s%n", count, line);
                continue;
            }
            int fldidx = 0;
            try {
                int classId = Integer.parseInt(flds[fldidx++].trim());
                int x = Integer.parseInt(flds[fldidx++].trim());
                int y = Integer.parseInt(flds[fldidx++].trim());
                String name = StringUtil2.remove((String)flds[fldidx++], (int)34);
                String units = StringUtil2.filter((String)flds[fldidx++], (String)" %+-_/()*");
                int scale = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int refVal = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int width = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                b.addDescriptor((short)x, (short)y, scale, refVal, width, name, units, null);
            }
            catch (Exception e) {
                System.out.printf("%d %d BAD line == %s%n", count, fldidx, line);
            }
        }
        dataIS.close();
    }

    private static TableB readEcmwfTableB(InputStream ios, TableB b) throws IOException {
        boolean count = false;
        List recs = TableParser.readTable((InputStream)ios, (String)"4i,7i,72,97,102i,114i,119i", (int)50000);
        for (TableParser.Record record : recs) {
            if (record.nfields() < 7) continue;
            int x = (Integer)record.get(0);
            int y = (Integer)record.get(1);
            String name = (String)record.get(2);
            String units = (String)record.get(3);
            int scale = (Integer)record.get(4);
            int ref = (Integer)record.get(5);
            int width = (Integer)record.get(6);
            b.addDescriptor((short)x, (short)y, scale, ref, width, name, units, null);
        }
        ios.close();
        return b;
    }

    private static void readBmetTableB(InputStream ios, TableB b) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(ios);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element root = doc.getRootElement();
        List featList = root.getChildren("featureCatalogue");
        for (Element featureCat : featList) {
            List features = featureCat.getChildren("feature");
            for (Element feature : features) {
                String name = feature.getChild("annotation").getChildTextNormalize("documentation");
                int f = Integer.parseInt(feature.getChildText("F"));
                int x = Integer.parseInt(feature.getChildText("X"));
                int y = Integer.parseInt(feature.getChildText("Y"));
                int fxy = (f << 16) + (x << 8) + y;
                Element bufrElem = feature.getChild("BUFR");
                String units = bufrElem.getChildTextNormalize("BUFR_units");
                int scale = 0;
                int reference = 0;
                int width = 0;
                String s = null;
                try {
                    s = bufrElem.getChildTextNormalize("BUFR_scale");
                    scale = Integer.parseInt(BufrTables.clean(s));
                }
                catch (NumberFormatException e) {
                    System.out.printf(" key %s name '%s' has bad scale='%s'%n", fxy, name, s);
                }
                try {
                    s = bufrElem.getChildTextNormalize("BUFR_reference");
                    reference = Integer.parseInt(BufrTables.clean(s));
                }
                catch (NumberFormatException e) {
                    System.out.printf(" key %s name '%s' has bad reference='%s' %n", fxy, name, s);
                }
                try {
                    s = bufrElem.getChildTextNormalize("BUFR_width");
                    width = Integer.parseInt(BufrTables.clean(s));
                }
                catch (NumberFormatException e) {
                    System.out.printf(" key %s name '%s' has bad width='%s' %n", fxy, name, s);
                }
                b.addDescriptor((short)x, (short)y, scale, reference, width, name, units, null);
            }
        }
        ios.close();
    }

    public static TableD getWmoTableDlatest() {
        if (latestWmoD == null) {
            try {
                latestWmoD = BufrTables.getWmoTableD(16);
            }
            catch (IOException ioe) {
                log.error("Cant open latest WMO ", (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
        }
        return latestWmoD;
    }

    public static TableD getWmoTableD(BufrIdentificationSection ids) throws IOException {
        return BufrTables.getWmoTableD(ids.getMasterTableVersion());
    }

    public static TableD getWmoTableD(int version) throws IOException {
        TableConfig tc = BufrTables.matchTableConfig(0, 0, version, 0, -1);
        if (tc != null) {
            return BufrTables.readTableD(tc.tableDname, tc.tableDformat, false);
        }
        return null;
    }

    public static TableD readTableD(String location, Format format, boolean force) throws IOException {
        TableD tb;
        if (location == null) {
            return null;
        }
        if (location.trim().length() == 0) {
            return null;
        }
        if (!force && (tb = tablesD.get(location)) != null) {
            return tb;
        }
        InputStream ios = BufrTables.openStream(location);
        TableD d = new TableD(location, location);
        switch (format) {
            case cypher: {
                BufrTables.readCypherTableD(ios, d);
                break;
            }
            case embed: {
                ios.close();
                d = BufrTables.readEmbeddedTableD(location);
                break;
            }
            case ncep: {
                BufrTables.readNcepTableD(ios, d);
                break;
            }
            case ncep_nm: {
                Tables t = new Tables(null, d, null);
                NcepMnemonic.read(ios, t);
                break;
            }
            case ecmwf: {
                BufrTables.readEcmwfTableD(ios, d);
                break;
            }
            case mel_bufr: {
                BufrTables.readMelbufrTableD(ios, d);
                break;
            }
            case opera: {
                BufrTables.readOperaTableD(ios, d);
                break;
            }
            case wmo_csv: {
                BufrTables.readWmoCsvTableD(ios, d);
                break;
            }
            case wmo_xml: {
                WmoXmlReader.readWmoXmlTableD(ios, d);
                break;
            }
            default: {
                System.out.printf("Unknown format= %s %n", new Object[]{format});
                return null;
            }
        }
        if (d != null) {
            tablesD.put(location, d);
        }
        return d;
    }

    private static void readCypherTableD(InputStream ios, TableD t) throws IOException {
        String line;
        TableD.Descriptor currDesc = null;
        boolean startMode = false;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null) {
            String[] flds;
            if (line.length() == 0 || line.startsWith("<")) continue;
            if (line.startsWith("#")) {
                startMode = true;
                continue;
            }
            if (startMode) {
                try {
                    flds = StringUtil2.splitString((String)line);
                    int fxy = Integer.parseInt(flds[0]);
                    int y = fxy % 1000;
                    int x = (fxy /= 1000) % 100;
                    int f1 = fxy / 100;
                    if (f1 != 3) {
                        log.error("Bad table " + t.getName() + " entry=<" + line + ">");
                    } else {
                        currDesc = t.addDescriptor((short)x, (short)y, "", new ArrayList<Short>());
                    }
                    startMode = false;
                    continue;
                }
                catch (Exception e) {
                    log.warn("Bad table " + t.getName() + " line=<" + line + ">", (Object)e.getMessage());
                }
            }
            try {
                flds = StringUtil2.splitString((String)line);
                String fxys = BufrTables.cleanNumber(flds[0]);
                int fxy = Integer.parseInt(fxys);
                int y1 = fxy % 1000;
                int x1 = (fxy /= 1000) % 100;
                int f1 = fxy / 100;
                int fxy1 = (f1 << 14) + (x1 << 8) + y1;
                currDesc.addFeature((short)fxy1);
            }
            catch (Exception e) {
                log.warn("Bad table " + t.getName() + " line=<" + line + ">", (Object)e.getMessage());
            }
        }
        dataIS.close();
    }

    static String cleanNumber(String s) {
        int pos = s.indexOf("(");
        if (pos > 0) {
            return s.substring(0, pos);
        }
        return s;
    }

    private static void readOperaTableD(InputStream ios, TableD t) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        TableD.Descriptor currDesc = null;
        String name = null;
        while ((line = dataIS.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (line.startsWith("#")) {
                name = line.substring(2).trim();
                continue;
            }
            try {
                String[] flds = line.split(";");
                if (flds[0].trim().length() != 0) {
                    int f = Integer.parseInt(flds[0].trim());
                    int x = Integer.parseInt(flds[1].trim());
                    int y = Integer.parseInt(flds[2].trim());
                    currDesc = t.addDescriptor((short)x, (short)y, name, new ArrayList<Short>());
                }
                int f1 = Integer.parseInt(flds[3].trim());
                int x1 = Integer.parseInt(flds[4].trim());
                int y1 = Integer.parseInt(flds[5].trim());
                int fxy = (f1 << 14) + (x1 << 8) + y1;
                currDesc.addFeature((short)fxy);
            }
            catch (Exception e) {
                log.error("Bad table " + t.getName() + " entry=<" + line + ">", (Throwable)e);
            }
        }
        dataIS.close();
    }

    private static void readWmoCsvTableD(InputStream ios, TableD tableD) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, Charset.forName("UTF-8")));
        int count = 0;
        int currSeqno = -1;
        TableD.Descriptor currDesc = null;
        while ((line = dataIS.readLine()) != null) {
            String[] flds;
            if (line.startsWith("#") || ++count == 1) continue;
            int pos1 = line.indexOf(34);
            if (pos1 >= 0) {
                int pos2 = line.indexOf(34, pos1 + 1);
                StringBuffer sb = new StringBuffer(line);
                for (int i = pos1; i < pos2; ++i) {
                    if (sb.charAt(i) != ',') continue;
                    sb.setCharAt(i, ' ');
                }
                line = sb.toString();
            }
            if ((flds = line.split(",")).length < 5) {
                System.out.printf("%d INCOMPLETE line == %s%n", count, line);
                continue;
            }
            int fldidx = 0;
            try {
                String featName;
                int sno = Integer.parseInt(flds[fldidx++]);
                int cat = Integer.parseInt(flds[fldidx++]);
                int seq = Integer.parseInt(flds[fldidx++]);
                String seqName = flds[fldidx++];
                String featno = flds[fldidx++].trim();
                if (featno.length() == 0) {
                    System.out.printf("%d no FXY2 specified; line == %s%n", count, line);
                    continue;
                }
                String string = featName = flds.length > 5 ? flds[fldidx++] : "n/a";
                if (currSeqno != seq) {
                    int y = seq % 1000;
                    int w = seq / 1000;
                    int x = w % 100;
                    seqName = StringUtil2.remove((String)seqName, (int)34);
                    currDesc = tableD.addDescriptor((short)x, (short)y, seqName, new ArrayList<Short>());
                    currSeqno = seq;
                }
                int fno = Integer.parseInt(featno);
                int y = fno % 1000;
                int w = fno / 1000;
                int x = w % 100;
                int f = w / 100;
                int fxy = (f << 14) + (x << 8) + y;
                currDesc.addFeature((short)fxy);
            }
            catch (Exception e) {
                System.out.printf("%d %d BAD line == %s : %s%n", count, fldidx, line, e.getMessage());
            }
        }
        dataIS.close();
    }

    private static void readMelbufrTableD(InputStream ios, TableD t) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        int count = 0;
        while ((line = dataIS.readLine()) != null) {
            String[] split;
            ++count;
            if (line.startsWith("#") || line.length() == 0 || (split = (line = line.trim()).split("[ \t]+")).length < 3) continue;
            if (split[0].equals("END")) break;
            try {
                short seqF = Short.parseShort(split[0]);
                short seqX = Short.parseShort(split[1]);
                short seqY = Short.parseShort(split[2]);
                assert (seqF == 3);
                String seqName = "";
                if (split.length > 3) {
                    StringBuilder sb = new StringBuilder(40);
                    for (int i = 3; i < split.length; ++i) {
                        sb.append(split[i]).append(" ");
                    }
                    seqName = sb.toString();
                    seqName = StringUtil2.remove((String)seqName, (String)"()");
                }
                ArrayList<Short> seq = new ArrayList<Short>();
                while ((line = dataIS.readLine()) != null) {
                    ++count;
                    if (line.startsWith("#") || line.length() == 0) continue;
                    Matcher m = threeInts.matcher(line);
                    if (m.find()) {
                        short f = Short.parseShort(m.group(1));
                        short x = Short.parseShort(m.group(2));
                        short y = Short.parseShort(m.group(3));
                        seq.add(Descriptor.getFxy(f, x, y));
                        continue;
                    }
                    m = negOne.matcher(line);
                    if (!m.find()) continue;
                    t.addDescriptor(seqX, seqY, seqName, seq);
                }
            }
            catch (Exception e) {
                log.warn("TableD " + t.getName() + " Failed on line " + count + " = " + line + "\n " + e);
            }
        }
        dataIS.close();
    }

    private static void readNcepTableD(InputStream ios, TableD t) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        dataIS.readLine();
        TableD.Descriptor currDesc = null;
        boolean count = false;
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            try {
                String[] xyflds;
                String[] flds = line.split("[\\|;]");
                if (flds[0].equals("END")) break;
                String fxys = flds[0].trim();
                if (fxys.length() > 0) {
                    xyflds = fxys.split("-");
                    short x = Short.parseShort(BufrTables.clean(xyflds[1]));
                    short y = Short.parseShort(BufrTables.clean(xyflds[2]));
                    String seqName = flds.length > 3 ? flds[3].trim() : "";
                    currDesc = t.addDescriptor(x, y, seqName, new ArrayList<Short>());
                    continue;
                }
                fxys = StringUtil2.remove((String)flds[1], (int)62);
                xyflds = fxys.split("-");
                short f = Short.parseShort(BufrTables.clean(xyflds[0]));
                short x = Short.parseShort(BufrTables.clean(xyflds[1]));
                short y = Short.parseShort(BufrTables.clean(xyflds[2]));
                int fxy = (f << 14) + (x << 8) + y;
                currDesc.addFeature((short)fxy);
            }
            catch (Exception e) {
                log.error("Bad table " + t.getName() + " entry=<" + line + ">", (Throwable)e);
            }
        }
        dataIS.close();
    }

    private static void readEcmwfTableD(InputStream ios, TableD t) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        TableD.Descriptor currDesc = null;
        int n = 0;
        while ((line = dataIS.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            try {
                int x;
                int y;
                int fxy;
                String fxys;
                String[] flds = line.split("[\\s]+");
                if (n == 0) {
                    fxys = flds[0].trim();
                    fxy = Integer.parseInt(fxys);
                    y = fxy % 1000;
                    x = (fxy /= 1000) % 100;
                    currDesc = t.addDescriptor((short)x, (short)y, "", new ArrayList<Short>());
                    n = Integer.parseInt(flds[1]);
                    fxys = flds[2].trim();
                } else {
                    fxys = flds[0].trim();
                }
                fxy = Integer.parseInt(fxys);
                y = fxy % 1000;
                x = (fxy /= 1000) % 100;
                int f = fxy /= 100;
                fxy = (f << 14) + (x << 8) + y;
                currDesc.addFeature((short)fxy);
                --n;
            }
            catch (Exception e) {
                log.error("Bad table " + t.getName() + " entry=<" + line + ">", (Throwable)e);
            }
        }
        dataIS.close();
    }

    private static InputStream open(String location) throws IOException {
        InputStream ios = null;
        String tmp = "/resources/bufrTables/local/" + location;
        ios = BufrTables.class.getResourceAsStream(tmp);
        if (ios != null) {
            return ios;
        }
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return ios;
    }

    static InputStream openStream(String location) throws IOException {
        InputStream ios = null;
        if (location.startsWith("resource:")) {
            ios = BufrTables.class.getResourceAsStream(location = location.substring(9));
            if (ios == null) {
                throw new RuntimeException("resource not found=<" + location + ">");
            }
            return ios;
        }
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return ios;
    }

    public static void main(String[] args) throws IOException {
        String location = "resource:/resources/bufrTables/local/opera/localtabd_65535_5.csv";
        InputStream ios = BufrTables.openStream(location);
        TableD d = new TableD(location, location);
        BufrTables.readOperaTableD(ios, d);
    }

    static {
        tablesB = new ConcurrentHashMap<String, TableB>();
        tablesD = new ConcurrentHashMap<String, TableD>();
        lookups = null;
        threeInts = Pattern.compile("^\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)");
        negOne = Pattern.compile("^\\s*-1");
    }

    public static class Tables {
        public TableB b;
        public TableD d;
        public Mode mode;

        Tables() {
        }

        Tables(TableB b, TableD d, Mode mode) {
            this.b = b;
            this.d = d;
            this.mode = mode == null ? Mode.wmoOnly : mode;
        }
    }

    public static class TableConfig {
        String name;
        int center;
        int subcenter;
        int master;
        int local;
        int cat;
        String tableBname;
        String tableDname;
        Format tableBformat;
        Format tableDformat;
        Mode mode = Mode.localOverride;

        boolean matches(int center, int subcenter, int master, int local, int cat) {
            if (this.center >= 0 && center >= 0 && center != this.center) {
                return false;
            }
            if (this.subcenter >= 0 && subcenter >= 0 && subcenter != this.subcenter) {
                return false;
            }
            if (this.master >= 0 && master >= 0 && master != this.master) {
                return false;
            }
            if (this.local >= 0 && local >= 0 && local != this.local) {
                return false;
            }
            return this.cat < 0 || cat < 0 || cat == this.cat;
        }

        public String getName() {
            return this.name;
        }

        public Format getTableBformat() {
            return this.tableBformat;
        }

        public Format getTableDformat() {
            return this.tableDformat;
        }

        public Mode getMode() {
            return this.mode;
        }

        public String getTableDname() {
            return this.tableDname;
        }

        public String getTableBname() {
            return this.tableBname;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Format {
        ecmwf,
        mel_bufr,
        mel_tabs,
        ncep,
        ncep_nm,
        opera,
        ukmet,
        wmo_csv,
        wmo_xml,
        cypher,
        embed;

    }

    public static enum Mode {
        wmoOnly,
        wmoLocal,
        localOverride;

    }
}

