/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.nc2.iosp.bufr.BitCounterCompressed;
import ucar.nc2.iosp.bufr.BitCounterUncompressed;
import ucar.nc2.iosp.bufr.BufrDataDescriptionSection;
import ucar.nc2.iosp.bufr.BufrDataSection;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.BufrIndicatorSection;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.DataDescriptorTreeConstructor;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.iosp.bufr.tables.TableA;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;

public class Message {
    private static final Pattern wmoPattern = Pattern.compile(".*([IJ]..... ....) .*");
    public BufrIndicatorSection is;
    public BufrIdentificationSection ids;
    public BufrDataDescriptionSection dds;
    public BufrDataSection dataSection;
    private RandomAccessFile raf;
    private TableLookup lookup;
    private DataDescriptor root;
    private String header;
    private long startPos;
    private byte[] raw;
    BitCounterUncompressed[] counterDatasets;
    BitCounterCompressed[] counterFlds;
    int msg_nbits;

    public Message(RandomAccessFile raf, BufrIndicatorSection is, BufrIdentificationSection ids, BufrDataDescriptionSection dds, BufrDataSection dataSection) throws IOException {
        this.raf = raf;
        this.is = is;
        this.ids = ids;
        this.dds = dds;
        this.dataSection = dataSection;
        this.lookup = new TableLookup(ids);
    }

    public void setTableLookup(TableLookup lookup) {
        this.lookup = lookup;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public int getNumberDatasets() {
        return this.dds.getNumberDatasets();
    }

    public String getCategoryName() {
        return TableA.getDataCategory(this.ids.getCategory());
    }

    public String getCategoryNo() {
        String result = this.ids.getCategory() + "." + this.ids.getSubCategory();
        if (this.ids.getLocalSubCategory() >= 0) {
            result = result + "." + this.ids.getLocalSubCategory();
        }
        return result;
    }

    public String getCenterName() {
        String name = CommonCodeTable.getCenterNameBufr((int)this.ids.getCenterId(), (int)this.is.getBufrEdition());
        String subname = CommonCodeTable.getSubCenterName((int)this.ids.getCenterId(), (int)this.ids.getSubCenterId());
        if (subname != null) {
            name = name + " / " + subname;
        }
        return this.ids.getCenterId() + "." + this.ids.getSubCenterId() + " (" + name + ")";
    }

    public String getCenterNo() {
        return this.ids.getCenterId() + "." + this.ids.getSubCenterId();
    }

    public String getTableName() {
        return this.ids.getMasterTableId() + "." + this.ids.getMasterTableVersion() + "." + this.ids.getLocalTableVersion();
    }

    public CalendarDate getReferenceTime() {
        return this.ids.getReferenceTime();
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void setStartPos(long startPos) {
        this.startPos = startPos;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public void setRawBytes(byte[] raw) {
        this.raw = raw;
    }

    public byte[] getRawBytes() {
        return this.raw;
    }

    public String extractWMO() {
        Matcher matcher = wmoPattern.matcher(this.header);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(1);
    }

    public long getMessageSize() {
        return this.is.getBufrLength();
    }

    public DataDescriptor getRootDataDescriptor() throws IOException {
        if (this.root == null) {
            this.root = new DataDescriptorTreeConstructor().factory(this.lookup, this.dds);
        }
        return this.root;
    }

    public boolean usesLocalTable() throws IOException {
        DataDescriptor root = this.getRootDataDescriptor();
        return this.usesLocalTable(root);
    }

    private boolean usesLocalTable(DataDescriptor dds) throws IOException {
        for (DataDescriptor key : dds.getSubKeys()) {
            if (key.isLocal()) {
                return true;
            }
            if (key.getSubKeys() == null || !this.usesLocalTable(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsBufrTable() throws IOException {
        for (Short key : this.dds.getDataDescriptors()) {
            if (!Descriptor.isBufrTable(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isTablesComplete() throws IOException {
        DataDescriptor root = this.getRootDataDescriptor();
        return !root.isBad;
    }

    public void showMissingFields(Formatter out) throws IOException {
        this.showMissingFields(this.dds.getDataDescriptors(), out);
    }

    private void showMissingFields(List<Short> ddsList, Formatter out) throws IOException {
        for (short fxy : ddsList) {
            TableB.Descriptor b;
            int f = (fxy & 0xC000) >> 14;
            if (f == 3) {
                List<Short> sublist = this.lookup.getDescriptorsTableD(fxy);
                if (sublist == null) {
                    out.format("%s, ", Descriptor.makeString(fxy));
                    continue;
                }
                this.showMissingFields(sublist, out);
                continue;
            }
            if (f != 0 || (b = this.lookup.getDescriptorTableB(fxy)) != null) continue;
            out.format("%s, ", Descriptor.makeString(fxy));
        }
    }

    public TableLookup getTableLookup() {
        return this.lookup;
    }

    public boolean isBitCountOk() throws IOException {
        this.getRootDataDescriptor();
        this.getTotalBits();
        int nbytesCounted = this.getCountedDataBytes();
        int nbytesGiven = this.dataSection.getDataLength();
        return Math.abs(nbytesCounted - nbytesGiven) <= 1;
    }

    public int getCountedDataBytes() {
        int msg_nbytes = this.msg_nbits / 8;
        if (this.msg_nbits % 8 != 0) {
            ++msg_nbytes;
        }
        if ((msg_nbytes += 4) % 2 != 0) {
            ++msg_nbytes;
        }
        return msg_nbytes;
    }

    public int getCountedDataBits() {
        return this.msg_nbits;
    }

    public BitCounterUncompressed getBitCounterUncompressed(int obsOffsetInMessage) {
        if (this.dds.isCompressed()) {
            throw new IllegalArgumentException("cant call BufrMessage.getBitOffset() on compressed message");
        }
        this.calcTotalBits(null);
        return this.counterDatasets[obsOffsetInMessage];
    }

    public int getTotalBits() {
        if (this.msg_nbits == 0) {
            this.calcTotalBits(null);
        }
        return this.msg_nbits;
    }

    public int calcTotalBits(Formatter out) {
        try {
            if (!this.dds.isCompressed()) {
                MessageUncompressedDataReader reader = new MessageUncompressedDataReader();
                reader.readData(null, this, this.raf, null, false, out);
            } else {
                MessageCompressedDataReader reader = new MessageCompressedDataReader();
                reader.readData(null, this, this.raf, null, out);
            }
        }
        catch (IOException ioe) {
            return 0;
        }
        return this.msg_nbits;
    }

    public int hashCode() {
        int result = 17;
        result += 37 * result + this.dds.getDataDescriptors().hashCode();
        result += 37 * result + this.ids.getCenterId();
        result += 37 * result + this.ids.getCategory();
        result += 37 * result + this.ids.getSubCategory();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Message)) {
            return false;
        }
        Message o = (Message)obj;
        if (!this.dds.getDataDescriptors().equals(o.dds.getDataDescriptors())) {
            return false;
        }
        if (this.ids.getCenterId() != o.ids.getCenterId()) {
            return false;
        }
        if (this.ids.getCategory() != o.ids.getCategory()) {
            return false;
        }
        return this.ids.getSubCategory() == o.ids.getSubCategory();
    }

    public void dump(Formatter out) throws IOException {
        int listHash = this.dds.getDataDescriptors().hashCode();
        out.format(" BUFR edition %d time= %s wmoHeader=%s hash=[0x%x] listHash=[0x%x] (%d) %n", this.is.getBufrEdition(), this.getReferenceTime(), this.getHeader(), this.hashCode(), listHash, listHash);
        out.format("   Category= %s %n", this.getCategoryFullName());
        out.format("   Center= %s %n", this.getCenterName());
        out.format("   Table= %s %n", this.getTableName());
        out.format("    Table B= wmoTable= %s localTable= %s mode=%s%n", new Object[]{this.lookup.getWmoTableBName(), this.lookup.getLocalTableBName(), this.lookup.getMode()});
        out.format("    Table D= wmoTable= %s localTable= %s%n", this.lookup.getWmoTableDName(), this.lookup.getLocalTableDName());
        out.format("  DDS nsubsets=%d type=0x%x isObs=%b isCompressed=%b\n", this.dds.getNumberDatasets(), this.dds.getDataType(), this.dds.isObserved(), this.dds.isCompressed());
        long startPos = this.is.getStartPos();
        long startData = this.dataSection.getDataPos();
        out.format("  startPos=%d len=%d endPos=%d dataStart=%d dataLen=%d dataEnd=%d %n", startPos, this.is.getBufrLength(), startPos + (long)this.is.getBufrLength(), startData, this.dataSection.getDataLength(), startData + (long)this.dataSection.getDataLength());
        this.dumpDesc(out, this.dds.getDataDescriptors(), this.lookup, 4);
        out.format("%n  CDM Nested Table=\n", new Object[0]);
        DataDescriptor root = new DataDescriptorTreeConstructor().factory(this.lookup, this.dds);
        this.dumpKeys(out, root, 4);
    }

    private void dumpDesc(Formatter out, List<Short> desc, TableLookup table, int indent) {
        if (desc == null) {
            return;
        }
        for (Short fxy : desc) {
            for (int i = 0; i < indent; ++i) {
                out.format(" ", new Object[0]);
            }
            Descriptor.show(out, fxy, table);
            out.format("%n", new Object[0]);
            int f = (fxy & 0xC000) >> 14;
            if (f != 3) continue;
            List<Short> sublist = table.getDescriptorsTableD(fxy);
            this.dumpDesc(out, sublist, table, indent + 2);
        }
    }

    private void dumpKeys(Formatter out, DataDescriptor tree, int indent) {
        for (DataDescriptor key : tree.subKeys) {
            for (int i = 0; i < indent; ++i) {
                out.format(" ", new Object[0]);
            }
            out.format("%s\n", key);
            if (key.getSubKeys() == null) continue;
            this.dumpKeys(out, key, indent + 2);
        }
    }

    public String getCategoryFullName() throws IOException {
        String catName = this.getCategoryName();
        String subcatName = CommonCodeTable.getDataSubcategoy((int)this.ids.getCategory(), (int)this.ids.getSubCategory());
        if (subcatName != null) {
            return this.getCategoryNo() + "=" + catName + " / " + subcatName;
        }
        return this.getCategoryNo() + "=" + catName;
    }

    public void dumpHeader(Formatter out) {
        out.format(" BUFR edition %d time= %s wmoHeader=%s %n", this.is.getBufrEdition(), this.getReferenceTime(), this.getHeader());
        out.format("   Category= %d %s %s %n", this.ids.getCategory(), this.getCategoryName(), this.getCategoryNo());
        out.format("   Center= %s %s %n", this.getCenterName(), this.getCenterNo());
        out.format("   Table= %d.%d local= %d wmoTables= %s,%s localTables= %s,%s %n", this.ids.getMasterTableId(), this.ids.getMasterTableVersion(), this.ids.getLocalTableVersion(), this.lookup.getWmoTableBName(), this.lookup.getWmoTableDName(), this.lookup.getLocalTableBName(), this.lookup.getLocalTableDName());
        out.format("  DDS nsubsets=%d type=0x%x isObs=%b isCompressed=%b\n", this.dds.getNumberDatasets(), this.dds.getDataType(), this.dds.isObserved(), this.dds.isCompressed());
    }

    public void dumpHeaderShort(Formatter out) {
        out.format(" %s, Cat= %s, Center= %s (%s), Table= %d.%d.%d %n", this.getHeader(), this.getCategoryName(), this.getCenterName(), this.getCenterNo(), this.ids.getMasterTableId(), this.ids.getMasterTableVersion(), this.ids.getLocalTableVersion());
    }
}

