/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.bufr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureDataProxy;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.PointIteratorFromStructureData;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft.point.bufr.BufrCdmIndex;
import ucar.nc2.ft.point.bufr.BufrCdmIndexProto;
import ucar.nc2.ft.point.bufr.StandardFields;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.bufr.BufrIosp2;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;

public class BufrFeatureDatasetFactory
implements FeatureDatasetFactory {
    private static Logger log = LoggerFactory.getLogger(BufrFeatureDatasetFactory.class);
    private static DateUnit bufrDateUnits = DateUnit.factory((String)"msecs since 1970-01-01T00:00:00");
    private static String bufrAltUnits = "m";

    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ncd, Formatter errlog) throws IOException {
        IOServiceProvider iosp = ncd.getIosp();
        return iosp != null && iosp instanceof BufrIosp2 ? Boolean.valueOf(true) : null;
    }

    public FeatureType[] getFeatureType() {
        return new FeatureType[]{FeatureType.ANY_POINT};
    }

    public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) throws IOException {
        File indexFile = BufrCdmIndex.calcIndexFile(ncd.getLocation());
        if (indexFile == null) {
            return null;
        }
        BufrCdmIndex index = BufrCdmIndex.readIndex(indexFile.getPath());
        return new BufrStationDataset(ncd, index);
    }

    private void show(Element parent, Indent indent) {
        if (parent == null) {
            return;
        }
        for (Element child : parent.getChildren("fld", NcMLReader.ncNS)) {
            String idx = child.getAttributeValue("idx");
            String fxy = child.getAttributeValue("fxy");
            String name = child.getAttributeValue("name");
            String action = child.getAttributeValue("action");
            System.out.printf("%sidx='%s' fxy='%s' name='%s' action='%s'%n", indent, idx, fxy, name, action);
            indent.incr();
            this.show(child, indent);
            indent.decr();
        }
    }

    private void processSeq(Structure struct, Element parent) throws IOException {
        if (parent == null || struct == null) {
            return;
        }
        List vars = struct.getVariables();
        for (Element child : parent.getChildren("fld", NcMLReader.ncNS)) {
            String idxS = child.getAttributeValue("idx");
            int idx = Integer.parseInt(idxS);
            if (idx < 0 || idx >= vars.size()) {
                log.error("Bad index = %s", (Object)child);
                continue;
            }
            Variable want = (Variable)vars.get(idx);
            struct.removeMemberVariable(want);
            System.out.printf("removed %s%n", want);
        }
    }

    private class Munge {
        String sdataName;
        boolean needed;
        protected Map<String, Action> actions = new HashMap<String, Action>(32);
        protected Map<String, StructureData> missingData = new HashMap<String, StructureData>(32);
        protected Map<String, VariableDS> vars = new HashMap<String, VariableDS>(32);

        private Munge() {
        }

        List<VariableSimpleIF> makeDataVariables(BufrCdmIndex index, Structure obs) {
            this.sdataName = obs.getShortName() + "Munged";
            List members = obs.getVariables();
            ArrayList<VariableSimpleIF> result = new ArrayList<VariableSimpleIF>(members.size());
            List<BufrCdmIndexProto.Field> flds = index.root.getFldsList();
            int count = 0;
            for (Variable v : members) {
                BufrCdmIndexProto.Field fld;
                if ((fld = flds.get(count++)).getAction() != null && fld.getAction() != BufrCdmIndexProto.FldAction.none) {
                    this.needed = true;
                    Action act = new Action(fld.getAction());
                    this.actions.put(v.getShortName(), act);
                    if (fld.getAction() == BufrCdmIndexProto.FldAction.remove) continue;
                    if (fld.getAction() == BufrCdmIndexProto.FldAction.asMissing) {
                        Structure s = (Structure)v;
                        for (Variable child : s.getVariables()) {
                            result.add((VariableSimpleIF)child);
                            this.vars.put(child.getShortName(), (VariableDS)child);
                        }
                        continue;
                    }
                }
                if (v.getDataType() == DataType.SEQUENCE) continue;
                result.add((VariableSimpleIF)v);
            }
            return result;
        }

        StructureData munge(StructureData org) throws IOException {
            return this.needed ? new StructureDataMunged2(org) : org;
        }

        StructureData makeMissing(StructureMembers.Member seqm, ArraySequence seq) {
            StructureData result = this.missingData.get(seqm.getName());
            if (result != null) {
                return result;
            }
            StructureMembers sm = new StructureMembers(seq.getStructureMembers());
            StructureDataW resultW = new StructureDataW(sm);
            for (StructureMembers.Member m : sm.getMembers()) {
                VariableDS var = this.vars.get(m.getName());
                Array missingData = var.getMissingDataArray(m.getShape());
                resultW.setMemberData(m, missingData);
            }
            this.missingData.put(seqm.getName(), (StructureData)resultW);
            return resultW;
        }

        class StructureDataMunged2
        extends StructureDataComposite {
            StructureDataMunged2(StructureData sdata) throws IOException {
                this.add(sdata);
                for (StructureMembers.Member m : sdata.getMembers()) {
                    Action act = Munge.this.actions.get(m.getName());
                    if (act == null) continue;
                    if (act.what == BufrCdmIndexProto.FldAction.remove) {
                        this.members.hideMember(m);
                        continue;
                    }
                    if (act.what != BufrCdmIndexProto.FldAction.asMissing) continue;
                    int pos = this.members.hideMember(m);
                    ArraySequence seq = sdata.getArraySequence(m);
                    StructureDataIterator iter = seq.getStructureDataIterator();
                    if (iter.hasNext()) {
                        this.add(pos, iter.next());
                        continue;
                    }
                    this.add(pos, Munge.this.makeMissing(m, seq));
                }
            }
        }

        class StructureDataMunged
        extends StructureDataProxy {
            StructureDataMunged(StructureData sdata) throws IOException {
                super(sdata);
                StructureMembers sm = new StructureMembers(Munge.this.sdataName);
                for (StructureMembers.Member m : sdata.getMembers()) {
                    Action act = Munge.this.actions.get(m.getName());
                    if (act == null) {
                        sm.addMember(m);
                        continue;
                    }
                    if (act.what == BufrCdmIndexProto.FldAction.remove) continue;
                    if (act.what == BufrCdmIndexProto.FldAction.asMissing) {
                        ArraySequence seq = sdata.getArraySequence(m);
                        StructureDataIterator iter = seq.getStructureDataIterator();
                        if (!iter.hasNext()) {
                            for (StructureMembers.Member childMember : seq.getMembers()) {
                                sm.addMember(childMember);
                            }
                            continue;
                        }
                        StructureData childStruct = iter.next();
                        for (StructureMembers.Member childMember : childStruct.getMembers()) {
                            sm.addMember(childMember);
                        }
                        continue;
                    }
                    sm.addMember(m);
                }
                this.members = sm;
            }
        }
    }

    private class Action {
        BufrCdmIndexProto.FldAction what;

        private Action(BufrCdmIndexProto.FldAction what) {
            this.what = what;
        }
    }

    private class BufrStationDataset
    extends PointDatasetImpl {
        private Munge munger;
        private BufrCdmIndex index;
        private SequenceDS obs;

        private BufrStationDataset(NetcdfDataset ncfile, BufrCdmIndex index) {
            super(ncfile, FeatureType.STATION);
            this.index = index;
            this.munger = new Munge();
            this.obs = (SequenceDS)ncfile.findVariable("obs");
            this.dataVariables = this.munger.makeDataVariables(index, (Structure)this.obs);
            BufrStationCollection bufrCollection = new BufrStationCollection(ncfile.getLocation());
            this.setPointFeatureCollection((FeatureCollection)bufrCollection);
            CalendarDateRange dateRange = CalendarDateRange.of((CalendarDate)CalendarDate.of((long)index.start), (CalendarDate)CalendarDate.of((long)index.end));
            this.setDateRange(dateRange);
        }

        public FeatureType getFeatureType() {
            return FeatureType.STATION;
        }

        public void getDetailInfo(Formatter sf) {
            super.getDetailInfo(sf);
            this.index.showIndex(sf);
        }

        private class BufrStationCollection
        extends StationTimeSeriesCollectionImpl {
            StandardFields.StandardFieldsFromStructure extract;

            private BufrStationCollection(String name) {
                super(name, null, null);
                Attribute centerAtt = BufrStationDataset.this.ncfile.findGlobalAttribute("BUFR:centerId");
                int center = centerAtt == null ? 0 : centerAtt.getNumericValue().intValue();
                this.extract = new StandardFields.StandardFieldsFromStructure(center, (Structure)BufrStationDataset.this.obs);
                try {
                    this.timeUnit = new DateUnit("msecs since 1970-01-01T00:00:00");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.altUnits = "m";
            }

            protected StationHelper initStationHelper() {
                if (this.stationHelper == null) {
                    this.stationHelper = new StationHelper();
                    for (BufrCdmIndexProto.Station s : ((BufrStationDataset)BufrStationDataset.this).index.stations) {
                        this.stationHelper.addStation((StationFeature)new BufrStation(s));
                    }
                }
                return this.stationHelper;
            }

            public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
                return new BufrPointFeatureCollection(boundingBox, dateRange);
            }

            private class BufrPointFeatureCollection
            extends PointCollectionImpl {
                StationHelper stationsWanted;
                PointFeatureIterator.Filter filter;

                BufrPointFeatureCollection(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
                    super("BufrPointFeatureCollection", bufrDateUnits, bufrAltUnits);
                    this.setBoundingBox(boundingBox);
                    this.setCalendarDateRange(dateRange);
                    BufrStationCollection.this.initStationHelper();
                    this.stationsWanted = BufrStationCollection.this.stationHelper.subset(boundingBox);
                    if (dateRange != null) {
                        this.filter = new PointIteratorAbstract.Filter(null, dateRange);
                    }
                }

                public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
                    return new BufrRecordIterator(BufrStationDataset.this.obs.getStructureIterator(), this.filter);
                }

                public class BufrPoint
                extends PointFeatureImpl
                implements StationPointFeature {
                    StructureData sdata;

                    public BufrPoint(StationFeature want, double obsTime, double nomTime, StructureData sdata) {
                        super((EarthLocation)want, obsTime, nomTime, bufrDateUnits);
                        this.sdata = sdata;
                    }

                    public StructureData getDataAll() throws IOException {
                        return this.sdata;
                    }

                    public StructureData getFeatureData() throws IOException {
                        return this.sdata;
                    }

                    public StationFeature getStation() {
                        return (StationFeature)this.location;
                    }
                }

                public class BufrRecordIterator
                extends PointIteratorFromStructureData {
                    int countHere;

                    public BufrRecordIterator(StructureDataIterator structIter, PointFeatureIterator.Filter filter) throws IOException {
                        super(structIter, filter);
                        this.countHere = 0;
                    }

                    protected PointFeature makeFeature(int recnum, StructureData sdata) throws IOException {
                        BufrStationCollection.this.extract.extract(sdata);
                        String stationId = BufrStationCollection.this.extract.getStationId();
                        StationFeature want = BufrPointFeatureCollection.this.stationsWanted.getStation(stationId);
                        if (want == null) {
                            return null;
                        }
                        CalendarDate date = BufrStationCollection.this.extract.makeCalendarDate();
                        ++this.countHere;
                        return new BufrPoint(want, date.getMillis(), 0.0, BufrStationDataset.this.munger.munge(sdata));
                    }

                    public void finish() {
                        System.out.printf("BufrRecordIterator passed %d features super claims %d%n", this.countHere, this.getCount());
                        super.finish();
                    }
                }
            }

            private class BufrStation
            extends StationTimeSeriesFeatureImpl {
                private BufrStation(BufrCdmIndexProto.Station proto) {
                    super(proto.getId(), proto.getDesc(), proto.getWmoId(), proto.getLat(), proto.getLon(), proto.getAlt(), bufrDateUnits, bufrAltUnits, proto.getCount());
                }

                public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
                    return new BufrStationIterator(BufrStationDataset.this.obs.getStructureIterator(), null);
                }

                public StructureData getFeatureData() throws IOException {
                    return StructureData.EMPTY;
                }

                public class BufrStationPoint
                extends PointFeatureImpl {
                    StructureData sdata;

                    public BufrStationPoint(EarthLocation location, double obsTime, double nomTime, StructureData sdata) {
                        super(location, obsTime, nomTime, bufrDateUnits);
                        this.sdata = sdata;
                    }

                    public StructureData getDataAll() throws IOException {
                        return this.sdata;
                    }

                    public StructureData getFeatureData() throws IOException {
                        return this.sdata;
                    }
                }

                public class BufrStationIterator
                extends PointIteratorFromStructureData {
                    int countRecords;

                    public BufrStationIterator(StructureDataIterator structIter, PointFeatureIterator.Filter filter) throws IOException {
                        super(structIter, filter);
                        this.countRecords = 0;
                    }

                    protected PointFeature makeFeature(int recnum, StructureData sdata) throws IOException {
                        BufrStationCollection.this.extract.extract(sdata);
                        String stationId = BufrStationCollection.this.extract.getStationId();
                        if (!stationId.equals(BufrStation.this.s.getName())) {
                            return null;
                        }
                        CalendarDate date = BufrStationCollection.this.extract.makeCalendarDate();
                        return new BufrStationPoint((EarthLocation)BufrStation.this.s, date.getMillis(), 0.0, BufrStationDataset.this.munger.munge(sdata));
                    }
                }
            }
        }
    }
}

