/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.netcdf3.N3iosp;

public class Write2ncRect {
    private static boolean debug = true;

    Write2ncRect(NetcdfFile bufr, String fileOutName, boolean fill) throws IOException, InvalidRangeException {
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)fileOutName, (boolean)fill);
        if (debug) {
            System.out.println("FileWriter write " + bufr.getLocation() + " to " + fileOutName);
        }
        List glist = bufr.getGlobalAttributes();
        for (Attribute att : glist) {
            String useName = N3iosp.makeValidNetcdfObjectName((String)att.getShortName());
            Attribute useAtt = att.isArray() ? ncfile.addGlobalAttribute(useName, att.getValues()) : (att.isString() ? ncfile.addGlobalAttribute(useName, att.getStringValue()) : ncfile.addGlobalAttribute(useName, att.getNumericValue()));
            if (!debug) continue;
            System.out.println("add gatt= " + useAtt);
        }
        Dimension recordDim = null;
        for (Dimension oldD : bufr.getDimensions()) {
            String useName = N3iosp.makeValidNetcdfObjectName((String)oldD.getShortName());
            boolean isRecord = useName.equals("record");
            Dimension newD = ncfile.addDimension(useName, oldD.getLength(), true, false, false);
            if (isRecord) {
                recordDim = newD;
            }
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        Structure recordStruct = (Structure)bufr.findVariable("obs");
        for (Variable oldVar : recordStruct.getVariables()) {
            if (oldVar.getDataType() == DataType.STRUCTURE) continue;
            String varName = N3iosp.makeValidNetcdfObjectName((String)oldVar.getShortName());
            DataType newType = oldVar.getDataType();
            ArrayList<Dimension> newDims = new ArrayList<Dimension>();
            newDims.add(recordDim);
            for (Dimension dim : oldVar.getDimensions()) {
                newDims.add(ncfile.addDimension(oldVar.getShortName() + "_strlen", dim.getLength()));
            }
            Variable newVar = ncfile.addVariable(varName, newType, newDims);
            if (debug) {
                System.out.println("add var= " + newVar);
            }
            List attList = oldVar.getAttributes();
            for (Attribute att : attList) {
                String useName = N3iosp.makeValidNetcdfObjectName((String)att.getShortName());
                if (att.isArray()) {
                    ncfile.addVariableAttribute(varName, useName, att.getValues());
                    continue;
                }
                if (att.isString()) {
                    ncfile.addVariableAttribute(varName, useName, att.getStringValue());
                    continue;
                }
                ncfile.addVariableAttribute(varName, useName, att.getNumericValue());
            }
        }
        for (Variable v : recordStruct.getVariables()) {
            if (v.getDataType() != DataType.STRUCTURE) continue;
            String structName = N3iosp.makeValidNetcdfObjectName((String)v.getShortName());
            int[] shape = v.getShape();
            Dimension structDim = ncfile.addDimension(structName, shape[0]);
            Structure struct = (Structure)v;
            for (Variable seqVar : struct.getVariables()) {
                String varName = N3iosp.makeValidNetcdfObjectName((String)(seqVar.getShortName() + "-" + structName));
                DataType newType = seqVar.getDataType();
                ArrayList<Dimension> newDims = new ArrayList<Dimension>();
                newDims.add(recordDim);
                newDims.add(structDim);
                for (Dimension dim : seqVar.getDimensions()) {
                    newDims.add(ncfile.addDimension(seqVar.getShortName() + "_strlen", dim.getLength()));
                }
                Variable newVar = ncfile.addVariable(varName, newType, newDims);
                if (debug) {
                    System.out.println("add var= " + newVar);
                }
                List attList = seqVar.getAttributes();
                for (Attribute att : attList) {
                    String useName = N3iosp.makeValidNetcdfObjectName((String)att.getShortName());
                    if (att.isArray()) {
                        ncfile.addVariableAttribute(varName, useName, att.getValues());
                        continue;
                    }
                    if (att.isString()) {
                        ncfile.addVariableAttribute(varName, useName, att.getStringValue());
                        continue;
                    }
                    ncfile.addVariableAttribute(varName, useName, att.getNumericValue());
                }
            }
        }
        ncfile.create();
        if (debug) {
            System.out.println("File Out= " + ncfile.toString());
        }
        double total = this.copyVarData(ncfile, recordStruct);
        ncfile.flush();
        System.out.println("FileWriter done total bytes = " + total);
        ncfile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double copyVarData(NetcdfFileWriteable ncfile, Structure recordStruct) throws IOException, InvalidRangeException {
        int nrecs = (int)recordStruct.getSize();
        int sdataSize = recordStruct.getElementSize();
        double total = 0.0;
        double totalRecordBytes = 0.0;
        for (int count = 0; count < nrecs; ++count) {
            StructureData recordData = recordStruct.readStructure(count);
            for (StructureMembers.Member m : recordData.getMembers()) {
                if (m.getDataType() == DataType.STRUCTURE) {
                    int countLevel = 0;
                    ArrayStructure seq1 = recordData.getArrayStructure(m);
                    StructureDataIterator iter = seq1.getStructureDataIterator();
                    try {
                        while (iter.hasNext()) {
                            StructureData seqData = iter.next();
                            for (StructureMembers.Member seqm : seqData.getMembers()) {
                                Array data = seqData.getArray(seqm);
                                int[] shape = data.getShape();
                                int[] newShape = new int[data.getRank() + 2];
                                newShape[0] = 1;
                                newShape[1] = 1;
                                System.arraycopy(shape, 0, newShape, 1, data.getRank());
                                int[] origin = new int[data.getRank() + 2];
                                origin[0] = count;
                                origin[1] = countLevel;
                                String mname = seqm.getName() + "-" + m.getName();
                                if (debug && count == 0 && countLevel == 0) {
                                    System.out.println("write to = " + mname);
                                }
                                ncfile.write(mname, origin, data.reshape(newShape));
                            }
                            ++countLevel;
                        }
                        continue;
                    }
                    finally {
                        iter.finish();
                        continue;
                    }
                }
                Array data = recordData.getArray(m);
                int[] shape = data.getShape();
                int[] newShape = new int[data.getRank() + 1];
                newShape[0] = 1;
                System.arraycopy(shape, 0, newShape, 1, data.getRank());
                int[] origin = new int[data.getRank() + 1];
                origin[0] = count;
                if (debug && count == 0) {
                    System.out.println("write to = " + m.getName());
                }
                ncfile.write(m.getName(), origin, data.reshape(newShape));
            }
            totalRecordBytes += (double)sdataSize;
        }
        total += totalRecordBytes;
        totalRecordBytes /= 1000000.0;
        if (debug) {
            System.out.println("write record var; total = " + totalRecordBytes + " Mbytes # recs=" + nrecs);
        }
        return total;
    }

    public static void main(String[] args) throws Exception {
        String fileIn = "C:\\data\\bufr\\edition3\\meteosat\\METEOSAT7-MVIRI-MTPHRWW-NA-1-20080405123005.000000000Z-909326.bfr ";
        try (NetcdfFile ncf = NetcdfDataset.openFile((String)fileIn, null);){
            System.out.println(ncf.toString());
            new Write2ncRect(ncf, "C:/data/bufr2nc.meteosat.nc", true);
        }
    }
}

