/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import ucar.ma2.ArraySequence;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.point.bufr.BufrCdmIndexProto;
import ucar.nc2.ft.point.bufr.BufrField;
import ucar.nc2.ft.point.bufr.StandardFields;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Indent;
import ucar.unidata.geoloc.StationImpl;
import ucar.unidata.io.RandomAccessFile;

public class BufrConfig {
    private static final Logger log = LoggerFactory.getLogger(BufrConfig.class);
    private String filename;
    private StandardFields.StandardFieldsFromMessage standardFields;
    private FieldConverter rootConverter;
    private int messHash;
    private FeatureType featureType;
    private Map<String, BufrStation> map;
    private long start = Long.MAX_VALUE;
    private long end = Long.MIN_VALUE;
    private boolean debug;
    private StandardFields.StandardFieldsFromStructure extract;
    private boolean hasStations;
    private boolean hasDate;
    private int countObs;
    private CalendarDate today = CalendarDate.present();

    public static BufrConfig scanEntireFile(RandomAccessFile raf) throws IOException {
        return new BufrConfig(raf);
    }

    public static BufrConfig openFromMessage(RandomAccessFile raf, Message m, Element iospParam) throws IOException {
        BufrConfig config = new BufrConfig(raf, m);
        if (iospParam != null) {
            config.merge(iospParam);
        }
        return config;
    }

    private BufrConfig(RandomAccessFile raf) {
        this.filename = raf.getLocation();
        try {
            this.scanBufrFile(raf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private BufrConfig(RandomAccessFile raf, Message m) throws IOException {
        this.filename = raf.getLocation();
        this.messHash = m.hashCode();
        this.rootConverter = new FieldConverter(m.ids.getCenterId(), m.getRootDataDescriptor());
        this.standardFields = StandardFields.extract(m);
    }

    public String getFilename() {
        return this.filename;
    }

    public FieldConverter getRootConverter() {
        return this.rootConverter;
    }

    public Map<String, BufrStation> getStationMap() {
        return this.map;
    }

    public int getMessHash() {
        return this.messHash;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public FieldConverter getStandardField(BufrCdmIndexProto.FldType want) {
        for (FieldConverter fld : this.rootConverter.flds) {
            if (fld.type != want) continue;
            return fld;
        }
        return null;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getNobs() {
        return this.countObs;
    }

    private void merge(Element iospParam) {
        assert (iospParam.getName().equals("iospParam"));
        Element bufr2nc = iospParam.getChild("bufr2nc", Catalog.ncmlNS);
        if (bufr2nc == null) {
            return;
        }
        for (Element child : bufr2nc.getChildren("fld", Catalog.ncmlNS)) {
            this.merge(child, this.rootConverter);
        }
    }

    private void merge(Element jdom, FieldConverter parent) {
        String name;
        String fxyName;
        if (jdom == null || parent == null) {
            return;
        }
        FieldConverter fld = null;
        String idxName = jdom.getAttributeValue("idx");
        if (idxName != null) {
            try {
                int idx = Integer.parseInt(idxName);
                fld = parent.getChild(idx);
            }
            catch (NumberFormatException ne) {
                log.info("BufrConfig cant find Child member index={} for file = {}", (Object)idxName, (Object)this.filename);
            }
        }
        if (fld == null && (fxyName = jdom.getAttributeValue("fxy")) != null && (fld = parent.findChildByFxyName(fxyName)) == null) {
            log.info("BufrConfig cant find Child member fxy={} for file = {}", (Object)fxyName, (Object)this.filename);
        }
        if (fld == null && (name = jdom.getAttributeValue("name")) != null && (fld = parent.findChild(name)) == null) {
            log.info("BufrConfig cant find Child member name={} for file = {}", (Object)name, (Object)this.filename);
        }
        if (fld == null) {
            log.info("BufrConfig must have idx, name or fxy attribute = {} for file = {}", (Object)jdom, (Object)this.filename);
            return;
        }
        String action = jdom.getAttributeValue("action");
        if (action != null && !action.isEmpty()) {
            fld.setAction(action);
        }
        if (jdom.getChildren("fld") != null) {
            for (Element child : jdom.getChildren("fld", Catalog.ncmlNS)) {
                this.merge(child, fld);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanBufrFile(RandomAccessFile raf) throws Exception {
        this.countObs = 0;
        try (NetcdfFile ncd = null;){
            MessageScanner scanner = new MessageScanner(raf);
            Message protoMessage = scanner.getFirstDataMessage();
            if (protoMessage == null) {
                throw new IOException("No message found!");
            }
            this.messHash = protoMessage.hashCode();
            this.standardFields = StandardFields.extract(protoMessage);
            this.rootConverter = new FieldConverter(protoMessage.ids.getCenterId(), protoMessage.getRootDataDescriptor());
            if (this.standardFields.hasStation()) {
                this.hasStations = true;
                this.map = new HashMap<String, BufrStation>(1000);
            }
            this.featureType = this.guessFeatureType(this.standardFields);
            this.hasDate = this.standardFields.hasTime();
            ncd = NetcdfFile.open((String)raf.getLocation());
            Attribute centerAtt = ncd.findGlobalAttribute("BUFR:centerId");
            int center = centerAtt == null ? 0 : centerAtt.getNumericValue().intValue();
            Sequence seq = (Sequence)ncd.findVariable(null, "obs");
            this.extract = new StandardFields.StandardFieldsFromStructure(center, (Structure)seq);
            StructureDataIterator iter = seq.getStructureIterator();
            this.processSeq(iter, this.rootConverter, true);
            this.setStandardActions(this.rootConverter);
        }
    }

    private FeatureType guessFeatureType(StandardFields.StandardFieldsFromMessage standardFields) {
        if (standardFields.hasStation()) {
            return FeatureType.STATION;
        }
        if (standardFields.hasTime()) {
            return FeatureType.POINT;
        }
        return FeatureType.ANY;
    }

    private void setStandardActions(FieldConverter fld) {
        fld.setAction(fld.makeAction());
        if (fld.flds == null) {
            return;
        }
        for (FieldConverter child : fld.flds) {
            this.setStandardActions(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSeq(StructureDataIterator sdataIter, FieldConverter parent, boolean isTop) throws IOException {
        try {
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                if (isTop) {
                    ++this.countObs;
                    if (this.hasStations) {
                        this.processStations(parent, sdata);
                    }
                    if (this.hasDate) {
                        long msecs;
                        this.extract.extract(sdata);
                        CalendarDate date = this.extract.makeCalendarDate();
                        if (Math.abs(date.getDifferenceInMsecs(this.today)) > 8640000000L) {
                            this.extract.makeCalendarDate();
                        }
                        if (this.start > (msecs = date.getMillis())) {
                            this.start = msecs;
                        }
                        if (this.end < msecs) {
                            this.end = msecs;
                        }
                    }
                }
                int count = 0;
                for (StructureMembers.Member m : sdata.getMembers()) {
                    if (m.getDataType() == DataType.SEQUENCE) {
                        FieldConverter fld = parent.getChild(count);
                        ArraySequence data = (ArraySequence)sdata.getArray(m);
                        int n = data.getStructureDataCount();
                        fld.trackSeqCounts(n);
                        this.processSeq(data.getStructureDataIterator(), fld, false);
                    }
                    ++count;
                }
            }
        }
        finally {
            sdataIter.close();
        }
    }

    private void processStations(FieldConverter parent, StructureData sdata) {
        BufrStation station = new BufrStation();
        station.read(parent, sdata);
        if (station.getName() == null) {
            log.warn("bad station name: " + (Object)((Object)station));
            return;
        }
        BufrStation check = this.map.get(station.getName());
        if (check == null) {
            this.map.put(station.getName(), station);
        } else {
            ++check.count;
            if (!station.equals((Object)check)) {
                log.warn("bad station doesnt equal " + (Object)((Object)station) + " != " + (Object)((Object)check));
            }
        }
    }

    public void show(Formatter out) {
        if (this.standardFields != null) {
            out.format("Standard Fields%n%s%n%n", this.standardFields);
        }
        Indent indent = new Indent(2);
        out.format("<bufr2nc location='%s' hash='%s' featureType='%s'>%n", this.filename, Integer.toHexString(this.messHash), this.featureType);
        indent.incr();
        int index = 0;
        for (FieldConverter fld : this.rootConverter.flds) {
            fld.show(out, indent, index++);
        }
        indent.decr();
        out.format("</bufr2nc>%n", new Object[0]);
    }

    public static class FieldConverter
    implements BufrField {
        DataDescriptor dds;
        List<FieldConverter> flds;
        BufrCdmIndexProto.FldType type;
        BufrCdmIndexProto.FldAction action;
        int min = Integer.MAX_VALUE;
        int max;
        boolean isSeq;

        private FieldConverter(int center, DataDescriptor dds) {
            this.dds = dds;
            this.type = StandardFields.findField(center, dds.getFxyName());
            if (dds.getSubKeys() != null) {
                this.flds = new ArrayList<FieldConverter>(dds.getSubKeys().size());
                for (DataDescriptor subdds : dds.getSubKeys()) {
                    FieldConverter subfld = new FieldConverter(center, subdds);
                    this.flds.add(subfld);
                }
            }
        }

        @Override
        public String getName() {
            return this.dds.getName();
        }

        @Override
        public String getDesc() {
            return this.dds.getDesc();
        }

        @Override
        public String getUnits() {
            return this.dds.getUnits();
        }

        @Override
        public short getFxy() {
            return this.dds.getFxy();
        }

        @Override
        public String getFxyName() {
            return this.dds.getFxyName();
        }

        @Override
        public BufrCdmIndexProto.FldAction getAction() {
            return this.action;
        }

        @Override
        public BufrCdmIndexProto.FldType getType() {
            return this.type;
        }

        public List<FieldConverter> getChildren() {
            return this.flds;
        }

        @Override
        public boolean isSeq() {
            return this.isSeq;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }

        @Override
        public int getScale() {
            return this.dds.getScale();
        }

        @Override
        public int getReference() {
            return this.dds.getRefVal();
        }

        @Override
        public int getBitWidth() {
            return this.dds.getBitWidth();
        }

        public void setAction(String action) {
            try {
                this.action = BufrCdmIndexProto.FldAction.valueOf(action);
            }
            catch (Exception e) {
                log.warn("Unknown action {}", (Object)action);
            }
        }

        public void setAction(BufrCdmIndexProto.FldAction action) {
            this.action = action;
        }

        FieldConverter findChild(String want) {
            for (FieldConverter child : this.flds) {
                String name = child.dds.getName();
                if (name == null || !name.equals(want)) continue;
                return child;
            }
            return null;
        }

        FieldConverter findChildByFxyName(String fxyName) {
            for (FieldConverter child : this.flds) {
                String name = child.dds.getFxyName();
                if (name == null || !name.equals(fxyName)) continue;
                return child;
            }
            return null;
        }

        public FieldConverter getChild(int i) {
            return this.flds.get(i);
        }

        void trackSeqCounts(int n) {
            this.isSeq = true;
            if (n > this.max) {
                this.max = n;
            }
            if (n < this.min) {
                this.min = n;
            }
        }

        void showRange(Formatter f) {
            if (!this.isSeq) {
                return;
            }
            if (this.max == this.min) {
                f.format(" isConstant='%d'", this.max);
            } else if (this.max < 2) {
                f.format(" isBinary='true'", new Object[0]);
            } else {
                f.format(" range='[%d,%d]'", this.min, this.max);
            }
        }

        BufrCdmIndexProto.FldAction makeAction() {
            if (!this.isSeq) {
                return null;
            }
            if (this.max == 0) {
                return BufrCdmIndexProto.FldAction.remove;
            }
            if (this.max < 2) {
                return BufrCdmIndexProto.FldAction.asMissing;
            }
            return BufrCdmIndexProto.FldAction.asArray;
        }

        void show(Formatter f, Indent indent, int index) {
            boolean hasContent = false;
            if (this.isSeq) {
                f.format("%s<fld idx='%d' name='%s'", indent, index, this.dds.getName());
            } else {
                f.format("%s<fld idx='%d' fxy='%s' name='%s' desc='%s' units='%s' bits='%d'", indent, index, this.dds.getFxyName(), this.dds.getName(), this.dds.getDesc(), this.dds.getUnits(), this.dds.getBitWidth());
            }
            if (this.type != null) {
                f.format(" type='%s'", new Object[]{this.type});
            }
            this.showRange(f);
            f.format(" action='%s'", new Object[]{this.makeAction()});
            if (this.flds != null) {
                f.format(">%n", new Object[0]);
                indent.incr();
                int subidx = 0;
                for (FieldConverter cc : this.flds) {
                    cc.show(f, indent, subidx++);
                }
                indent.decr();
                hasContent = true;
            }
            if (hasContent) {
                f.format("%s</fld>%n", indent);
            } else {
                f.format(" />%n", new Object[0]);
            }
        }
    }

    public class BufrStation
    extends StationImpl {
        public int count = 1;

        void read(FieldConverter parent, StructureData sdata) {
            BufrConfig.this.extract.extract(sdata);
            this.setName(BufrConfig.this.extract.getStationId());
            this.setLatitude(BufrConfig.this.extract.getFieldValueD(BufrCdmIndexProto.FldType.lat));
            this.setLongitude(BufrConfig.this.extract.getFieldValueD(BufrCdmIndexProto.FldType.lon));
            if (BufrConfig.this.extract.hasField(BufrCdmIndexProto.FldType.stationDesc)) {
                this.setDescription(BufrConfig.this.extract.getFieldValueS(BufrCdmIndexProto.FldType.stationDesc));
            }
            if (BufrConfig.this.extract.hasField(BufrCdmIndexProto.FldType.wmoId)) {
                this.setWmoId(BufrConfig.this.extract.getFieldValueS(BufrCdmIndexProto.FldType.wmoId));
            }
            if (BufrConfig.this.extract.hasField(BufrCdmIndexProto.FldType.heightOfStation)) {
                this.setAltitude(BufrConfig.this.extract.getFieldValueD(BufrCdmIndexProto.FldType.heightOfStation));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            BufrStation that = (BufrStation)((Object)o);
            if (Double.compare(that.alt, this.alt) != 0) {
                return false;
            }
            if (Double.compare(that.lat, this.lat) != 0) {
                return false;
            }
            if (Double.compare(that.lon, this.lon) != 0) {
                return false;
            }
            if (!Objects.equals(this.desc, that.desc)) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return Objects.equals(this.wmoId, that.wmoId);
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.lat);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.lon);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.alt);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
            result = 31 * result + (this.wmoId != null ? this.wmoId.hashCode() : 0);
            return result;
        }
    }
}

