/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.Construct2;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.iosp.bufr.tables.WmoXmlReader;
import ucar.nc2.wmo.Util;
import ucar.unidata.io.RandomAccessFile;

public class EmbeddedTable {
    private static final boolean showB = false;
    private static final boolean showD = false;
    private final RandomAccessFile raf;
    private final BufrIdentificationSection ids;
    private List<Message> messages = new ArrayList<Message>();
    private boolean tableRead;
    private TableB b;
    private TableD d;
    private Structure seq2;
    private Structure seq3;
    private Structure seq4;
    private TableLookup tlookup;

    EmbeddedTable(Message m, RandomAccessFile raf) {
        this.raf = raf;
        this.ids = m.ids;
        this.b = new TableB("embed", raf.getLocation());
        this.d = new TableD("embed", raf.getLocation());
    }

    public void addTable(Message m) {
        this.messages.add(m);
    }

    private void read2() throws IOException {
        Message proto = this.messages.get(0);
        BufrConfig config = BufrConfig.openFromMessage(this.raf, proto, null);
        Construct2 construct = new Construct2(proto, config, (NetcdfFile)new NetcdfFileSubclass());
        Sequence obs = construct.getObsStructure();
        this.seq2 = (Structure)obs.findVariable("seq2");
        this.seq3 = (Structure)obs.findVariable("seq3");
        this.seq4 = (Structure)this.seq3.findVariable("seq4");
        for (Message m : this.messages) {
            ArrayStructure data;
            Object reader;
            if (!m.dds.isCompressed()) {
                reader = new MessageUncompressedDataReader();
                data = ((MessageUncompressedDataReader)reader).readEntireMessage((Structure)obs, proto, m, this.raf, null);
            } else {
                reader = new MessageCompressedDataReader();
                data = ((MessageCompressedDataReader)reader).readEntireMessage((Structure)obs, proto, m, this.raf, null);
            }
            while (data.hasNext()) {
                StructureData sdata = (StructureData)data.next();
                this.add(sdata);
            }
        }
    }

    private void add(StructureData data) throws IOException {
        for (StructureMembers.Member m : data.getMembers()) {
            StructureDataIterator iter;
            ArraySequence seq;
            if (m.getDataType() != DataType.SEQUENCE) continue;
            if (m.getName().equals("seq2")) {
                seq = data.getArraySequence(m);
                iter = seq.getStructureDataIterator();
                while (iter.hasNext()) {
                    this.addTableEntryB(iter.next());
                }
                continue;
            }
            if (!m.getName().equals("seq3")) continue;
            seq = data.getArraySequence(m);
            iter = seq.getStructureDataIterator();
            while (iter.hasNext()) {
                this.addTableEntryD(iter.next());
            }
        }
    }

    private void addTableEntryB(StructureData sdata) {
        String name = "";
        String units = "";
        String signScale = null;
        String signRef = null;
        int scale = 0;
        int refVal = 0;
        int width = 0;
        short x1 = 0;
        short y1 = 0;
        List members = sdata.getMembers();
        List vars = this.seq2.getVariables();
        block26: for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            StructureMembers.Member m = (StructureMembers.Member)members.get(i);
            String data = sdata.getScalarString(m);
            Attribute att = v.findAttribute("BUFR:TableB_descriptor");
            switch (att.getStringValue()) {
                case "0-0-10": {
                    sdata.getScalarString(m);
                    continue block26;
                }
                case "0-0-11": {
                    String x = sdata.getScalarString(m);
                    x1 = Short.parseShort(x.trim());
                    continue block26;
                }
                case "0-0-12": {
                    String y = sdata.getScalarString(m);
                    y1 = Short.parseShort(y.trim());
                    continue block26;
                }
                case "0-0-13": {
                    name = sdata.getScalarString(m);
                    continue block26;
                }
                case "0-0-14": {
                    name = name + sdata.getScalarString(m);
                    continue block26;
                }
                case "0-0-15": {
                    units = sdata.getScalarString(m);
                    units = WmoXmlReader.cleanUnit(units.trim());
                    continue block26;
                }
                case "0-0-16": {
                    signScale = sdata.getScalarString(m).trim();
                    continue block26;
                }
                case "0-0-17": {
                    String scaleS = sdata.getScalarString(m);
                    scale = Integer.parseInt(scaleS.trim());
                    continue block26;
                }
                case "0-0-18": {
                    signRef = sdata.getScalarString(m).trim();
                    continue block26;
                }
                case "0-0-19": {
                    String refS = sdata.getScalarString(m);
                    refVal = Integer.parseInt(refS.trim());
                    continue block26;
                }
                case "0-0-20": {
                    String widthS = sdata.getScalarString(m);
                    width = Integer.parseInt(widthS.trim());
                }
            }
        }
        String desc = null;
        int pos = (name = name.trim()).indexOf(32);
        if (pos > 0) {
            desc = Util.cleanName((String)name.substring(pos + 1));
            name = name.substring(0, pos);
            name = Util.cleanName((String)name);
        }
        if ("-".equals(signScale)) {
            scale = -1 * scale;
        }
        if ("-".equals(signRef)) {
            refVal = -1 * refVal;
        }
        this.b.addDescriptor(x1, y1, scale, refVal, width, name, units, desc);
    }

    private void addTableEntryD(StructureData sdata) throws IOException {
        String name = null;
        short x1 = 0;
        short y1 = 0;
        List<Short> dds = null;
        List members = sdata.getMembers();
        List vars = this.seq3.getVariables();
        block12: for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            StructureMembers.Member m = (StructureMembers.Member)members.get(i);
            if (m.getName().equals("seq4")) {
                dds = this.getDescriptors(sdata.getArraySequence(m));
                continue;
            }
            Attribute att = v.findAttribute("BUFR:TableB_descriptor");
            if (att == null) continue;
            switch (att.getStringValue()) {
                case "0-0-10": {
                    sdata.getScalarString(m);
                    continue block12;
                }
                case "0-0-11": {
                    String x = sdata.getScalarString(m);
                    x1 = Short.parseShort(x.trim());
                    continue block12;
                }
                case "0-0-12": {
                    String y = sdata.getScalarString(m);
                    y1 = Short.parseShort(y.trim());
                    continue block12;
                }
                case "2-5-64": {
                    name = sdata.getScalarString(m);
                }
            }
        }
        name = Util.cleanName(name);
        this.d.addDescriptor(x1, y1, name, dds);
    }

    private List<Short> getDescriptors(ArraySequence seqdata) throws IOException {
        ArrayList<Short> list = new ArrayList<Short>();
        String fxyS = null;
        List vars = this.seq4.getVariables();
        StructureDataIterator iter = seqdata.getStructureDataIterator();
        while (iter.hasNext()) {
            StructureData sdata = iter.next();
            List members = sdata.getMembers();
            for (int i = 0; i < vars.size(); ++i) {
                Variable v = (Variable)vars.get(i);
                StructureMembers.Member m = (StructureMembers.Member)members.get(i);
                String data = sdata.getScalarString(m);
                Attribute att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null || !att.getStringValue().equals("0-0-30")) continue;
                fxyS = sdata.getScalarString(m);
            }
            if (fxyS == null) continue;
            short id = Descriptor.getFxy2(fxyS);
            list.add(id);
        }
        return list;
    }

    TableLookup getTableLookup() throws IOException {
        if (!this.tableRead) {
            this.read2();
            this.tableRead = true;
            this.tlookup = new TableLookup(this.ids, this.b, this.d);
        }
        return this.tlookup;
    }
}

