/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.unidata.util.StringUtil2;

public class NcepTable {
    private static Logger log = LoggerFactory.getLogger(NcepTable.class);
    private static List<TableEntry> entries;

    private static void readNcepTable(String location) throws IOException {
        try (InputStream ios = BufrTables.openStream(location);){
            String line;
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
            int count = 0;
            while ((line = dataIS.readLine()) != null) {
                if (line.startsWith("#")) continue;
                ++count;
                String[] flds = line.split(";");
                if (flds.length < 3) {
                    log.warn("{} BAD split == {}", (Object)count, (Object)line);
                    continue;
                }
                int fldidx = 0;
                try {
                    int cat = Integer.parseInt(flds[fldidx++].trim());
                    int subcat = Integer.parseInt(flds[fldidx++].trim());
                    String desc = StringUtil2.remove((String)flds[fldidx++], (int)34);
                    entries.add(new TableEntry(cat, subcat, desc));
                }
                catch (Exception e) {
                    log.warn("{} {} BAD line == {}", new Object[]{count, fldidx, line});
                }
            }
        }
    }

    private static void init() {
        entries = new ArrayList<TableEntry>(100);
        String location = "resource:/resources/bufrTables/local/ncep/DataSubCategories.csv";
        try {
            NcepTable.readNcepTable(location);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getDataSubcategory(int cat, int subcat) {
        if (entries == null) {
            NcepTable.init();
        }
        for (TableEntry p : entries) {
            if (p.cat != cat || p.subcat != subcat) continue;
            return p.value;
        }
        return null;
    }

    private static class TableEntry {
        public int cat;
        public int subcat;
        public String value;

        public TableEntry(int cat, int subcat, String value) {
            this.cat = cat;
            this.subcat = subcat;
            this.value = value.trim();
        }
    }
}

