/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import ucar.nc2.iosp.bufr.BitCounter;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.util.Indent;

public class BitCounterUncompressed
implements BitCounter {
    private final DataDescriptor parent;
    private final int nrows;
    private final int replicationCountSize;
    private Map<DataDescriptor, Integer> bitPosition;
    private Map<DataDescriptor, BitCounterUncompressed[]> subCounters;
    private int[] startBit;
    private int countBits;
    private int bitOffset;
    private static boolean debug;

    BitCounterUncompressed(DataDescriptor parent, int nrows, int replicationCountSize) {
        this.parent = parent;
        this.nrows = nrows;
        this.replicationCountSize = replicationCountSize;
    }

    public void setBitOffset(DataDescriptor dkey) {
        if (this.bitPosition == null) {
            this.bitPosition = new HashMap<DataDescriptor, Integer>(2 * this.parent.getSubKeys().size());
        }
        this.bitPosition.put(dkey, this.bitOffset);
        this.bitOffset += dkey.getBitWidth();
    }

    public int getOffset(DataDescriptor dkey) {
        return this.bitPosition.get(dkey);
    }

    BitCounterUncompressed makeNested(DataDescriptor subKey, int n, int row, int replicationCountSize) {
        BitCounterUncompressed rc;
        if (this.subCounters == null) {
            this.subCounters = new HashMap<DataDescriptor, BitCounterUncompressed[]>(5);
        }
        BitCounterUncompressed[] subCounter = this.subCounters.computeIfAbsent(subKey, k -> new BitCounterUncompressed[this.nrows]);
        subCounter[row] = rc = new BitCounterUncompressed(subKey, n, replicationCountSize);
        return rc;
    }

    public BitCounterUncompressed[] getNested(DataDescriptor subKey) {
        return this.subCounters == null ? null : this.subCounters.get(subKey);
    }

    int countBits(int startBit) {
        this.countBits = this.replicationCountSize;
        this.startBit = new int[this.nrows];
        for (int row = 0; row < this.nrows; ++row) {
            this.startBit[row] = startBit + this.countBits;
            if (debug) {
                System.out.println(" BitCounterUncompressed row " + row + " startBit=" + this.startBit[row]);
            }
            for (DataDescriptor nd : this.parent.subKeys) {
                BitCounterUncompressed[] bitCounter;
                BitCounterUncompressed[] bitCounterUncompressedArray = bitCounter = this.subCounters == null ? null : this.subCounters.get(nd);
                if (bitCounter == null) {
                    this.countBits += nd.getBitWidth();
                    continue;
                }
                if (bitCounter[row] == null) continue;
                if (debug) {
                    System.out.println(" ---------> nested " + nd.getFxyName() + " starts at =" + (startBit + this.countBits));
                }
                this.countBits += bitCounter[row].countBits(startBit + this.countBits);
                if (!debug) continue;
                System.out.println(" <--------- nested " + nd.getFxyName() + " ends at =" + (startBit + this.countBits));
            }
        }
        return this.countBits;
    }

    public int getCountBits() {
        return this.countBits;
    }

    @Override
    public int getNumberRows() {
        return this.nrows;
    }

    public int getStartBit(int row) {
        if (row >= this.startBit.length) {
            throw new IllegalStateException();
        }
        return this.startBit[row];
    }

    public void toString(Formatter f, Indent indent) {
        f.format("%s dds=%s, ", indent, this.parent.getFxyName());
        f.format("nrows=%d%n", this.nrows);
        if (this.subCounters == null) {
            return;
        }
        indent.incr();
        int count = 0;
        for (BitCounterUncompressed[] bcus : this.subCounters.values()) {
            if (bcus == null) {
                f.format("%s%d: null", indent, count);
            } else {
                for (BitCounterUncompressed bcu : bcus) {
                    bcu.toString(f, indent);
                }
            }
            ++count;
        }
        indent.decr();
    }
}

