/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.iosp.bufr.BufrIosp;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageArrayCompressedReader;
import ucar.nc2.iosp.bufr.MessageArrayUncompressedReader;

public class BufrIospArrays
extends BufrIosp {
    private static final Logger log = LoggerFactory.getLogger(BufrIospArrays.class);

    public Iterator<StructureData> getStructureDataArrayIterator(Sequence s, int bufferSize) {
        this.findRootSequence();
        return this.isSingle ? new SeqIterSingleArray() : new SeqIterArray();
    }

    private void findRootSequence() {
        this.obsStructure = (Sequence)this.ncfile.findVariable("obs");
    }

    private class SeqIterSingleArray
    implements Iterator<StructureData> {
        Iterator<StructureData> currIter;
        int recnum;

        private SeqIterSingleArray() {
        }

        @Override
        public boolean hasNext() {
            if (this.currIter == null) {
                try {
                    this.currIter = this.readProtoMessage();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.currIter == null) {
                    BufrIospArrays.this.nelems = this.recnum;
                    return false;
                }
            }
            return this.currIter.hasNext();
        }

        @Override
        public StructureData next() {
            ++this.recnum;
            return this.currIter.next();
        }

        private Iterator<StructureData> readProtoMessage() throws IOException {
            StructureDataArray as;
            Message m = BufrIospArrays.this.protoMessage;
            if (m.dds.isCompressed()) {
                MessageArrayCompressedReader reader = new MessageArrayCompressedReader((Structure)BufrIospArrays.this.obsStructure, BufrIospArrays.this.protoMessage, m, BufrIospArrays.this.raf, null);
                as = reader.readEntireMessage();
            } else {
                Formatter f = new Formatter();
                MessageArrayUncompressedReader uncomp = new MessageArrayUncompressedReader((Structure)BufrIospArrays.this.obsStructure, BufrIospArrays.this.protoMessage, m, BufrIospArrays.this.raf, f);
                as = uncomp.readEntireMessage();
                System.out.printf("%s%n", f);
            }
            return as.iterator();
        }
    }

    private class SeqIterArray
    implements Iterator<StructureData> {
        Iterator<StructureData> currIter;
        int recnum;

        SeqIterArray() {
            BufrIospArrays.this.scanner.reset();
        }

        @Override
        public boolean hasNext() {
            if (this.currIter == null) {
                try {
                    this.currIter = this.readNextMessage();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.currIter == null) {
                    BufrIospArrays.this.nelems = this.recnum;
                    return false;
                }
            }
            if (!this.currIter.hasNext()) {
                try {
                    this.currIter = this.readNextMessage();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return this.hasNext();
            }
            return true;
        }

        @Override
        public StructureData next() {
            ++this.recnum;
            return this.currIter.next();
        }

        private Iterator<StructureData> readNextMessage() throws IOException {
            if (!BufrIospArrays.this.scanner.hasNext()) {
                return null;
            }
            Message m = BufrIospArrays.this.scanner.next();
            if (m == null) {
                log.warn("BUFR scanner hasNext() true but next() null!");
                return null;
            }
            if (m.containsBufrTable()) {
                return this.readNextMessage();
            }
            if (!BufrIospArrays.this.protoMessage.equals(m)) {
                if (BufrIospArrays.this.messHash == null) {
                    BufrIospArrays.this.messHash = new HashSet(20);
                }
                if (!BufrIospArrays.this.messHash.contains(m.hashCode())) {
                    log.warn("File " + BufrIospArrays.this.raf.getLocation() + " has different BUFR message types hash=" + BufrIospArrays.this.protoMessage.hashCode() + "; skipping");
                    BufrIospArrays.this.messHash.add(m.hashCode());
                }
                return this.readNextMessage();
            }
            StructureDataArray as = this.readMessage(m);
            return as.iterator();
        }

        private StructureDataArray readMessage(Message m) throws IOException {
            StructureDataArray as;
            Formatter f = new Formatter();
            try {
                if (m.dds.isCompressed()) {
                    MessageArrayCompressedReader comp = new MessageArrayCompressedReader((Structure)BufrIospArrays.this.obsStructure, BufrIospArrays.this.protoMessage, m, BufrIospArrays.this.raf, f);
                    as = comp.readEntireMessage();
                } else {
                    MessageArrayUncompressedReader uncomp = new MessageArrayUncompressedReader((Structure)BufrIospArrays.this.obsStructure, BufrIospArrays.this.protoMessage, m, BufrIospArrays.this.raf, f);
                    as = uncomp.readEntireMessage();
                }
            }
            catch (Throwable t) {
                System.out.printf("FAIL %s%n", f);
                throw t;
            }
            return as;
        }
    }
}

