/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.tables.CodeFlagTables;

class Construct2 {
    private static Logger log = LoggerFactory.getLogger(Construct2.class);
    private static final boolean warnUnits = false;
    private NetcdfFile ncfile;
    private Sequence obsStructure;
    private Group.Builder rootGroup;
    private Sequence.Builder recordb;
    private int centerId;
    private Formatter coordinates = new Formatter();
    private int tempNo = 1;
    private Map<String, Integer> names = new HashMap<String, Integer>(100);

    Construct2(Message proto, BufrConfig bufrConfig, String location) {
        this.rootGroup = Group.builder();
        this.rootGroup.addAttribute(new Attribute("history", "Read using CDM BufrIosp2"));
        if (bufrConfig.getFeatureType() != null) {
            this.rootGroup.addAttribute(new Attribute("featureType", bufrConfig.getFeatureType().toString()));
        }
        this.rootGroup.addAttribute(new Attribute("location", location));
        this.rootGroup.addAttribute(new Attribute("BUFR:categoryName", proto.getLookup().getCategoryName()));
        this.rootGroup.addAttribute(new Attribute("BUFR:subCategoryName", proto.getLookup().getSubCategoryName()));
        this.rootGroup.addAttribute(new Attribute("BUFR:centerName", proto.getLookup().getCenterName()));
        this.rootGroup.addAttribute(new Attribute("BUFR:category", (Number)proto.ids.getCategory()));
        this.rootGroup.addAttribute(new Attribute("BUFR:subCategory", (Number)proto.ids.getSubCategory()));
        this.rootGroup.addAttribute(new Attribute("BUFR:localSubCategory", (Number)proto.ids.getLocalSubCategory()));
        this.rootGroup.addAttribute(new Attribute("BUFR:centerId", (Number)proto.ids.getCenterId()));
        this.rootGroup.addAttribute(new Attribute("BUFR:subCenter", (Number)proto.ids.getSubCenterId()));
        this.rootGroup.addAttribute(new Attribute("BUFR:table", (Number)proto.ids.getMasterTableId()));
        this.rootGroup.addAttribute(new Attribute("BUFR:tableVersion", (Number)proto.ids.getMasterTableVersion()));
        this.rootGroup.addAttribute(new Attribute("BUFR:localTableVersion", (Number)proto.ids.getLocalTableVersion()));
        this.rootGroup.addAttribute(new Attribute("Conventions", "BUFR/CDM"));
        this.rootGroup.addAttribute(new Attribute("BUFR:edition", (Number)proto.is.getBufrEdition()));
        this.centerId = proto.ids.getCenterId();
        String header = proto.getHeader();
        if (header != null && !header.isEmpty()) {
            this.rootGroup.addAttribute(new Attribute("WMO_Header", header));
        }
        this.makeObsRecord(bufrConfig);
        String coordS = this.coordinates.toString();
        if (!coordS.isEmpty()) {
            this.recordb.addAttribute(new Attribute("coordinates", coordS));
        }
        this.ncfile = NetcdfFile.builder().setRootGroup(this.rootGroup).setLocation(location).build();
        this.obsStructure = (Sequence)this.ncfile.findVariable("obs");
    }

    NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    Sequence getObsStructure() {
        return this.obsStructure;
    }

    private void makeObsRecord(BufrConfig bufrConfig) {
        this.recordb = (Sequence.Builder)Sequence.builder().setName("obs");
        this.rootGroup.addVariable((Variable.Builder)this.recordb);
        BufrConfig.FieldConverter root = bufrConfig.getRootConverter();
        for (BufrConfig.FieldConverter fld : root.flds) {
            DataDescriptor dkey = fld.dds;
            if (!dkey.isOkForVariable()) continue;
            if (dkey.replication == 0) {
                this.addSequence((Structure.Builder<?>)this.recordb, fld);
                continue;
            }
            if (dkey.replication > 1) {
                List<BufrConfig.FieldConverter> subFlds = fld.flds;
                List<DataDescriptor> subKeys = dkey.subKeys;
                if (subKeys.size() == 1) {
                    DataDescriptor subDds = dkey.subKeys.get(0);
                    BufrConfig.FieldConverter subFld = subFlds.get(0);
                    if (subDds.dpi != null) {
                        this.addDpiStructure(this.recordb, fld, subFld);
                        continue;
                    }
                    if (subDds.replication == 1) {
                        this.addVariable((Structure.Builder<?>)this.recordb, subFld, dkey.replication).setSPobject((Object)fld);
                        continue;
                    }
                    this.addStructure((Structure.Builder<?>)this.recordb, fld, dkey.replication);
                    continue;
                }
                if (subKeys.size() <= 1) continue;
                this.addStructure((Structure.Builder<?>)this.recordb, fld, dkey.replication);
                continue;
            }
            this.addVariable((Structure.Builder<?>)this.recordb, fld, dkey.replication);
        }
    }

    private void addStructure(Structure.Builder<?> parent, BufrConfig.FieldConverter fld, int count) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findUniqueName(parent, fld.getName(), "struct");
        Structure.Builder struct = (Structure.Builder)((Structure.Builder)Structure.builder().setName(uname)).setDimensionsAnonymous(new int[]{count});
        for (BufrConfig.FieldConverter subKey : fld.flds) {
            this.addMember(struct, subKey);
        }
        parent.addMemberVariable((Variable.Builder)struct);
        struct.setSPobject((Object)fld);
    }

    private void addSequence(Structure.Builder<?> parent, BufrConfig.FieldConverter fld) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findUniqueName(parent, fld.getName(), "seq");
        Sequence.Builder seq = (Sequence.Builder)Sequence.builder().setName(uname);
        for (BufrConfig.FieldConverter subKey : fld.flds) {
            this.addMember((Structure.Builder<?>)seq, subKey);
        }
        parent.addMemberVariable((Variable.Builder)seq);
        seq.setSPobject((Object)fld);
        Sequence.Builder seqTemp = (Sequence.Builder)Sequence.builder().setName(uname);
        for (BufrConfig.FieldConverter subKey : fld.flds) {
            this.addMember((Structure.Builder<?>)seqTemp, subKey);
        }
        seqTemp.setSPobject((Object)fld);
        dkey.refersTo = seqTemp.build(Group.builder().build());
        dkey.refersToName = seq.shortName;
    }

    private void addMember(Structure.Builder<?> parent, BufrConfig.FieldConverter fld) {
        DataDescriptor dkey = fld.dds;
        if (dkey.replication == 0) {
            this.addSequence(parent, fld);
        } else if (dkey.replication > 1) {
            List<DataDescriptor> subKeys = dkey.subKeys;
            if (subKeys.size() == 1) {
                BufrConfig.FieldConverter subFld = fld.flds.get(0);
                Variable.Builder<?> v = this.addVariable(parent, subFld, dkey.replication);
                v.setSPobject((Object)fld);
            } else {
                this.addStructure(parent, fld, dkey.replication);
            }
        } else {
            this.addVariable(parent, fld, dkey.replication);
        }
    }

    private void addDpiStructure(Sequence.Builder<?> parent, BufrConfig.FieldConverter parentFld, BufrConfig.FieldConverter dpiField) {
        String uname;
        DataDescriptor dpiKey = dpiField.dds;
        dpiKey.name = uname = this.findUniqueName((Structure.Builder<?>)parent, dpiField.getName(), "struct");
        Structure.Builder struct = (Structure.Builder)Structure.builder().setName(uname);
        int n = parentFld.dds.replication;
        struct.setDimensionsAnonymous(new int[]{n});
        Variable.Builder v = Variable.builder().setName("name").setDataType(DataType.STRING);
        struct.addMemberVariable(v);
        v = Variable.builder().setName("data").setDataType(DataType.FLOAT);
        struct.addMemberVariable(v);
        parent.addMemberVariable((Variable.Builder)struct);
        struct.setSPobject((Object)dpiField);
    }

    private void addDpiSequence(Sequence.Builder<?> parent, BufrConfig.FieldConverter fld) {
        Structure.Builder struct = (Structure.Builder)Structure.builder().setName("statistics");
        struct.setDimensionsAnonymous(new int[]{fld.dds.replication});
        Variable.Builder v = Variable.builder().setName("name").setDataType(DataType.STRING);
        struct.addMemberVariable(v);
        v = Variable.builder().setName("data").setDataType(DataType.FLOAT);
        struct.addMemberVariable(v);
        parent.addMemberVariable((Variable.Builder)struct);
    }

    private Variable.Builder<?> addVariable(Structure.Builder<?> struct, BufrConfig.FieldConverter fld, int count) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findGloballyUniqueName(fld.getName(), "unknown");
        Variable.Builder v = Variable.builder().setName(uname);
        if (count > 1) {
            v.setDimensionsAnonymous(new int[]{count});
        }
        if (fld.getDesc() != null) {
            v.addAttribute(new Attribute("long_name", fld.getDesc()));
        }
        if (fld.getUnits() != null) {
            String units = fld.getUnits();
            if (DataDescriptor.isCodeTableUnit(units)) {
                v.addAttribute(new Attribute("units", "CodeTable " + fld.dds.getFxyName()));
            } else if (DataDescriptor.isFlagTableUnit(units)) {
                v.addAttribute(new Attribute("units", "FlagTable " + fld.dds.getFxyName()));
            } else if (!DataDescriptor.isInternationalAlphabetUnit(units) && !units.startsWith("Numeric")) {
                v.addAttribute(new Attribute("units", units));
            }
        }
        DataDescriptor dataDesc = fld.dds;
        if (dataDesc.type == 1) {
            v.setDataType(DataType.CHAR);
            int size = dataDesc.bitWidth / 8;
            v.setDimensionsAnonymous(new int[]{size});
        } else if (dataDesc.type == 2 && CodeFlagTables.hasTable(dataDesc.fxy)) {
            int nbits = dataDesc.bitWidth;
            int nbytes = nbits % 8 == 0 ? nbits / 8 : nbits / 8 + 1;
            CodeFlagTables ct = CodeFlagTables.getTable(dataDesc.fxy);
            if (nbytes == 1) {
                v.setDataType(DataType.ENUM1);
            } else if (nbytes == 2) {
                v.setDataType(DataType.ENUM2);
            } else if (nbytes == 4) {
                v.setDataType(DataType.ENUM4);
            }
            v.addAttribute(new Attribute("BUFR:CodeTable", ct.getName() + " (" + dataDesc.getFxyName() + ")"));
            this.rootGroup.findOrAddEnumTypedef(ct.getName(), ct.getMap());
            v.setEnumTypeName(ct.getName());
        } else {
            double scale;
            int nbits = dataDesc.bitWidth;
            if (nbits < 9) {
                v.setDataType(DataType.BYTE);
                if (nbits == 8) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (Number)((short)BufrNumbers.missingValue(nbits))));
                } else {
                    v.addAttribute(new Attribute("missing_value", (Number)((byte)BufrNumbers.missingValue(nbits))));
                }
            } else if (nbits < 17) {
                v.setDataType(DataType.SHORT);
                if (nbits == 16) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (Number)((int)BufrNumbers.missingValue(nbits))));
                } else {
                    v.addAttribute(new Attribute("missing_value", (Number)((short)BufrNumbers.missingValue(nbits))));
                }
            } else if (nbits < 33) {
                v.setDataType(DataType.INT);
                if (nbits == 32) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (Number)((int)BufrNumbers.missingValue(nbits))));
                } else {
                    v.addAttribute(new Attribute("missing_value", (Number)((int)BufrNumbers.missingValue(nbits))));
                }
            } else {
                v.setDataType(DataType.LONG);
                v.addAttribute(new Attribute("missing_value", (Number)BufrNumbers.missingValue(nbits)));
            }
            int scale10 = dataDesc.scale;
            double d = scale = scale10 == 0 ? 1.0 : Math.pow(10.0, -scale10);
            if (scale10 != 0) {
                v.addAttribute(new Attribute("scale_factor", (Number)Float.valueOf((float)scale)));
            }
            if (dataDesc.refVal != 0) {
                v.addAttribute(new Attribute("add_offset", (Number)Float.valueOf((float)scale * (float)dataDesc.refVal)));
            }
        }
        this.annotate(v, fld);
        v.addAttribute(new Attribute("BUFR:TableB_descriptor", dataDesc.getFxyName()));
        v.addAttribute(new Attribute("BUFR:bitWidth", (Number)dataDesc.bitWidth));
        struct.addMemberVariable(v);
        v.setSPobject((Object)fld);
        return v;
    }

    private String findUniqueName(Structure.Builder<?> struct, String want, String def) {
        if (want == null) {
            return def + this.tempNo++;
        }
        String vwant = NetcdfFiles.makeValidCdmObjectName((String)want);
        Optional oldV = struct.findMemberVariable(vwant);
        if (!oldV.isPresent()) {
            return vwant;
        }
        int seq = 2;
        String wantSeq;
        while ((oldV = struct.findMemberVariable(wantSeq = vwant + "-" + seq)).isPresent()) {
            ++seq;
        }
        return wantSeq;
    }

    private String findGloballyUniqueName(String want, String def) {
        if (want == null) {
            return def + this.tempNo++;
        }
        String vwant = NetcdfFiles.makeValidCdmObjectName((String)want);
        Integer have = this.names.get(vwant);
        if (have == null) {
            this.names.put(vwant, 1);
            return vwant;
        }
        have = have + 1;
        String wantSeq = vwant + "-" + have;
        this.names.put(vwant, have);
        return wantSeq;
    }

    private void annotate(Variable.Builder v, BufrConfig.FieldConverter fld) {
        if (fld.type == null) {
            return;
        }
        switch (fld.type) {
            case lat: {
                v.addAttribute(new Attribute("units", "degrees_north"));
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                this.coordinates.format("%s ", v.shortName);
                break;
            }
            case lon: {
                v.addAttribute(new Attribute("units", "degrees_east"));
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                this.coordinates.format("%s ", v.shortName);
                break;
            }
            case height: 
            case heightOfStation: 
            case heightAboveStation: {
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
                this.coordinates.format("%s ", v.shortName);
                break;
            }
            case stationId: {
                v.addAttribute(new Attribute("standard_name", "station_id"));
                break;
            }
            case wmoId: {
                v.addAttribute(new Attribute("standard_name", "station_WMO_id"));
            }
        }
    }
}

