/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import ucar.array.Array;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.array.Section;
import ucar.array.Storage;
import ucar.array.StructureDataArray;
import ucar.array.StructureDataStorageBB;
import ucar.array.StructureMembers;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.iosp.BitReader;
import ucar.nc2.iosp.bufr.BitCounterCompressed;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.DataDescriptorTreeConstructor;
import ucar.nc2.iosp.bufr.DebugOut;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageArrayReaderUtils;
import ucar.unidata.io.RandomAccessFile;

public class MessageArrayCompressedReader {
    private static final boolean structuresOnHeap = false;
    private final Message message;
    private final RandomAccessFile raf;
    private final Formatter f;
    private final HashMap<DataDescriptor, StructureMembers.Member> topmap = new HashMap(100);
    private final int ndatasets;
    private final Request topreq;

    public MessageArrayCompressedReader(Structure s, Message proto, Message message, RandomAccessFile raf, Formatter f) {
        this.message = message;
        this.raf = raf;
        this.f = f;
        DataDescriptor.transferInfo(proto.getRootDataDescriptor().getSubKeys(), message.getRootDataDescriptor().getSubKeys());
        StructureMembers.Builder membersb = s.makeStructureMembersBuilder();
        membersb.setStandardOffsets(false);
        StructureMembers members = membersb.build();
        this.ndatasets = message.getNumberDatasets();
        ByteBuffer bbuffer = ByteBuffer.allocate(this.ndatasets * members.getStorageSizeBytes());
        bbuffer.order(ByteOrder.BIG_ENDIAN);
        StructureDataStorageBB storageBB = new StructureDataStorageBB(members, bbuffer, this.ndatasets);
        MessageArrayReaderUtils.associateMessage2Members(members, message.getRootDataDescriptor(), this.topmap);
        this.topreq = new Request(storageBB, bbuffer, members, members.getStorageSizeBytes(), this.topmap);
    }

    public StructureDataArray readEntireMessage() throws IOException {
        BitReader reader = new BitReader(this.raf, this.message.dataSection.getDataPos() + 4L);
        DataDescriptor root = this.message.getRootDataDescriptor();
        if (!root.isBad) {
            DebugOut out = this.f == null ? null : new DebugOut(this.f);
            BitCounterCompressed[] counterFlds = new BitCounterCompressed[root.subKeys.size()];
            this.readData(reader, root, 0, 0, this.topreq, counterFlds, out);
            this.message.msg_nbits = 0;
            for (BitCounterCompressed counter : counterFlds) {
                if (counter == null) continue;
                this.message.msg_nbits += counter.getTotalBits();
            }
        } else {
            throw new RuntimeException("Bad root descriptor");
        }
        return new StructureDataArray(this.topreq.members, new int[]{this.ndatasets}, (Storage)this.topreq.storageBB);
    }

    private int readData(BitReader reader, DataDescriptor parent, int bitOffset, int posOffset, Request req, BitCounterCompressed[] fldCounters, @Nullable DebugOut out) throws IOException {
        List<DataDescriptor> flds = parent.getSubKeys();
        for (int fldidx = 0; fldidx < flds.size(); ++fldidx) {
            BitCounterCompressed counter;
            DataDescriptor dkey = flds.get(fldidx);
            if (!dkey.isOkForVariable()) {
                if (dkey.f == 2 && dkey.x == 36) {
                    req.dpiTracker = new DpiTracker(dkey.dpi, dkey.dpi.getNfields());
                }
                if (out == null) continue;
                out.f.format("%s %d %s (%s) %n", out.indent(), out.fldno++, dkey.name, dkey.getFxyName());
                continue;
            }
            StructureMembers.Member member = req.memberMap.get(dkey);
            if (member == null && dkey.subKeys != null) {
                member = req.memberMap.get(dkey.subKeys.get(0));
            }
            Preconditions.checkNotNull((Object)member);
            fldCounters[fldidx] = counter = new BitCounterCompressed(dkey, this.ndatasets, bitOffset);
            if (dkey.replication == 0) {
                reader.setBitOffset(bitOffset);
                int nestedNrows = (int)reader.bits2UInt(dkey.replicationCountSize);
                bitOffset += dkey.replicationCountSize;
                reader.bits2UInt(6);
                if (null != out) {
                    out.f.format("%s--sequence %s bitOffset=%d replication=%s %n", out.indent(), dkey.getFxyName(), bitOffset, nestedNrows);
                }
                bitOffset += 6;
                counter.addNestedCounters(nestedNrows);
                bitOffset = this.makeNestedSequence(reader, member, dkey, bitOffset, nestedNrows, req, counter, out);
                continue;
            }
            if (dkey.type == 3) {
                if (null != out) {
                    out.f.format("%s--structure %s bitOffset=%d replication=%s %n", out.indent(), dkey.getFxyName(), bitOffset, dkey.replication);
                }
                counter.addNestedCounters(dkey.replication);
                for (int nrow = 0; nrow < dkey.replication; ++nrow) {
                    BitCounterCompressed[] bitCounters = counter.getNestedCounters(nrow);
                    req.dpiRow = nrow;
                    int nestedOffset = member.getStructureMembers() == null ? posOffset + nrow * member.getArrayType().getSize() : posOffset + nrow * member.getStructureSize() + member.getOffset();
                    if (null != out) {
                        out.f.format("%n", new Object[0]);
                        out.indent.incr();
                        bitOffset = this.readData(reader, dkey, bitOffset, nestedOffset, req, bitCounters, out);
                        out.indent.decr();
                        continue;
                    }
                    bitOffset = this.readData(reader, dkey, bitOffset, nestedOffset, req, bitCounters, null);
                }
                continue;
            }
            reader.setBitOffset(bitOffset);
            if (dkey.type == 1) {
                int nc = dkey.bitWidth / 8;
                byte[] minValue = new byte[nc];
                for (int i = 0; i < nc; ++i) {
                    minValue[i] = (byte)reader.bits2UInt(8);
                }
                int dataWidth = (int)reader.bits2UInt(6);
                counter.setDataWidth(8 * dataWidth);
                int totalWidth = dkey.bitWidth + 6 + 8 * dataWidth * this.ndatasets;
                bitOffset += totalWidth;
                if (null != out) {
                    out.f.format("%s read %d %s (%s) bitWidth=%d defValue=%s dataWidth=%d n=%d bitOffset=%d %n", out.indent(), out.fldno++, dkey.name, dkey.getFxyName(), dkey.bitWidth, new String(minValue, StandardCharsets.UTF_8), dataWidth, this.ndatasets, bitOffset);
                }
                for (int dataset = 0; dataset < this.ndatasets; ++dataset) {
                    int i;
                    int pos = posOffset + req.getDatasetSize() * dataset + member.getOffset();
                    req.bb.position(pos);
                    if (dataWidth == 0) {
                        req.bb.put(minValue);
                        continue;
                    }
                    int nt = Math.min(nc, dataWidth);
                    byte[] incValue = new byte[nc];
                    for (i = 0; i < nt; ++i) {
                        incValue[i] = (byte)reader.bits2UInt(8);
                    }
                    for (i = nt; i < nc; ++i) {
                        incValue[i] = 0;
                    }
                    for (i = 0; i < nc; ++i) {
                        byte cval = incValue[i];
                        if (incValue[i] < 32 || incValue[i] > 126) {
                            cval = 0;
                        }
                        incValue[i] = cval;
                    }
                    req.bb.put(incValue);
                    if (out == null) continue;
                    out.f.format(" %s,", new String(incValue, StandardCharsets.UTF_8));
                }
                if (out == null) continue;
                out.f.format("%n", new Object[0]);
                continue;
            }
            int useBitWidth = dkey.bitWidth;
            boolean isDpi = dkey.f == 0 && dkey.x == 31 && dkey.y == 31;
            boolean isDpiField = false;
            if (dkey.f == 2 && dkey.x == 24 && dkey.y == 255) {
                isDpiField = true;
                DataDescriptor dpiDD = req.dpiTracker.getDpiDD(req.dpiRow);
                useBitWidth = dpiDD.bitWidth;
            }
            long dataMin = reader.bits2UInt(useBitWidth);
            int dataWidth = (int)reader.bits2UInt(6);
            if (dataWidth > useBitWidth && null != out) {
                out.f.format(" BAD WIDTH ", new Object[0]);
            }
            if (dkey.type == 1) {
                dataWidth *= 8;
            }
            counter.setDataWidth(dataWidth);
            int totalWidth = useBitWidth + 6 + dataWidth * this.ndatasets;
            bitOffset += totalWidth;
            if (null != out) {
                out.f.format("%s read %d, %s (%s) bitWidth=%d dataMin=%d (%f) dataWidth=%d n=%d bitOffset=%d %n", out.indent(), out.fldno++, dkey.name, dkey.getFxyName(), useBitWidth, dataMin, Float.valueOf(dkey.convert(dataMin)), dataWidth, this.ndatasets, bitOffset);
            }
            for (int dataset = 0; dataset < this.ndatasets; ++dataset) {
                long missingVal;
                long value = dataMin;
                if (dataWidth > 0) {
                    long cv = reader.bits2UInt(dataWidth);
                    value = BufrNumbers.isMissing(cv, dataWidth) ? BufrNumbers.missingValue(useBitWidth) : (value += cv);
                }
                if (dataWidth > useBitWidth && (value & (missingVal = BufrNumbers.missingValue(useBitWidth))) != value) {
                    value = missingVal;
                }
                int pos = posOffset + req.getDatasetSize() * dataset + member.getOffset();
                req.bb.position(pos);
                MessageArrayReaderUtils.putNumericData(dkey, req.bb, value);
                if (isDpi && dataset == 0) {
                    req.dpiTracker.setDpiValue(req.dpiRow, value);
                }
                if (out == null || dataWidth <= 0) continue;
                out.f.format(" %d (%f)", value, Float.valueOf(dkey.convert(value)));
            }
            if (out == null) continue;
            out.f.format("%n", new Object[0]);
        }
        return bitOffset;
    }

    private int makeNestedSequence(BitReader reader, StructureMembers.Member member, DataDescriptor seqdd, int bitOffset, int nestedNrows, Request req, BitCounterCompressed bitCounterNested, DebugOut out) throws IOException {
        Sequence seq = seqdd.refersTo;
        StructureMembers.Builder membersb = seq.makeStructureMembersBuilder();
        membersb.setStandardOffsets(false);
        StructureMembers nestedMembers = membersb.build();
        int nestedElements = this.ndatasets * nestedNrows;
        ByteBuffer nestedBB = ByteBuffer.allocate(nestedElements * nestedMembers.getStorageSizeBytes());
        nestedBB.order(ByteOrder.BIG_ENDIAN);
        StructureDataStorageBB nestedStorage = new StructureDataStorageBB(nestedMembers, nestedBB, nestedElements);
        nestedStorage.setStructuresOnHeap(false);
        HashMap<DataDescriptor, StructureMembers.Member> nestedMap = new HashMap<DataDescriptor, StructureMembers.Member>();
        MessageArrayReaderUtils.associateMessage2Members(nestedMembers, seqdd, nestedMap);
        Request nreq = new Request(nestedStorage, nestedBB, nestedMembers, member.getStructureSize() * nestedNrows, nestedMap);
        if (out != null) {
            out.indent.incr();
        }
        for (int nrow = 0; nrow < nestedNrows; ++nrow) {
            BitCounterCompressed[] bitCounters = bitCounterNested.getNestedCounters(nrow);
            nreq.dpiRow = nrow;
            int nestedOffset = nrow * member.getStructureSize();
            bitOffset = this.readData(reader, seqdd, bitOffset, nestedOffset, nreq, bitCounters, out);
        }
        if (out != null) {
            out.indent.decr();
        }
        int[] shape = new int[]{nestedElements};
        StructureDataArray nested = new StructureDataArray(nestedMembers, shape, (Storage)nestedStorage);
        int count = 0;
        for (int dataset = 0; dataset < this.ndatasets; ++dataset) {
            try {
                Section s = Section.builder().appendRange(new Range(count, count + nestedNrows - 1)).build();
                StructureDataArray nestedRow = (StructureDataArray)Arrays.section((Array)nested, (Section)s);
                int index = req.storageBB.putOnHeap((Object)nestedRow);
                int pos = dataset * req.getDatasetSize() + member.getOffset();
                req.bb.position(pos);
                req.bb.putInt(index);
                count += nestedNrows;
                continue;
            }
            catch (InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        }
        return bitOffset;
    }

    private static class DpiTracker {
        DataDescriptorTreeConstructor.DataPresentIndicator dpi;
        boolean[] isPresent;
        List<DataDescriptor> dpiDD;

        DpiTracker(DataDescriptorTreeConstructor.DataPresentIndicator dpi, int nPresentFlags) {
            this.dpi = dpi;
            this.isPresent = new boolean[nPresentFlags];
        }

        void setDpiValue(int fldidx, long value) {
            this.isPresent[fldidx] = value == 0L;
        }

        DataDescriptor getDpiDD(int fldPresentIndex) {
            if (this.dpiDD == null) {
                this.dpiDD = new ArrayList<DataDescriptor>();
                for (int i = 0; i < this.isPresent.length; ++i) {
                    if (!this.isPresent[i]) continue;
                    this.dpiDD.add(this.dpi.linear.get(i));
                }
            }
            return this.dpiDD.get(fldPresentIndex);
        }

        boolean isDpiDDs(DataDescriptor dkey) {
            return dkey.f == 2 && dkey.x == 24 && dkey.y == 255;
        }

        boolean isDpiField(DataDescriptor dkey) {
            return dkey.f == 2 && dkey.x == 24 && dkey.y == 255;
        }
    }

    private static class Request {
        final StructureDataStorageBB storageBB;
        final ByteBuffer bb;
        final StructureMembers members;
        final int datasetSize;
        final HashMap<DataDescriptor, StructureMembers.Member> memberMap;
        @Nullable
        DpiTracker dpiTracker;
        int dpiRow;

        Request(StructureDataStorageBB storageBB, ByteBuffer bb, StructureMembers members, int datasetSize, HashMap<DataDescriptor, StructureMembers.Member> memberMap) {
            this.storageBB = storageBB;
            this.bb = bb;
            this.members = members;
            this.datasetSize = datasetSize;
            this.memberMap = memberMap;
        }

        int getDatasetSize() {
            return this.datasetSize;
        }
    }
}

