/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.nio.ByteBuffer;
import java.util.HashMap;
import ucar.array.ArrayType;
import ucar.array.StructureMembers;
import ucar.nc2.iosp.bufr.DataDescriptor;

public class MessageArrayReaderUtils {
    static void associateMessage2Members(StructureMembers members, DataDescriptor parent, HashMap<DataDescriptor, StructureMembers.Member> map) {
        for (DataDescriptor dkey : parent.getSubKeys()) {
            if (dkey.name == null) {
                if (dkey.getSubKeys() == null) continue;
                MessageArrayReaderUtils.associateMessage2Members(members, dkey, map);
                continue;
            }
            StructureMembers.Member m = members.findMember(dkey.name);
            if (m != null) {
                map.put(dkey, m);
                if (m.getArrayType() != ArrayType.STRUCTURE || dkey.getSubKeys() == null) continue;
                MessageArrayReaderUtils.associateMessage2Members(m.getStructureMembers(), dkey, map);
                continue;
            }
            if (dkey.getSubKeys() == null) continue;
            MessageArrayReaderUtils.associateMessage2Members(members, dkey, map);
        }
    }

    static void putNumericData(DataDescriptor dkey, ByteBuffer bb, long value) {
        if (dkey.getByteWidthCDM() == 1) {
            bb.put((byte)value);
        } else if (dkey.getByteWidthCDM() == 2) {
            byte b1 = (byte)(value & 0xFFL);
            byte b2 = (byte)((value & 0xFF00L) >> 8);
            bb.put(b2);
            bb.put(b1);
        } else if (dkey.getByteWidthCDM() == 4) {
            byte b1 = (byte)(value & 0xFFL);
            byte b2 = (byte)((value & 0xFF00L) >> 8);
            byte b3 = (byte)((value & 0xFF0000L) >> 16);
            byte b4 = (byte)((value & 0xFFFFFFFFFF000000L) >> 24);
            bb.put(b4);
            bb.put(b3);
            bb.put(b2);
            bb.put(b1);
        } else {
            byte b1 = (byte)(value & 0xFFL);
            byte b2 = (byte)((value & 0xFF00L) >> 8);
            byte b3 = (byte)((value & 0xFF0000L) >> 16);
            byte b4 = (byte)((value & 0xFFFFFFFFFF000000L) >> 24);
            byte b5 = (byte)((value & 0xFF00000000L) >> 32);
            byte b6 = (byte)((value & 0xFF0000000000L) >> 40);
            byte b7 = (byte)((value & 0xFF000000000000L) >> 48);
            byte b8 = (byte)((value & 0xFF00000000000000L) >> 56);
            bb.put(b8);
            bb.put(b7);
            bb.put(b6);
            bb.put(b5);
            bb.put(b4);
            bb.put(b3);
            bb.put(b2);
            bb.put(b1);
        }
    }
}

