/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import ucar.array.Storage;
import ucar.array.StructureDataArray;
import ucar.array.StructureDataStorageBB;
import ucar.array.StructureMembers;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.iosp.BitReader;
import ucar.nc2.iosp.bufr.BitCounterUncompressed;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.DebugOut;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageArrayReaderUtils;
import ucar.unidata.io.RandomAccessFile;

class MessageArrayUncompressedReader {
    private static final boolean structuresOnHeap = false;
    private final Message message;
    private final RandomAccessFile raf;
    private final Formatter f;
    private final int nelems;
    private final ByteBuffer bbuffer;
    private final StructureMembers members;
    private final StructureDataStorageBB storageBB;
    private final boolean addTime = false;
    private final HashMap<DataDescriptor, StructureMembers.Member> topmap = new HashMap(100);

    MessageArrayUncompressedReader(Structure s, Message proto, Message m, RandomAccessFile raf, @Nullable Formatter f) {
        DataDescriptor.transferInfo(proto.getRootDataDescriptor().getSubKeys(), m.getRootDataDescriptor().getSubKeys());
        this.message = m;
        this.raf = raf;
        this.f = f;
        StructureMembers.Builder membersb = s.makeStructureMembersBuilder();
        membersb.setStandardOffsets(false);
        this.members = membersb.build();
        this.nelems = m.getNumberDatasets();
        this.bbuffer = ByteBuffer.allocate(this.nelems * this.members.getStorageSizeBytes()).order(ByteOrder.BIG_ENDIAN);
        this.storageBB = new StructureDataStorageBB(this.members, this.bbuffer, this.nelems);
        this.storageBB.setStructuresOnHeap(false);
        MessageArrayReaderUtils.associateMessage2Members(this.members, this.message.getRootDataDescriptor(), this.topmap);
    }

    StructureDataArray readEntireMessage() throws IOException {
        BitReader reader = new BitReader(this.raf, this.message.dataSection.getDataPos() + 4L);
        DataDescriptor root = this.message.getRootDataDescriptor();
        if (!root.isBad) {
            Request req = new Request(this.storageBB, this.bbuffer, this.topmap);
            this.message.counterDatasets = new BitCounterUncompressed[this.nelems];
            this.message.msg_nbits = 0;
            for (int row = 0; row < this.nelems; ++row) {
                if (this.f != null) {
                    this.f.format("Count bits in observation %d%n", row);
                }
                this.message.counterDatasets[row] = new BitCounterUncompressed(root, 1, 0);
                DebugOut out = this.f == null ? null : new DebugOut(this.f);
                req.setRow(row);
                this.readData(reader, this.message.counterDatasets[row], root.subKeys, row, req, out);
                this.message.msg_nbits += this.message.counterDatasets[row].countBits(this.message.msg_nbits);
            }
        } else {
            throw new RuntimeException("Bad root descriptor");
        }
        return new StructureDataArray(this.members, new int[]{this.nelems}, (Storage)this.storageBB);
    }

    private void readData(BitReader reader, BitCounterUncompressed table, List<DataDescriptor> dkeys, int row, Request req, @Nullable DebugOut out) throws IOException {
        for (DataDescriptor dkey : dkeys) {
            if (!dkey.isOkForVariable()) {
                if (out == null) continue;
                out.f.format("%s %d %s (%s) %n", out.indent(), out.fldno++, dkey.name, dkey.getFxyName());
                continue;
            }
            StructureMembers.Member member = req.memberMap.get(dkey);
            if (dkey.replication == 0) {
                int count = (int)reader.bits2UInt(dkey.replicationCountSize);
                if (out != null) {
                    out.f.format("%4d delayed replication count=%d %n", out.fldno++, count);
                }
                if (out != null && count > 0) {
                    out.f.format("%4d %s read sequence %s count= %d bitSize=%d start at=0x%x %n", out.fldno, out.indent(), dkey.getFxyName(), count, dkey.replicationCountSize, reader.getPos());
                }
                BitCounterUncompressed bitCounterNested = table.makeNested(dkey, count, 0, dkey.replicationCountSize);
                StructureDataArray seq = this.makeNestedSequence(reader, bitCounterNested, dkey, out);
                int expected = member.getOffset() + row * req.storageBB.getStructureSize();
                int pos = req.bb.position();
                int index = req.storageBB.putOnHeap((Object)seq);
                req.bb.putInt(index);
                continue;
            }
            if (dkey.type == 3) {
                BitCounterUncompressed nested = table.makeNested(dkey, dkey.replication, 0, 0);
                if (out != null) {
                    out.f.format("%4d %s read structure %s count= %d%n", out.fldno, out.indent(), dkey.getFxyName(), dkey.replication);
                }
                for (int nestedRow = 0; nestedRow < dkey.replication; ++nestedRow) {
                    if (out != null) {
                        out.f.format("%s read row %d (struct %s) %n", out.indent(), nestedRow, dkey.getFxyName());
                        out.indent.incr();
                        this.readData(reader, nested, dkey.subKeys, nestedRow, req, out);
                        out.indent.decr();
                        continue;
                    }
                    this.readData(reader, nested, dkey.subKeys, nestedRow, req, null);
                }
                continue;
            }
            if (dkey.type == 1) {
                byte[] vals = this.readCharData(dkey, reader, req);
                if (out == null) continue;
                String s = new String(vals, StandardCharsets.UTF_8);
                out.f.format("%4d %s read char %s (%s) width=%d end at= 0x%x val=<%s>%n", out.fldno++, out.indent(), dkey.getFxyName(), dkey.getName(), dkey.bitWidth, reader.getPos(), s);
                continue;
            }
            long value = reader.bits2UInt(dkey.bitWidth);
            int expected = member.getOffset();
            int pos = req.bb.position();
            MessageArrayReaderUtils.putNumericData(dkey, req.bb, value);
            if (out == null) continue;
            out.f.format("%4d %s read %s (%s %s) bitWidth=%d end at= 0x%x raw=%d convert=%f row=%d position=%d expected=%d%n", out.fldno++, out.indent(), dkey.getFxyName(), dkey.getName(), dkey.getUnits(), dkey.bitWidth, reader.getPos(), value, Float.valueOf(dkey.convert(value)), row, pos, expected);
        }
    }

    private byte[] readCharData(DataDescriptor dkey, BitReader reader, Request req) throws IOException {
        int i;
        int nchars = dkey.getByteWidthCDM();
        byte[] b = new byte[nchars];
        for (i = 0; i < nchars; ++i) {
            b[i] = (byte)reader.bits2UInt(8);
        }
        for (i = 0; i < nchars; ++i) {
            req.bb.put(b[i]);
        }
        return b;
    }

    private StructureDataArray makeNestedSequence(BitReader reader, BitCounterUncompressed bitCounterNested, DataDescriptor seqdd, DebugOut out) throws IOException {
        int nestedNrows = bitCounterNested.getNumberRows();
        Sequence seq = seqdd.refersTo;
        Preconditions.checkNotNull((Object)seq);
        StructureMembers.Builder membersb = seq.makeStructureMembersBuilder();
        membersb.setStandardOffsets(false);
        StructureMembers nestedMembers = membersb.build();
        ByteBuffer nestedBB = ByteBuffer.allocate(nestedNrows * nestedMembers.getStorageSizeBytes()).order(ByteOrder.BIG_ENDIAN);
        StructureDataStorageBB nestedStorage = new StructureDataStorageBB(nestedMembers, nestedBB, nestedNrows);
        nestedStorage.setStructuresOnHeap(false);
        HashMap<DataDescriptor, StructureMembers.Member> nestedMap = new HashMap<DataDescriptor, StructureMembers.Member>();
        MessageArrayReaderUtils.associateMessage2Members(nestedMembers, seqdd, nestedMap);
        Request reqNested = new Request(nestedStorage, nestedBB, nestedMap);
        for (int i = 0; i < nestedNrows; ++i) {
            if (out != null) {
                out.f.format("%s read row %d (seq %s) %n", out.indent(), i, seqdd.getFxyName());
                out.indent.incr();
                this.readData(reader, bitCounterNested, seqdd.getSubKeys(), i, reqNested, out);
                out.indent.decr();
                continue;
            }
            this.readData(reader, bitCounterNested, seqdd.getSubKeys(), i, reqNested, null);
        }
        int[] shape = new int[]{nestedNrows};
        return new StructureDataArray(nestedMembers, shape, (Storage)nestedStorage);
    }

    private static class Request {
        final StructureDataStorageBB storageBB;
        final ByteBuffer bb;
        final HashMap<DataDescriptor, StructureMembers.Member> memberMap;
        int row = 0;

        Request(StructureDataStorageBB storageBB, ByteBuffer bb, HashMap<DataDescriptor, StructureMembers.Member> memberMap) {
            this.storageBB = storageBB;
            this.bb = bb;
            this.memberMap = memberMap;
        }

        Request setRow(int row) {
            this.row = row;
            return this;
        }
    }
}

