/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.internal.wmo.CommonCodeTable;
import ucar.nc2.iosp.bufr.Descriptor;

public class CodeFlagTables {
    private static Logger log = LoggerFactory.getLogger(CodeFlagTables.class);
    private static final String CodeFlagFilename = "wmo/BUFRCREX_32_0_0_CodeFlag_en.xml";
    static Map<Short, CodeFlagTables> tableMap;
    private short fxy;
    private String name;
    private Map<Integer, String> map;

    public static CodeFlagTables getTable(short id) {
        if (tableMap == null) {
            CodeFlagTables.init();
        }
        if (id == 263) {
            return CodeFlagTables.useCC(id, 5);
        }
        if (id == 526) {
            return CodeFlagTables.useCC(id, 7);
        }
        if (id == 531) {
            return CodeFlagTables.useCC(id, 8);
        }
        if (id == 5699) {
            return CodeFlagTables.useCC(id, 3);
        }
        if (id == 5700) {
            return CodeFlagTables.useCC(id, 4);
        }
        return tableMap.get(id);
    }

    private static CodeFlagTables useCC(short fxy, int cc) {
        CodeFlagTables cft = tableMap.get(fxy);
        if (cft == null) {
            CommonCodeTable cct = CommonCodeTable.getTable((int)cc);
            cft = new CodeFlagTables(fxy, cct.getTableName(), cct.getMap());
            tableMap.put(fxy, cft);
        }
        return cft;
    }

    public static boolean hasTable(short id) {
        CodeFlagTables result;
        if (tableMap == null) {
            CodeFlagTables.init();
        }
        return (result = tableMap.get(id)) != null;
    }

    private static void init() {
        tableMap = new HashMap<Short, CodeFlagTables>(300);
        CodeFlagTables.init(tableMap);
    }

    public static Map<Short, CodeFlagTables> getTables() {
        if (tableMap == null) {
            CodeFlagTables.init();
        }
        return tableMap;
    }

    static void init(Map<Short, CodeFlagTables> table) {
        String filename = "/resources/bufrTables/wmo/BUFRCREX_32_0_0_CodeFlag_en.xml";
        try (InputStream is = CodeFlagTables.class.getResourceAsStream(filename);){
            SAXBuilder builder = new SAXBuilder();
            Document tdoc = builder.build(is);
            Element root = tdoc.getRootElement();
            List elems = root.getChildren();
            for (Element elem : elems) {
                int code;
                String fxyS = elem.getChildText("FXY");
                String desc = elem.getChildText("ElementName_en");
                short fxy = Descriptor.getFxy2(fxyS);
                CodeFlagTables ct = table.get(fxy);
                if (ct == null) {
                    ct = new CodeFlagTables(fxy, desc);
                    table.put(fxy, ct);
                }
                String line = elem.getChildText("No");
                String codeS = elem.getChildText("CodeFigure");
                String value = elem.getChildText("EntryName_en");
                if (codeS == null || value == null || value.toLowerCase().startsWith("reserved") || value.toLowerCase().startsWith("not used")) continue;
                if (codeS.toLowerCase().contains("all")) {
                    code = -1;
                } else {
                    try {
                        code = Integer.parseInt(codeS);
                    }
                    catch (NumberFormatException e) {
                        log.debug("NumberFormatException on line " + line + " in " + codeS);
                        continue;
                    }
                }
                ct.addValue((short)code, value);
            }
        }
        catch (IOException | JDOMException e) {
            log.error("Can't read BUFR code table " + filename, e);
        }
    }

    CodeFlagTables(short fxy, String name) {
        this.fxy = fxy;
        this.name = name == null ? this.fxy() : name;
        this.map = new HashMap<Integer, String>(20);
    }

    private CodeFlagTables(short fxy, String name, Map<Integer, String> map) {
        this.fxy = fxy;
        this.name = name == null ? this.fxy() : name;
        this.map = map;
    }

    public String getName() {
        return this.name;
    }

    public Map<Integer, String> getMap() {
        return this.map;
    }

    void addValue(int value, String text) {
        this.map.put(value, text);
    }

    public short getId() {
        return this.fxy;
    }

    public String fxy() {
        int f = this.fxy >> 14;
        int x = (this.fxy & 0xFF00) >> 8;
        int y = this.fxy & 0xFF;
        return f + "-" + x + "-" + y;
    }

    public String toString() {
        return this.name;
    }
}

