/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.util.Misc;
import ucar.unidata.io.RandomAccessFile;

public class BTree2 {
    private boolean debugBtree2;
    private boolean debugPos;
    private PrintStream debugOut = System.out;
    byte btreeType;
    private int nodeSize;
    private short recordSize;
    private String owner;
    private H5header h5;
    private RandomAccessFile raf;
    List<Entry2> entryList = new ArrayList<Entry2>();

    BTree2(H5header h5, String owner, long address) throws IOException {
        this.h5 = h5;
        this.raf = h5.raf;
        this.owner = owner;
        this.raf.seek(h5.getFileOffset(address));
        byte[] heapname = new byte[4];
        this.raf.readFully(heapname);
        String magic = new String(heapname, StandardCharsets.UTF_8);
        if (!magic.equals("BTHD")) {
            throw new IllegalStateException(magic + " should equal BTHD");
        }
        byte version = this.raf.readByte();
        this.btreeType = this.raf.readByte();
        this.nodeSize = this.raf.readInt();
        this.recordSize = this.raf.readShort();
        short treeDepth = this.raf.readShort();
        byte split = this.raf.readByte();
        byte merge = this.raf.readByte();
        long rootNodeAddress = h5.readOffset();
        short numRecordsRootNode = this.raf.readShort();
        long totalRecords = h5.readLength();
        int checksum = this.raf.readInt();
        if (this.debugBtree2) {
            this.debugOut.printf("BTree2 (%s) version=%d type=%d treeDepth=%d nodeSize=%d recordSize=%d numRecordsRootNode=%d totalRecords=%d rootNodeAddress=%d%n", owner, version, this.btreeType, treeDepth, this.nodeSize, this.recordSize, numRecordsRootNode, totalRecords, rootNodeAddress);
        }
        if (treeDepth > 0) {
            InternalNode node = new InternalNode(rootNodeAddress, numRecordsRootNode, this.recordSize, treeDepth);
            node.recurse();
        } else {
            LeafNode leaf = new LeafNode(rootNodeAddress, numRecordsRootNode);
            leaf.addEntries(this.entryList);
        }
    }

    Record1 getEntry1(int hugeObjectID) {
        for (Entry2 entry : this.entryList) {
            Record1 record1 = (Record1)entry.record;
            if (record1.hugeObjectID != (long)hugeObjectID) continue;
            return record1;
        }
        return null;
    }

    Object readRecord(int type) throws IOException {
        switch (type) {
            case 1: {
                return new Record1();
            }
            case 2: {
                return new Record2();
            }
            case 3: {
                return new Record3();
            }
            case 4: {
                return new Record4();
            }
            case 5: {
                return new Record5();
            }
            case 6: {
                return new Record6();
            }
            case 7: {
                return new Record70();
            }
            case 8: {
                return new Record8();
            }
            case 9: {
                return new Record9();
            }
        }
        throw new IllegalStateException();
    }

    class Record9 {
        byte flags;
        int creationOrder;
        byte[] heapId = new byte[8];

        Record9() throws IOException {
            BTree2.this.raf.readFully(this.heapId);
            this.flags = BTree2.this.raf.readByte();
            this.creationOrder = BTree2.this.raf.readInt();
        }
    }

    class Record8 {
        byte flags;
        int creationOrder;
        int nameHash;
        byte[] heapId = new byte[8];

        Record8() throws IOException {
            BTree2.this.raf.readFully(this.heapId);
            this.flags = BTree2.this.raf.readByte();
            this.creationOrder = BTree2.this.raf.readInt();
            this.nameHash = BTree2.this.raf.readInt();
            if (BTree2.this.debugBtree2) {
                BTree2.this.debugOut.println("  record8 creationOrder=" + this.creationOrder + " heapId=" + Misc.showBytes(this.heapId));
            }
        }
    }

    class Record71 {
        byte location;
        byte messtype;
        short index;
        long address;

        Record71() throws IOException {
            this.location = BTree2.this.raf.readByte();
            BTree2.this.raf.readByte();
            this.messtype = BTree2.this.raf.readByte();
            this.index = BTree2.this.raf.readShort();
            this.address = BTree2.this.h5.readOffset();
        }
    }

    class Record70 {
        byte location;
        int refCount;
        byte[] id = new byte[8];

        Record70() throws IOException {
            this.location = BTree2.this.raf.readByte();
            this.refCount = BTree2.this.raf.readInt();
            BTree2.this.raf.readFully(this.id);
        }
    }

    class Record6 {
        long creationOrder;
        byte[] heapId = new byte[7];

        Record6() throws IOException {
            this.creationOrder = BTree2.this.raf.readLong();
            BTree2.this.raf.readFully(this.heapId);
            if (BTree2.this.debugBtree2) {
                BTree2.this.debugOut.println("  record6 creationOrder=" + this.creationOrder + " heapId=" + Misc.showBytes(this.heapId));
            }
        }
    }

    class Record5 {
        int nameHash;
        byte[] heapId = new byte[7];

        Record5() throws IOException {
            this.nameHash = BTree2.this.raf.readInt();
            BTree2.this.raf.readFully(this.heapId);
            if (BTree2.this.debugBtree2) {
                BTree2.this.debugOut.println("  record5 nameHash=" + this.nameHash + " heapId=" + Misc.showBytes(this.heapId));
            }
        }
    }

    class Record4 {
        long hugeObjectAddress;
        long hugeObjectLength;
        long hugeObjectID;
        long hugeObjectSize;
        int filterMask;

        Record4() throws IOException {
            this.hugeObjectAddress = BTree2.this.h5.readOffset();
            this.hugeObjectLength = BTree2.this.h5.readLength();
            this.filterMask = BTree2.this.raf.readInt();
            this.hugeObjectSize = BTree2.this.h5.readLength();
        }
    }

    class Record3 {
        long hugeObjectAddress;
        long hugeObjectLength;

        Record3() throws IOException {
            this.hugeObjectAddress = BTree2.this.h5.readOffset();
            this.hugeObjectLength = BTree2.this.h5.readLength();
        }
    }

    class Record2 {
        long hugeObjectAddress;
        long hugeObjectLength;
        long hugeObjectID;
        long hugeObjectSize;
        int filterMask;

        Record2() throws IOException {
            this.hugeObjectAddress = BTree2.this.h5.readOffset();
            this.hugeObjectLength = BTree2.this.h5.readLength();
            this.filterMask = BTree2.this.raf.readInt();
            this.hugeObjectSize = BTree2.this.h5.readLength();
            this.hugeObjectID = BTree2.this.h5.readLength();
        }
    }

    class Record1 {
        long hugeObjectAddress;
        long hugeObjectLength;
        long hugeObjectID;

        Record1() throws IOException {
            this.hugeObjectAddress = BTree2.this.h5.readOffset();
            this.hugeObjectLength = BTree2.this.h5.readLength();
            this.hugeObjectID = BTree2.this.h5.readLength();
        }
    }

    class LeafNode {
        Entry2[] entries;

        LeafNode(long address, short nrecords) throws IOException {
            BTree2.this.raf.seek(BTree2.this.h5.getFileOffset(address));
            if (BTree2.this.debugPos) {
                BTree2.this.debugOut.println("--Btree2 InternalNode position=" + BTree2.this.raf.getFilePointer());
            }
            byte[] sig = new byte[4];
            BTree2.this.raf.readFully(sig);
            String magic = new String(sig, StandardCharsets.UTF_8);
            if (!magic.equals("BTLF")) {
                throw new IllegalStateException(magic + " should equal BTLF");
            }
            byte version = BTree2.this.raf.readByte();
            byte nodeType = BTree2.this.raf.readByte();
            if (nodeType != BTree2.this.btreeType) {
                throw new IllegalStateException();
            }
            if (BTree2.this.debugBtree2) {
                BTree2.this.debugOut.println("   BTree2 LeafNode version=" + version + " type=" + nodeType + " nrecords=" + nrecords);
            }
            this.entries = new Entry2[nrecords];
            for (int i = 0; i < nrecords; ++i) {
                this.entries[i] = new Entry2();
                this.entries[i].record = BTree2.this.readRecord(BTree2.this.btreeType);
            }
            BTree2.this.raf.readInt();
        }

        void addEntries(List<Entry2> list) {
            Collections.addAll(list, this.entries);
        }
    }

    class InternalNode {
        Entry2[] entries;
        int depth;

        InternalNode(long address, short nrecords, short recordSize, int depth) throws IOException {
            this.depth = depth;
            BTree2.this.raf.seek(BTree2.this.h5.getFileOffset(address));
            if (BTree2.this.debugPos) {
                BTree2.this.debugOut.println("--Btree2 InternalNode position=" + BTree2.this.raf.getFilePointer());
            }
            byte[] sig = new byte[4];
            BTree2.this.raf.readFully(sig);
            String magic = new String(sig, StandardCharsets.UTF_8);
            if (!magic.equals("BTIN")) {
                throw new IllegalStateException(magic + " should equal BTIN");
            }
            byte version = BTree2.this.raf.readByte();
            byte nodeType = BTree2.this.raf.readByte();
            if (nodeType != BTree2.this.btreeType) {
                throw new IllegalStateException();
            }
            if (BTree2.this.debugBtree2) {
                BTree2.this.debugOut.println("   BTree2 InternalNode version=" + version + " type=" + nodeType + " nrecords=" + nrecords);
            }
            this.entries = new Entry2[nrecords + 1];
            for (int i = 0; i < nrecords; ++i) {
                this.entries[i] = new Entry2();
                this.entries[i].record = BTree2.this.readRecord(BTree2.this.btreeType);
            }
            this.entries[nrecords] = new Entry2();
            int maxNumRecords = BTree2.this.nodeSize / recordSize;
            int maxNumRecordsPlusDesc = BTree2.this.nodeSize / recordSize;
            for (int i = 0; i < nrecords + 1; ++i) {
                Entry2 e = this.entries[i];
                e.childAddress = BTree2.this.h5.readOffset();
                e.nrecords = BTree2.this.h5.readVariableSizeUnsigned(1);
                if (depth > 1) {
                    e.totNrecords = BTree2.this.h5.readVariableSizeUnsigned(2);
                }
                if (!BTree2.this.debugBtree2) continue;
                BTree2.this.debugOut.println(" BTree2 entry childAddress=" + e.childAddress + " nrecords=" + e.nrecords + " totNrecords=" + e.totNrecords);
            }
            BTree2.this.raf.readInt();
        }

        void recurse() throws IOException {
            for (Entry2 e : this.entries) {
                if (this.depth > 1) {
                    InternalNode node = new InternalNode(e.childAddress, (short)e.nrecords, BTree2.this.recordSize, this.depth - 1);
                    node.recurse();
                } else {
                    long nrecs = e.nrecords;
                    LeafNode leaf = new LeafNode(e.childAddress, (short)nrecs);
                    leaf.addEntries(BTree2.this.entryList);
                }
                if (e.record == null) continue;
                BTree2.this.entryList.add(e);
            }
        }
    }

    static class Entry2 {
        long childAddress;
        long nrecords;
        long totNrecords;
        Object record;

        Entry2() {
        }
    }
}

