/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.iosp.netcdf3.N3streamWriter;

public class N3channelWriter
extends N3streamWriter {
    private static int buffer_size = 1000000;
    private static boolean debugWrite;
    private ByteBuffer padddingBB;

    public N3channelWriter(NetcdfFile ncfile) {
        super(ncfile);
    }

    public void writeDataAll(WritableByteChannel channel) throws IOException, InvalidRangeException {
        for (N3streamWriter.Vinfo vinfo : this.vinfoList) {
            if (vinfo.isRecord) continue;
            Variable v = vinfo.v;
            int nbytes = (int)v.readToByteChannel(v.getShapeAsSection(), channel);
            this.filePos += (long)nbytes;
            this.filePos += (long)this.pad(channel, nbytes);
            if (!this.debugPos) continue;
            System.out.printf(" read=%d vinfo=%s%n", nbytes, vinfo);
        }
        boolean useRecordDimension = this.ncfile.hasUnlimitedDimension();
        if (useRecordDimension) {
            this.ncfile.sendIospMessage("AddRecordStructure");
            Structure recordVar = (Structure)this.ncfile.findVariable("record");
            Section section = new Section().appendRange(null);
            long bytesDone = 0L;
            long done = 0L;
            long nrecs = (int)recordVar.getSize();
            int structureSize = recordVar.getElementSize();
            int readAtaTime = Math.max(10, buffer_size / structureSize);
            int count = 0;
            while ((long)count < nrecs) {
                long last = Math.min(nrecs, done + (long)readAtaTime);
                int need = (int)(last - done);
                section.setRange(0, new Range(count, count + need - 1));
                try {
                    bytesDone += recordVar.readToByteChannel(section, channel);
                    done += (long)need;
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                    break;
                }
                count += readAtaTime;
            }
            assert (done == nrecs);
            bytesDone /= 1000000L;
            if (debugWrite) {
                System.out.println("write record var; total = " + bytesDone + " Mbytes # recs=" + done);
            }
            this.ncfile.sendIospMessage("RemoveRecordStructure");
            this.ncfile.finish();
        }
    }

    private int pad(WritableByteChannel channel, int nbytes) throws IOException {
        int pad = N3header.padding(nbytes);
        if (null != channel && pad > 0) {
            if (this.padddingBB == null) {
                this.padddingBB = ByteBuffer.allocate(4);
            }
            this.padddingBB.position(0);
            this.padddingBB.limit(pad);
            channel.write(this.padddingBB);
        }
        return pad;
    }

    public static void writeFromFile(NetcdfFile fileIn, String fileOutName) throws IOException, InvalidRangeException {
        try (FileOutputStream stream = new FileOutputStream(fileOutName);
             FileChannel channel = stream.getChannel();
             DataOutputStream dout = new DataOutputStream(Channels.newOutputStream(channel));){
            N3channelWriter writer = new N3channelWriter(fileIn);
            int numrec = fileIn.getUnlimitedDimension() == null ? 0 : fileIn.getUnlimitedDimension().getLength();
            writer.writeHeader(dout, numrec);
            dout.flush();
            writer.writeDataAll(channel);
        }
    }

    public static void writeToChannel(NetcdfFile ncfile, WritableByteChannel wbc) throws IOException, InvalidRangeException {
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(Channels.newOutputStream(wbc), 8000));){
            N3channelWriter writer = new N3channelWriter(ncfile);
            int numrec = ncfile.getUnlimitedDimension() == null ? 0 : ncfile.getUnlimitedDimension().getLength();
            writer.writeHeader(stream, numrec);
            stream.flush();
            writer.writeDataAll(wbc);
        }
    }
}

