/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.iosp.netcdf3.N3iosp;

public abstract class N3streamWriter {
    protected NetcdfFile ncfile;
    protected Map<Variable, Vinfo> vinfoMap = new HashMap<Variable, Vinfo>();
    protected List<Vinfo> vinfoList = new ArrayList<Vinfo>();
    protected boolean debug;
    protected boolean debugPos = true;
    protected boolean debugWriteData;
    protected int recStart;
    protected int recSize;
    protected boolean usePadding = true;
    protected long filePos;

    protected N3streamWriter(NetcdfFile ncfile) {
        this.ncfile = ncfile;
    }

    public void writeHeader(DataOutputStream stream, int numrec) throws IOException {
        Vinfo vinfo;
        Variable var;
        int dataStart;
        List<Variable> vars;
        int nvars;
        this.ncfile.finish();
        stream.write(N3header.MAGIC);
        int count = N3header.MAGIC.length;
        Dimension udim = this.ncfile.getUnlimitedDimension();
        if (numrec < 0) {
            numrec = udim == null ? 0 : -1;
        }
        stream.writeInt(numrec);
        count += 4;
        List<Dimension> dims = this.ncfile.getDimensions();
        int numdims = dims.size();
        if (numdims == 0) {
            stream.writeInt(0);
            stream.writeInt(0);
        } else {
            stream.writeInt(10);
            stream.writeInt(numdims);
        }
        count += 8;
        for (Dimension o : dims) {
            Dimension dim = o;
            count += this.writeString(stream, N3iosp.makeValidNetcdfObjectName(dim.getShortName()));
            stream.writeInt(dim.isUnlimited() ? 0 : dim.getLength());
            count += 4;
        }
        count += this.writeAtts(stream, this.ncfile.getGlobalAttributes());
        if (this.debug) {
            System.out.println("vars header starts at " + count);
        }
        if ((nvars = (vars = this.ncfile.getVariables()).size()) == 0) {
            stream.writeInt(0);
            stream.writeInt(0);
        } else {
            stream.writeInt(11);
            stream.writeInt(nvars);
        }
        count += 8;
        for (Variable item : vars) {
            Variable var2 = item;
            if (var2 instanceof Structure) continue;
            Vinfo vinfo2 = this.writeVar(null, var2, 0);
            count += vinfo2.hsize;
        }
        int offset = dataStart = count;
        if (this.debug) {
            System.out.println(" non-record vars start at " + dataStart);
        }
        for (Variable value : vars) {
            var = value;
            if (var.isUnlimited()) continue;
            vinfo = this.writeVar(stream, var, offset);
            this.vinfoMap.put(var, vinfo);
            if (this.debugPos) {
                System.out.println(" " + var.getNameAndDimensions() + " begin at = " + offset + " end=" + (offset + vinfo.vsize));
            }
            offset += vinfo.vsize;
            this.vinfoList.add(vinfo);
        }
        if (this.debug) {
            System.out.println(" record vars start at " + offset);
        }
        this.recStart = offset;
        this.recSize = 0;
        for (Variable variable : vars) {
            var = variable;
            if (!var.isUnlimited() || var instanceof Structure) continue;
            vinfo = this.writeVar(stream, var, offset);
            this.vinfoMap.put(var, vinfo);
            if (this.debugPos) {
                System.out.println(" " + var.getNameAndDimensions() + "(record) begin at = " + offset + " end=" + (offset + vinfo.vsize) + " size=" + vinfo.vsize);
            }
            offset += vinfo.vsize;
            this.recSize += vinfo.vsize;
            this.vinfoList.add(vinfo);
        }
        this.filePos = count;
        if (this.debugPos) {
            System.out.println("header written filePos= " + this.filePos + " recsize= " + this.recSize);
        }
    }

    private Vinfo writeVar(DataOutputStream stream, Variable var, int offset) throws IOException {
        int hsize = 0;
        hsize += this.writeString(stream, N3iosp.makeValidNetcdfObjectName(var.getShortName()));
        int vsize = var.getDataType().getSize();
        List<Dimension> dims = var.getDimensions();
        if (null != stream) {
            stream.writeInt(dims.size());
        }
        hsize += 4;
        for (Dimension dim : dims) {
            int dimIndex = this.findDimensionIndex(dim);
            if (null != stream) {
                stream.writeInt(dimIndex);
            }
            hsize += 4;
            if (dim.isUnlimited()) continue;
            vsize *= dim.getLength();
        }
        int pad = this.usePadding ? N3header.padding(vsize) : 0;
        vsize += pad;
        hsize += this.writeAtts(stream, var.getAttributes());
        int type = N3header.getType(var.getDataType());
        if (null != stream) {
            stream.writeInt(type);
            stream.writeInt(vsize);
            stream.writeInt(offset);
        }
        return new Vinfo(var, hsize += 12, vsize, offset, pad, var.isUnlimited());
    }

    private int writeAtts(DataOutputStream stream, List<Attribute> atts) throws IOException {
        int natts = atts.size();
        if (null != stream) {
            if (natts == 0) {
                stream.writeInt(0);
                stream.writeInt(0);
            } else {
                stream.writeInt(12);
                stream.writeInt(natts);
            }
        }
        int hsize = 8;
        for (Attribute att : atts) {
            hsize += this.writeString(stream, N3iosp.makeValidNetcdfObjectName(att.getShortName()));
            int type = N3header.getType(att.getDataType());
            if (null != stream) {
                stream.writeInt(type);
            }
            hsize += 4;
            if (type == 2) {
                hsize += this.writeStringValues(stream, att);
                continue;
            }
            int nelems = att.getLength();
            if (null != stream) {
                stream.writeInt(nelems);
            }
            hsize += 4;
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.writeAttributeValue(stream, att.getNumericValue(j));
            }
            hsize += nbytes;
            hsize += this.pad(stream, nbytes, (byte)0);
        }
        return hsize;
    }

    private int writeStringValues(DataOutputStream stream, Attribute att) throws IOException {
        int n = att.getLength();
        if (n == 1) {
            return this.writeString(stream, att.getStringValue());
        }
        StringBuilder values = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            values.append(att.getStringValue(i));
        }
        return this.writeString(stream, values.toString());
    }

    private int writeAttributeValue(DataOutputStream stream, Number numValue) throws IOException {
        if (numValue instanceof Byte) {
            if (null != stream) {
                stream.write(numValue.byteValue());
            }
            return 1;
        }
        if (numValue instanceof Short) {
            if (null != stream) {
                stream.writeShort(numValue.shortValue());
            }
            return 2;
        }
        if (numValue instanceof Integer) {
            if (null != stream) {
                stream.writeInt(numValue.intValue());
            }
            return 4;
        }
        if (numValue instanceof Float) {
            if (null != stream) {
                stream.writeFloat(numValue.floatValue());
            }
            return 4;
        }
        if (numValue instanceof Double) {
            if (null != stream) {
                stream.writeDouble(numValue.doubleValue());
            }
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private int writeString(DataOutputStream stream, String s) throws IOException {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        if (null != stream) {
            stream.writeInt(b.length);
            stream.write(b);
        }
        int n = this.pad(stream, b.length, (byte)0);
        return n + 4 + b.length;
    }

    private int findDimensionIndex(Dimension wantDim) {
        List<Dimension> dims = this.ncfile.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (!dim.equals(wantDim)) continue;
            return i;
        }
        throw new IllegalStateException("unknown Dimension == " + wantDim);
    }

    protected int pad(DataOutputStream stream, int nbytes, byte fill) throws IOException {
        int pad = N3header.padding(nbytes);
        if (null != stream) {
            for (int i = 0; i < pad; ++i) {
                stream.write(fill);
            }
        }
        return pad;
    }

    protected static class Vinfo {
        Variable v;
        int hsize;
        int vsize;
        int offset;
        int pad;
        boolean isRecord;

        Vinfo(Variable v, int hsize, int vsize, int offset, int pad, boolean isRecord) {
            this.v = v;
            this.hsize = hsize;
            this.vsize = vsize;
            this.offset = offset;
            this.pad = pad;
            this.isRecord = isRecord;
        }

        public String toString() {
            return this.v.getFullName() + " vsize= " + this.vsize + " pad=" + this.pad;
        }
    }
}

