/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.Arrays;
import javax.annotation.Nonnull;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.Misc;
import ucar.nc2.util.Optional;

class CoordAxisHelper {
    private final CoverageCoordAxis1D axis;

    CoordAxisHelper(CoverageCoordAxis1D axis) {
        this.axis = axis;
    }

    int findCoordElement(double[] target, boolean bounded) {
        switch (this.axis.getSpacing()) {
            case regularInterval: {
                return this.findCoordElementRegular((target[0] + target[1]) / 2.0, bounded);
            }
            case contiguousInterval: {
                return this.findCoordElementContiguous((target[0] + target[1]) / 2.0, bounded);
            }
            case discontiguousInterval: {
                return this.findCoordElementDiscontiguousInterval(target, bounded);
            }
        }
        throw new IllegalStateException("unknown spacing" + (Object)((Object)this.axis.getSpacing()));
    }

    int findCoordElement(double target, boolean bounded) {
        switch (this.axis.getSpacing()) {
            case regularInterval: 
            case regularPoint: {
                return this.findCoordElementRegular(target, bounded);
            }
            case contiguousInterval: 
            case irregularPoint: {
                return this.findCoordElementContiguous(target, bounded);
            }
            case discontiguousInterval: {
                return this.findCoordElementDiscontiguousInterval(target, bounded);
            }
        }
        throw new IllegalStateException("unknown spacing" + (Object)((Object)this.axis.getSpacing()));
    }

    private int findCoordElementRegular(double coordValue, boolean bounded) {
        int n = this.axis.getNcoords();
        if (n == 1 && bounded) {
            return 0;
        }
        double distance = coordValue - this.axis.getCoordEdge1(0);
        double exactNumSteps = distance / this.axis.getResolution();
        int index = (int)exactNumSteps;
        if (bounded && index < 0) {
            return 0;
        }
        if (bounded && index >= n) {
            return n - 1;
        }
        if (index >= 0 && index < n) {
            double lower = this.axis.getCoordEdge1(index);
            double upper = this.axis.getCoordEdge2(index);
            if (this.axis.isAscending()) {
                assert (lower <= coordValue) : lower + " should be le " + coordValue;
                assert (upper >= coordValue) : upper + " should be ge " + coordValue;
            } else {
                assert (lower >= coordValue) : lower + " should be ge " + coordValue;
                assert (upper <= coordValue) : upper + " should be le " + coordValue;
            }
        }
        return index;
    }

    private int findCoordElementContiguous(double target, boolean bounded) {
        int n = this.axis.getNcoords();
        int low = 0;
        int high = n - 1;
        if (this.axis.isAscending()) {
            if (target < this.axis.getCoordEdge1(0)) {
                return bounded ? 0 : -1;
            }
            if (target > this.axis.getCoordEdgeLast()) {
                return bounded ? n - 1 : n;
            }
            while (high > low + 1) {
                int mid = (low + high) / 2;
                if (this.contains(target, mid, true)) {
                    return mid;
                }
                if (this.axis.getCoordEdge2(mid) < target) {
                    low = mid;
                    continue;
                }
                high = mid;
            }
            return this.contains(target, low, true) ? low : high;
        }
        if (target > this.axis.getCoordEdge1(0)) {
            return bounded ? 0 : -1;
        }
        if (target < this.axis.getCoordEdgeLast()) {
            return bounded ? n - 1 : n;
        }
        while (high > low + 1) {
            int mid = (low + high) / 2;
            if (this.contains(target, mid, false)) {
                return mid;
            }
            if (this.axis.getCoordEdge2(mid) < target) {
                high = mid;
                continue;
            }
            low = mid;
        }
        return this.contains(target, low, false) ? low : high;
    }

    private boolean contains(double target, int coordIdx, boolean ascending) {
        double midVal1 = this.axis.getCoordEdge1(coordIdx);
        double midVal2 = this.axis.getCoordEdge2(coordIdx);
        if (ascending) {
            return midVal1 <= target && target <= midVal2;
        }
        return midVal1 >= target && target >= midVal2;
    }

    private boolean contains(double target, int coordIdx) {
        double midVal2;
        double midVal1 = this.axis.getCoordEdge1(coordIdx);
        if (midVal1 < (midVal2 = this.axis.getCoordEdge2(coordIdx))) {
            return midVal1 <= target && target <= midVal2;
        }
        return midVal1 >= target && target >= midVal2;
    }

    private int findCoordElementDiscontiguousInterval(double target, boolean bounded) {
        int idx = this.findSingleHit(target);
        if (idx >= 0) {
            return idx;
        }
        if (idx == -1) {
            return -1;
        }
        return this.findClosest(target);
    }

    private int findCoordElementDiscontiguousInterval(double[] target, boolean bounded) {
        for (int i = 0; i < this.axis.getNcoords(); ++i) {
            double edge1 = this.axis.getCoordEdge1(i);
            double edge2 = this.axis.getCoordEdge2(i);
            if (!Misc.nearlyEquals(edge1, target[0]) || !Misc.nearlyEquals(edge2, target[1])) continue;
            return i;
        }
        return -1;
    }

    private int findSingleHit(double target) {
        int hits = 0;
        int idxFound = -1;
        int n = this.axis.getNcoords();
        for (int i = 0; i < n; ++i) {
            if (!this.contains(target, i)) continue;
            ++hits;
            idxFound = i;
        }
        if (hits == 1) {
            return idxFound;
        }
        if (hits == 0) {
            return -1;
        }
        return -hits;
    }

    private int findClosest(double target) {
        double minDiff = Double.MAX_VALUE;
        double useValue = Double.MIN_VALUE;
        int idxFound = -1;
        for (int i = 0; i < this.axis.getNcoords(); ++i) {
            double coord = this.axis.getCoordMidpoint(i);
            double diff = Math.abs(coord - target);
            if (!(diff < minDiff) && (diff != minDiff || !(coord > useValue))) continue;
            minDiff = diff;
            idxFound = i;
            useValue = coord;
        }
        return idxFound;
    }

    public Optional<CoverageCoordAxisBuilder> subset(double minValue, double maxValue, int stride) {
        return this.subsetValues(minValue, maxValue, stride);
    }

    @Nonnull
    public CoverageCoordAxisBuilder subsetClosest(double want) {
        return this.subsetValuesClosest(want);
    }

    @Nonnull
    public CoverageCoordAxisBuilder subsetLatest() {
        return this.subsetValuesLatest();
    }

    @Nonnull
    public CoverageCoordAxisBuilder subsetClosest(CalendarDate date) {
        double want = this.axis.convert(date);
        return this.subsetValuesClosest(want);
    }

    @Nonnull
    public CoverageCoordAxisBuilder subsetClosest(CalendarDate[] date) {
        double[] want = new double[]{this.axis.convert(date[0]), this.axis.convert(date[1])};
        return this.subsetValuesClosest(want);
    }

    public Optional<CoverageCoordAxisBuilder> subset(CalendarDateRange dateRange, int stride) {
        double min = this.axis.convert(dateRange.getStart());
        double max = this.axis.convert(dateRange.getEnd());
        return this.subsetValues(min, max, stride);
    }

    private Optional<CoverageCoordAxisBuilder> subsetValues(double minValue, double maxValue, int stride) {
        int count;
        if (this.axis.getSpacing() == CoverageCoordAxis.Spacing.discontiguousInterval) {
            return this.subsetValuesDiscontinuous(minValue, maxValue, stride);
        }
        double lower = this.axis.isAscending() ? Math.min(minValue, maxValue) : Math.max(minValue, maxValue);
        double upper = this.axis.isAscending() ? Math.max(minValue, maxValue) : Math.min(minValue, maxValue);
        int minIndex = this.findCoordElement(lower, false);
        int maxIndex = this.findCoordElement(upper, false);
        if (minIndex >= this.axis.getNcoords()) {
            return Optional.empty(String.format("no points in subset: lower %f > end %f", lower, this.axis.getEndValue()));
        }
        if (maxIndex < 0) {
            return Optional.empty(String.format("no points in subset: upper %f < start %f", upper, this.axis.getStartValue()));
        }
        if (minIndex < 0) {
            minIndex = 0;
        }
        if (maxIndex >= this.axis.getNcoords()) {
            maxIndex = this.axis.getNcoords() - 1;
        }
        if ((count = maxIndex - minIndex + 1) <= 0) {
            throw new IllegalArgumentException("no points in subset");
        }
        try {
            return Optional.of(this.subsetByIndex(new Range(minIndex, maxIndex, stride)));
        }
        catch (InvalidRangeException e) {
            return Optional.empty(e.getMessage());
        }
    }

    public Optional<RangeIterator> makeRange(double minValue, double maxValue, int stride) {
        int count;
        double lower = this.axis.isAscending() ? Math.min(minValue, maxValue) : Math.max(minValue, maxValue);
        double upper = this.axis.isAscending() ? Math.max(minValue, maxValue) : Math.min(minValue, maxValue);
        int minIndex = this.findCoordElement(lower, false);
        int maxIndex = this.findCoordElement(upper, false);
        if (minIndex >= this.axis.getNcoords()) {
            return Optional.empty(String.format("no points in subset: lower %f > end %f", lower, this.axis.getEndValue()));
        }
        if (maxIndex < 0) {
            return Optional.empty(String.format("no points in subset: upper %f < start %f", upper, this.axis.getStartValue()));
        }
        if (minIndex < 0) {
            minIndex = 0;
        }
        if (maxIndex >= this.axis.getNcoords()) {
            maxIndex = this.axis.getNcoords() - 1;
        }
        if ((count = maxIndex - minIndex + 1) <= 0) {
            return Optional.empty("no points in subset");
        }
        try {
            return Optional.of(new Range(minIndex, maxIndex, stride));
        }
        catch (InvalidRangeException e) {
            return Optional.empty(e.getMessage());
        }
    }

    private Optional<CoverageCoordAxisBuilder> subsetValuesDiscontinuous(double minValue, double maxValue, int stride) {
        return Optional.empty("subsetValuesDiscontinuous not done yet");
    }

    @Nonnull
    CoverageCoordAxisBuilder subsetByIndex(Range range) throws InvalidRangeException {
        int ncoords = range.length();
        if (range.last() >= this.axis.getNcoords()) {
            throw new InvalidRangeException("range.last() >= axis.getNcoords()");
        }
        double resolution = 0.0;
        int count2 = 0;
        double[] values = this.axis.getValues();
        double[] subsetValues = null;
        switch (this.axis.getSpacing()) {
            case regularInterval: 
            case regularPoint: {
                resolution = (double)range.stride() * this.axis.getResolution();
                break;
            }
            case irregularPoint: {
                subsetValues = new double[ncoords];
                for (int i : range) {
                    subsetValues[count2++] = values[i];
                }
                break;
            }
            case contiguousInterval: {
                subsetValues = new double[ncoords + 1];
                for (int i : range) {
                    subsetValues[count2++] = values[i];
                }
                subsetValues[count2] = values[range.last() + 1];
                break;
            }
            case discontiguousInterval: {
                subsetValues = new double[2 * ncoords];
                for (int i : range) {
                    subsetValues[count2++] = values[2 * i];
                    subsetValues[count2++] = values[2 * i + 1];
                }
                break;
            }
        }
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        builder.subset(ncoords, this.axis.getCoordMidpoint(range.first()), this.axis.getCoordMidpoint(range.last()), resolution, subsetValues);
        builder.setRange(range);
        return builder;
    }

    @Nonnull
    private CoverageCoordAxisBuilder subsetValuesClosest(double[] want) {
        int closest_index = this.findCoordElement(want, true);
        if (closest_index < 0) {
            this.findCoordElement(want, true);
        }
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        if (this.axis.spacing == CoverageCoordAxis.Spacing.regularInterval) {
            double val1 = this.axis.getCoordEdge1(closest_index);
            double val2 = this.axis.getCoordEdge2(closest_index);
            builder.subset(1, val1, val2, val2 - val1, null);
        } else {
            builder.subset(1, 0.0, 0.0, 0.0, this.makeValues(closest_index));
        }
        try {
            builder.setRange(new Range(closest_index, closest_index));
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    @Nonnull
    private CoverageCoordAxisBuilder subsetValuesClosest(double want) {
        int closest_index = this.findCoordElement(want, true);
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        if (this.axis.spacing == CoverageCoordAxis.Spacing.regularPoint) {
            double val = this.axis.getCoordMidpoint(closest_index);
            builder.subset(1, val, val, 0.0, null);
        } else if (this.axis.spacing == CoverageCoordAxis.Spacing.regularInterval) {
            double val1 = this.axis.getCoordEdge1(closest_index);
            double val2 = this.axis.getCoordEdge2(closest_index);
            builder.subset(1, val1, val2, val2 - val1, null);
        } else {
            builder.subset(1, 0.0, 0.0, 0.0, this.makeValues(closest_index));
        }
        try {
            builder.setRange(new Range(closest_index, closest_index));
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    Optional<CoverageCoordAxisBuilder> subsetContaining(double want) {
        int index = this.findCoordElement(want, false);
        if (index < 0 || index >= this.axis.getNcoords()) {
            return Optional.empty(String.format("value %f not in axis %s", want, this.axis.getName()));
        }
        double val = this.axis.getCoordMidpoint(index);
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        builder.subset(1, val, val, 0.0, this.makeValues(index));
        try {
            builder.setRange(new Range(index, index));
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return Optional.of(builder);
    }

    @Nonnull
    private CoverageCoordAxisBuilder subsetValuesLatest() {
        int last = this.axis.getNcoords() - 1;
        double val = this.axis.getCoordMidpoint(last);
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        builder.subset(1, val, val, 0.0, this.makeValues(last));
        try {
            builder.setRange(new Range(last, last));
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    private double[] makeValues(int index) {
        double[] subsetValues = null;
        switch (this.axis.getSpacing()) {
            case irregularPoint: {
                subsetValues = new double[]{this.axis.getCoordMidpoint(index)};
                break;
            }
            case contiguousInterval: 
            case discontiguousInterval: {
                subsetValues = new double[]{this.axis.getCoordEdge1(index), this.axis.getCoordEdge2(index)};
            }
        }
        return subsetValues;
    }

    int search(double want) {
        if (this.axis.getNcoords() == 1) {
            return Misc.nearlyEquals(want, this.axis.getStartValue()) ? 0 : -1;
        }
        if (this.axis.isRegular()) {
            double ival;
            double fval = (want - this.axis.getStartValue()) / this.axis.getResolution();
            return Misc.nearlyEquals(fval, ival = Math.rint(fval)) ? (int)ival : (int)(-ival) - 1;
        }
        return Arrays.binarySearch(this.axis.getValues(), want);
    }
}

