/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.ReadableRemoteFile;

public abstract class RemoteRandomAccessFile
extends RandomAccessFile
implements ReadableRemoteFile {
    protected final String url;
    protected static final int defaultMaxReadCacheSize = 0xA00000;
    protected static final int defaultRemoteFileBufferSize = 262144;
    protected static final int defaultRemoteFileTimeout = 10000;
    private static final long defaultReadCacheTimeToLive = 30000L;
    private final boolean readCacheEnabled;
    private final int readCacheBlockSize;
    private LoadingCache<Long, byte[]> readCache;
    private static final Logger logger = LoggerFactory.getLogger(RemoteRandomAccessFile.class);

    protected RemoteRandomAccessFile(String url, int bufferSize, int maxRemoteCacheSize) {
        super(bufferSize);
        this.url = url;
        this.file = null;
        this.location = url;
        if (maxRemoteCacheSize >= 2 * bufferSize) {
            this.readCacheBlockSize = 2 * bufferSize;
            this.initCache(maxRemoteCacheSize, Duration.ofMillis(30000L));
            this.readCacheEnabled = true;
        } else {
            this.readCacheBlockSize = -1;
            this.readCacheEnabled = false;
        }
    }

    private void initCache(int cacheBlockSizeInBytes, Duration timeToLive) {
        CacheBuilder cb = CacheBuilder.newBuilder().maximumSize((long)cacheBlockSizeInBytes).expireAfterWrite(timeToLive);
        if (debugAccess) {
            cb.recordStats();
        }
        this.readCache = cb.build((CacheLoader)new CacheLoader<Long, byte[]>(){

            public byte[] load(@Nonnull Long key) throws IOException {
                return RemoteRandomAccessFile.this.readRemoteCacheSizedChunk(key);
            }
        });
    }

    @Override
    protected int read_(long pos, byte[] buff, int offset, int len) throws IOException {
        return this.readCacheEnabled ? this.readFromCache(pos, buff, offset, len) : this.readRemote(pos, buff, offset, len);
    }

    private int readFromCache(long pos, byte[] buff, int offset, int len) throws IOException {
        byte[] src;
        long startCacheBlock = pos / (long)this.readCacheBlockSize;
        long endCacheBlock = (pos + (long)len - 1L) / (long)this.readCacheBlockSize;
        if (pos >= this.length()) {
            return 0;
        }
        if (endCacheBlock - startCacheBlock > 1L) {
            return this.readFromCache(pos, buff, offset, len);
        }
        if (endCacheBlock - startCacheBlock == 1L) {
            int length1 = (int)(endCacheBlock * (long)this.readCacheBlockSize - pos);
            int length2 = (int)(pos + (long)len - endCacheBlock * (long)this.readCacheBlockSize);
            return this.readFromCache(pos, buff, offset, length1) + this.readFromCache(pos + (long)length1, buff, offset + length1, length2);
        }
        Long key = startCacheBlock;
        try {
            src = (byte[])this.readCache.get((Object)key);
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        int srcPos = (int)(pos - key * (long)this.readCacheBlockSize);
        int toEOB = src.length - srcPos;
        int length = toEOB < len ? toEOB : len;
        System.arraycopy(src, srcPos, buff, offset, length);
        return len;
    }

    private byte[] readRemoteCacheSizedChunk(Long cacheBlockNumber) throws IOException {
        long position = cacheBlockNumber * (long)this.readCacheBlockSize;
        int toEOF = (int)(this.length() - position);
        int bytes = toEOF < this.readCacheBlockSize ? toEOF : this.readCacheBlockSize;
        byte[] buffer = new byte[bytes];
        this.readRemote(position, buffer, 0, bytes);
        return buffer;
    }

    @Override
    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        int n = (int)nbytes;
        byte[] buff = new byte[n];
        int done = this.read_(offset, buff, 0, n);
        dest.write(ByteBuffer.wrap(buff));
        return done;
    }

    @Override
    public void close() throws IOException {
        this.closeRemote();
        super.close();
        if (this.readCache != null) {
            this.readCache.invalidateAll();
            if (debugAccess) {
                logger.info(this.readCache.stats().toString());
            }
        }
    }
}

