/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import java.util.Formatter;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.proj4.MapMath;

public class TransverseMercatorProjection
extends ProjectionImpl {
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;
    private double esp;
    private double ml0;
    private double[] en;
    private double projectionLatitude;
    private double projectionLongitude;
    private double scaleFactor;
    private double falseEasting;
    private double falseNorthing;
    Earth ellipsoid;
    private double e;
    private double es;
    private double one_es;
    private double totalScale;
    private boolean spherical;

    public TransverseMercatorProjection() {
        super("TransverseMercatorProjection", false);
        this.ellipsoid = new Earth();
        this.projectionLatitude = Math.toRadians(0.0);
        this.projectionLongitude = Math.toRadians(0.0);
        this.initialize();
    }

    public TransverseMercatorProjection(Earth ellipsoid, double lon_0_deg, double lat_0_deg, double k, double falseEast, double falseNorth) {
        super("TransverseMercatorProjection", false);
        this.ellipsoid = ellipsoid;
        this.projectionLongitude = Math.toRadians(lon_0_deg);
        this.projectionLatitude = Math.toRadians(lat_0_deg);
        this.scaleFactor = k;
        this.falseEasting = falseEast;
        this.falseNorthing = falseNorth;
        this.initialize();
        this.addParameter("grid_mapping_name", "transverse_mercator");
        this.addParameter("longitude_of_central_meridian", lon_0_deg);
        this.addParameter("latitude_of_projection_origin", lat_0_deg);
        this.addParameter("scale_factor_at_central_meridian", this.scaleFactor);
        if (this.falseEasting != 0.0 || this.falseNorthing != 0.0) {
            this.addParameter("false_easting", this.falseEasting);
            this.addParameter("false_northing", this.falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", ellipsoid.getMajor());
        this.addParameter("inverse_flattening", 1.0 / ellipsoid.getFlattening());
    }

    public boolean isRectilinear() {
        return false;
    }

    public void initialize() {
        this.e = this.ellipsoid.getEccentricity();
        this.es = this.ellipsoid.getEccentricitySquared();
        this.spherical = this.e == 0.0;
        this.one_es = 1.0 - this.es;
        this.totalScale = this.ellipsoid.getMajor() * 0.001;
        if (this.spherical) {
            this.esp = this.scaleFactor;
            this.ml0 = 0.5 * this.esp;
        } else {
            this.en = MapMath.enfn(this.es);
            this.ml0 = MapMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
            this.esp = this.es / (1.0 - this.es);
        }
    }

    public int getRowFromNearestParallel(double latitude) {
        int degrees = (int)MapMath.radToDeg(MapMath.normalizeLatitude(latitude));
        if (degrees < -80 || degrees > 84) {
            return 0;
        }
        if (degrees > 80) {
            return 24;
        }
        return (degrees + 80) / 8 + 3;
    }

    public int getZoneFromNearestMeridian(double longitude) {
        int zone = (int)Math.floor((MapMath.normalizeLongitude(longitude) + Math.PI) * 30.0 / Math.PI) + 1;
        if (zone < 1) {
            zone = 1;
        } else if (zone > 60) {
            zone = 60;
        }
        return zone;
    }

    public void setUTMZone(int zone) {
        this.projectionLongitude = ((double)(--zone) + 0.5) * Math.PI / 30.0 - Math.PI;
        this.projectionLatitude = 0.0;
        this.scaleFactor = 0.9996;
        this.falseEasting = 500000.0;
        this.initialize();
    }

    public ProjectionPoint project(double lplam, double lpphi, ProjectionPointImpl xy) {
        if (this.spherical) {
            double cosphi = Math.cos(lpphi);
            double b = cosphi * Math.sin(lplam);
            double x = this.ml0 * this.scaleFactor * Math.log((1.0 + b) / (1.0 - b));
            double ty = cosphi * Math.cos(lplam) / Math.sqrt(1.0 - b * b);
            ty = MapMath.acos(ty);
            if (lpphi < 0.0) {
                ty = -ty;
            }
            double y = this.esp * (ty - this.projectionLatitude);
            xy.setLocation(x, y);
        } else {
            double sinphi = Math.sin(lpphi);
            double cosphi = Math.cos(lpphi);
            double t = Math.abs(cosphi) > 1.0E-10 ? sinphi / cosphi : 0.0;
            t *= t;
            double al = cosphi * lplam;
            double als = al * al;
            double n = this.esp * cosphi * cosphi;
            double x = this.scaleFactor * (al /= Math.sqrt(1.0 - this.es * sinphi * sinphi)) * (1.0 + 0.16666666666666666 * als * (1.0 - t + n + 0.05 * als * (5.0 + t * (t - 18.0) + n * (14.0 - 58.0 * t) + 0.023809523809523808 * als * (61.0 + t * (t * (179.0 - t) - 479.0)))));
            double y = this.scaleFactor * (MapMath.mlfn(lpphi, sinphi, cosphi, this.en) - this.ml0 + sinphi * al * lplam * 0.5 * (1.0 + 0.08333333333333333 * als * (5.0 - t + n * (9.0 + 4.0 * n) + 0.03333333333333333 * als * (61.0 + t * (t - 58.0) + n * (270.0 - 330.0 * t) + 0.017857142857142856 * als * (1385.0 + t * (t * (543.0 - t) - 3111.0))))));
            xy.setLocation(x, y);
        }
        return xy;
    }

    public ProjectionPoint projectInverse(double x, double y, ProjectionPointImpl out) {
        if (this.spherical) {
            double h = Math.exp(x / this.scaleFactor);
            double g = 0.5 * (h - 1.0 / h);
            h = Math.cos(this.projectionLatitude + y / this.scaleFactor);
            double outy = MapMath.asin(Math.sqrt((1.0 - h * h) / (1.0 + g * g)));
            if (y < 0.0) {
                outy = -outy;
            }
            double outx = Math.atan2(g, h);
            out.setLocation(outx, outy);
        } else {
            double outx = 0.0;
            double outy = MapMath.inv_mlfn(this.ml0 + y / this.scaleFactor, this.es, this.en);
            if (Math.abs(y) >= 1.5707963267948966) {
                outy = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                out.setLocation(outx, outy);
            } else {
                double sinphi = Math.sin(outy);
                double cosphi = Math.cos(outy);
                double t = Math.abs(cosphi) > 1.0E-10 ? sinphi / cosphi : 0.0;
                double n = this.esp * cosphi * cosphi;
                double con = 1.0 - this.es * sinphi * sinphi;
                double d = x * Math.sqrt(con) / this.scaleFactor;
                con *= t;
                t *= t;
                double ds = d * d;
                outx = d * (1.0 - ds * 0.16666666666666666 * (1.0 + 2.0 * t + n - ds * 0.05 * (5.0 + t * (28.0 + 24.0 * t + 8.0 * n) + 6.0 * n - ds * 0.023809523809523808 * (61.0 + t * (662.0 + t * (1320.0 + 720.0 * t)))))) / cosphi;
                out.setLocation(outx, outy -= con * ds / (1.0 - this.es) * 0.5 * (1.0 - ds * 0.08333333333333333 * (5.0 + t * (3.0 - 9.0 * n) + n * (1.0 - 4.0 * n) - ds * 0.03333333333333333 * (61.0 + t * (90.0 - 252.0 * n + 45.0 * t) + 46.0 * n - ds * 0.017857142857142856 * (1385.0 + t * (3633.0 + t * (4095.0 + 1574.0 * t)))))));
            }
        }
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Transverse Mercator Ellipsoidal Earth";
    }

    @Override
    public ProjectionImpl constructCopy() {
        TransverseMercatorProjection result = new TransverseMercatorProjection(this.ellipsoid, Math.toDegrees(this.projectionLongitude), Math.toDegrees(this.projectionLatitude), this.scaleFactor, this.falseEasting, this.falseNorthing);
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    @Override
    public String paramsToString() {
        Formatter f = new Formatter();
        f.format("origin lat,lon=%f,%f scale=%f earth=%s falseEast/North=%f,%f", Math.toDegrees(this.projectionLatitude), Math.toDegrees(this.projectionLongitude), this.scaleFactor, this.ellipsoid, this.falseEasting, this.falseNorthing);
        return f.toString();
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl destPoint) {
        double fromLat = Math.toRadians(latLon.getLatitude());
        double theta = Math.toRadians(latLon.getLongitude());
        if (this.projectionLongitude != 0.0) {
            theta = MapMath.normalizeLongitude(theta - this.projectionLongitude);
        }
        ProjectionPoint res = this.project(theta, fromLat, new ProjectionPointImpl());
        destPoint.setLocation(this.totalScale * res.getX() + this.falseEasting, this.totalScale * res.getY() + this.falseNorthing);
        return destPoint;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = (world.getX() - this.falseEasting) / this.totalScale;
        double fromY = (world.getY() - this.falseNorthing) / this.totalScale;
        ProjectionPointImpl dst = new ProjectionPointImpl();
        this.projectInverse(fromX, fromY, dst);
        if (dst.getX() < -Math.PI) {
            dst.setX(-Math.PI);
        } else if (dst.getX() > Math.PI) {
            dst.setX(Math.PI);
        }
        if (this.projectionLongitude != 0.0) {
            dst.setX(MapMath.normalizeLongitude(dst.getX()) + this.projectionLongitude);
        }
        result.setLongitude(Math.toDegrees(dst.getX()));
        result.setLatitude(Math.toDegrees(dst.getY()));
        return result;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        double y2;
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        double y1 = pt1.getY() - this.falseNorthing;
        return y1 * (y2 = pt2.getY() - this.falseNorthing) < 0.0 && Math.abs(y1 - y2) > 2.0 * this.ellipsoid.getMajor();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransverseMercatorProjection that = (TransverseMercatorProjection)o;
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.projectionLatitude, this.projectionLatitude) != 0) {
            return false;
        }
        if (Double.compare(that.projectionLongitude, this.projectionLongitude) != 0) {
            return false;
        }
        if (Double.compare(that.scaleFactor, this.scaleFactor) != 0) {
            return false;
        }
        return this.ellipsoid.equals(that.ellipsoid);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.projectionLatitude) ^ Double.doubleToLongBits(this.projectionLatitude) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.projectionLongitude) ^ Double.doubleToLongBits(this.projectionLongitude) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.scaleFactor) ^ Double.doubleToLongBits(this.scaleFactor) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.falseEasting) ^ Double.doubleToLongBits(this.falseEasting) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.falseNorthing) ^ Double.doubleToLongBits(this.falseNorthing) >>> 32);
        hash = 97 * hash + (this.ellipsoid != null ? this.ellipsoid.hashCode() : 0);
        return hash;
    }
}

