package ucar.nc2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A list of strings that only allows one thread to use any given value at the same time.
 *
 * @author cmrose
 * @deprecated will move to ucar.nc2.util in ver 6.
 */
@Deprecated
public class StringLocker {

  private List<String> stringList = Collections.synchronizedList(new ArrayList<>());
  private boolean waiting;

  public synchronized void control(String item) {
    // If the string is in use by another thread then wait() for the other thread
    waiting = stringList.contains(item);
    while (waiting) {
      try {
        wait();
      } catch (InterruptedException e) {
        Thread.currentThread().interrupt();
      }
    }
    // Finished waiting so the thread can have the string
    stringList.add(item);
  }

  public synchronized void release(String item) {
    // Tell StringLocker the thread is done with the string
    stringList.remove(item);
    waiting = false;
    notifyAll();
  }

  public String toString() {
    return stringList.toString();
  }

}
