/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft2.simpgeometry.CFPoint;
import ucar.nc2.ft2.simpgeometry.CFSimpleGeometryHelper;
import ucar.nc2.ft2.simpgeometry.GeometryType;
import ucar.nc2.ft2.simpgeometry.Line;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.SimpleGeometryIndexFinder;
import ucar.nc2.ft2.simpgeometry.exception.InvalidDataseriesException;

public class CFLine
implements Line {
    private static final Logger cfl = LoggerFactory.getLogger(CFLine.class);
    private List<Point> points;
    private Line next;
    private Line prev;
    private Array data;

    public GeometryType getGeometryType() {
        return GeometryType.LINE;
    }

    @Override
    public void addPoint(double x, double y) {
        Point ptPrev = null;
        if (!this.points.isEmpty()) {
            ptPrev = this.points.get(this.points.size() - 1);
        }
        this.points.add(new CFPoint(x, y, ptPrev, null, null));
    }

    @Override
    public List<Point> getPoints() {
        return this.points;
    }

    @Override
    public Array getData() {
        return this.data;
    }

    @Override
    public Line getNext() {
        return this.next;
    }

    @Override
    public Line getPrev() {
        return this.prev;
    }

    @Override
    public void setData(Array data) {
        this.data = data;
    }

    @Override
    public void setNext(Line next) {
        if (next instanceof CFLine) {
            this.setNext((CFLine)next);
        } else {
            this.next = next;
        }
    }

    protected void setNext(CFLine next) {
        this.next = next;
        if (next != null) {
            next.setPrevOnce(this);
        }
    }

    private void setNextOnce(CFLine next) {
        this.next = next;
    }

    @Override
    public void setPrev(Line prev) {
        if (prev instanceof CFLine) {
            this.setPrev((CFLine)prev);
        } else {
            this.prev = prev;
        }
    }

    protected void setPrev(CFLine prev) {
        this.prev = prev;
        if (prev != null) {
            prev.setNextOnce(this);
        }
    }

    private void setPrevOnce(CFLine prev) {
        this.prev = prev;
    }

    @Override
    public Line setupLine(NetcdfDataset dataset, Variable var, int index) {
        block20: {
            this.points.clear();
            Variable partNodeCounts = null;
            List<CoordinateAxis> axes = dataset.getCoordinateAxes();
            CoordinateAxis x = null;
            CoordinateAxis y = null;
            String[] nodeCoords = var.attributes().findAttValueIgnoreCase("node_coordinates", "").split(" ");
            for (CoordinateAxis ax : axes) {
                if (ax.getFullName().equals(nodeCoords[0])) {
                    x = ax;
                }
                if (!ax.getFullName().equals(nodeCoords[1])) continue;
                y = ax;
            }
            String node_c_str = var.findAttValueIgnoreCase("node_count", "");
            if (node_c_str.equals("")) {
                return null;
            }
            Variable nodeCounts = dataset.findVariable(node_c_str);
            String pNodeCoStr = var.findAttValueIgnoreCase("part_node_count", "");
            if (!pNodeCoStr.equals("")) {
                partNodeCounts = dataset.findVariable(pNodeCoStr);
            }
            SimpleGeometryIndexFinder indexFinder = new SimpleGeometryIndexFinder(nodeCounts);
            int lower = indexFinder.getBeginning(index);
            int upper = indexFinder.getEnd(index);
            try {
                Array xPts = x.read(lower + ":" + upper).reduce();
                Array yPts = y.read(lower + ":" + upper).reduce();
                IndexIterator itrX = xPts.getIndexIterator();
                IndexIterator itrY = yPts.getIndexIterator();
                if (partNodeCounts == null) {
                    this.next = null;
                    this.prev = null;
                    while (itrX.hasNext()) {
                        this.addPoint(itrX.getDoubleNext(), itrY.getDoubleNext());
                    }
                    switch (var.getRank()) {
                        case 2: {
                            this.setData(var.read(CFSimpleGeometryHelper.getSubsetString(var, index)).reduce());
                            break block20;
                        }
                        case 1: {
                            this.setData(var.read("" + index));
                            break block20;
                        }
                        default: {
                            throw new InvalidDataseriesException("Error: Only dataseries of rank 1 or 2 are allowed for simple geometry.");
                        }
                    }
                }
                Line tail = this;
                Array pnc = partNodeCounts.read();
                IndexIterator pncItr = pnc.getIndexIterator();
                int pncInd = 0;
                int pncEnd = 0;
                while (pncEnd < lower) {
                    pncEnd += pncItr.getIntNext();
                    ++pncInd;
                }
                while (lower < upper) {
                    for (int smaller = pnc.getInt(pncInd); smaller > 0; --smaller) {
                        tail.addPoint(itrX.getDoubleNext(), itrY.getDoubleNext());
                    }
                    switch (var.getRank()) {
                        case 2: {
                            tail.setData(var.read(CFSimpleGeometryHelper.getSubsetString(var, index)).reduce());
                            break;
                        }
                        case 1: {
                            tail.setData(var.read("" + index));
                            break;
                        }
                        default: {
                            throw new InvalidDataseriesException("Error: Only dataseries of rank 1 or 2 are allowed for simple geometry.");
                        }
                    }
                    lower += tail.getPoints().size();
                    ++pncInd;
                    tail.setNext(new CFLine());
                    tail = tail.getNext();
                }
                if ((tail = tail.getPrev()) != null) {
                    tail.setNext(null);
                }
            }
            catch (IOException | InvalidRangeException | InvalidDataseriesException e) {
                cfl.error(e.getMessage());
                return null;
            }
        }
        return this;
    }

    @Override
    public double[] getBBUpper() {
        double[] bbUpper = new double[2];
        List<Point> ptList = this.getPoints();
        if (ptList.isEmpty()) {
            return null;
        }
        bbUpper[0] = ptList.get(0).getY();
        bbUpper[1] = ptList.get(0).getY();
        for (Point pt : this.getPoints()) {
            if (bbUpper[0] < pt.getX()) {
                bbUpper[0] = pt.getX();
            }
            if (!(bbUpper[1] < pt.getY())) continue;
            bbUpper[1] = pt.getY();
        }
        bbUpper[0] = bbUpper[0] + 10.0;
        bbUpper[1] = bbUpper[1] + 10.0;
        return bbUpper;
    }

    @Override
    public double[] getBBLower() {
        double[] bbLower = new double[2];
        List<Point> ptList = this.getPoints();
        if (ptList.isEmpty()) {
            return null;
        }
        bbLower[0] = ptList.get(0).getY();
        bbLower[1] = ptList.get(0).getY();
        for (Point pt : this.getPoints()) {
            if (bbLower[0] > pt.getX()) {
                bbLower[0] = pt.getX();
            }
            if (!(bbLower[1] > pt.getY())) continue;
            bbLower[1] = pt.getY();
        }
        bbLower[0] = bbLower[0] - 10.0;
        bbLower[1] = bbLower[1] - 10.0;
        return bbLower;
    }

    public CFLine() {
        this.points = new ArrayList<Point>();
        this.next = null;
        this.prev = null;
        this.data = null;
    }

    public CFLine(List<Point> newPt) {
        this.points = newPt;
        this.next = null;
        this.data = null;
    }
}

