/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Format;
import ucar.unidata.util.Parameter;

@Deprecated
public abstract class ProjectionImpl
implements Projection,
Serializable {
    public static final double EARTH_RADIUS = 6371.229;
    public static final int INDEX_LAT = 0;
    public static final int INDEX_LON = 1;
    public static final int INDEX_X = 0;
    public static final int INDEX_Y = 1;
    protected static final double TOLERANCE = 1.0E-6;
    public static final double PI = Math.PI;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    protected String name;
    protected final boolean isLatLon;
    protected final List<Parameter> atts = new ArrayList<Parameter>();
    protected ProjectionRect defaultMapArea = new ProjectionRect();

    public abstract ProjectionImpl constructCopy();

    protected ProjectionImpl(String name, boolean isLatLon) {
        this.name = name;
        this.isLatLon = isLatLon;
    }

    @Override
    public String getClassName() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            className = className.substring(index + 1);
        }
        return className;
    }

    @Override
    public abstract String paramsToString();

    public String getProjectionTypeLabel() {
        return this.getClassName();
    }

    @Override
    @Deprecated
    public abstract ProjectionPoint latLonToProj(LatLonPoint var1, ProjectionPointImpl var2);

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        return this.latLonToProj(latLon, new ProjectionPointImpl());
    }

    @Override
    @Deprecated
    public abstract LatLonPoint projToLatLon(ProjectionPoint var1, LatLonPointImpl var2);

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint ppt) {
        return this.projToLatLon(ppt, new LatLonPointImpl());
    }

    @Override
    public abstract boolean crossSeam(ProjectionPoint var1, ProjectionPoint var2);

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Parameter> getProjectionParameters() {
        return this.atts;
    }

    @Deprecated
    public Parameter findProjectionParameter(String want) {
        for (Parameter p : this.atts) {
            if (!p.getName().equals(want)) continue;
            return p;
        }
        return null;
    }

    protected void addParameter(String name, String value) {
        this.atts.add(new Parameter(name, value));
    }

    protected void addParameter(String name, double value) {
        this.atts.add(new Parameter(name, value));
    }

    protected void addParameter(Parameter p) {
        this.atts.add(p);
    }

    @Override
    public boolean isLatLon() {
        return this.isLatLon;
    }

    public static String getHeader() {
        StringBuilder headerB = new StringBuilder(60);
        headerB.append("Name");
        Format.tab(headerB, 20, true);
        headerB.append("Class");
        Format.tab(headerB, 40, true);
        headerB.append("Parameters");
        return headerB.toString();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ProjectionRect getDefaultMapArea() {
        return this.defaultMapArea;
    }

    public LatLonRect getDefaultMapAreaLL() {
        return this.projToLatLonBB(this.defaultMapArea);
    }

    @Deprecated
    public void setDefaultMapArea(ProjectionRect bb) {
        if (bb == null) {
            return;
        }
        this.defaultMapArea = new ProjectionRect(bb);
    }

    @Deprecated
    public double[][] projToLatLon(double[][] from) {
        return this.projToLatLon(from, new double[2][from[0].length]);
    }

    @Deprecated
    public double[][] projToLatLon(double[][] from, double[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            LatLonPoint endL = this.projToLatLon(from[0][i], from[1][i]);
            to[0][i] = endL.getLatitude();
            to[1][i] = endL.getLongitude();
        }
        return to;
    }

    @Deprecated
    public float[][] projToLatLon(float[][] from) {
        return this.projToLatLon(from, new float[2][from[0].length]);
    }

    @Deprecated
    public float[][] projToLatLon(float[][] from, float[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            ProjectionPoint ppi = ProjectionPoint.create(from[0][i], from[1][i]);
            LatLonPoint llpi = this.projToLatLon(ppi);
            to[0][i] = (float)llpi.getLatitude();
            to[1][i] = (float)llpi.getLongitude();
        }
        return to;
    }

    @Deprecated
    public double[][] latLonToProj(double[][] from) {
        return this.latLonToProj(from, new double[2][from[0].length]);
    }

    @Deprecated
    public double[][] latLonToProj(double[][] from, double[][] to) {
        return this.latLonToProj(from, to, 0, 1);
    }

    @Deprecated
    public double[][] latLonToProj(double[][] from, int latIndex, int lonIndex) {
        return this.latLonToProj(from, new double[2][from[0].length], latIndex, lonIndex);
    }

    @Deprecated
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            LatLonPoint llpi = LatLonPoint.create(from[latIndex][i], from[lonIndex][i]);
            ProjectionPoint ppi = this.latLonToProj(llpi);
            to[0][i] = ppi.getX();
            to[1][i] = ppi.getY();
        }
        return to;
    }

    @Deprecated
    public float[][] latLonToProj(float[][] from) {
        return this.latLonToProj(from, new float[2][from[0].length]);
    }

    @Deprecated
    public float[][] latLonToProj(float[][] from, float[][] to) {
        return this.latLonToProj(from, to, 0, 1);
    }

    @Deprecated
    public float[][] latLonToProj(float[][] from, int latIndex, int lonIndex) {
        return this.latLonToProj(from, new float[2][from[0].length], latIndex, lonIndex);
    }

    @Deprecated
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            LatLonPoint llpi = LatLonPoint.create(from[latIndex][i], from[lonIndex][i]);
            ProjectionPoint ppi = this.latLonToProj(llpi);
            to[0][i] = (float)ppi.getX();
            to[1][i] = (float)ppi.getY();
        }
        return to;
    }

    @Override
    public ProjectionRect latLonToProjBB(LatLonRect latlonRect) {
        if (this.isLatLon) {
            LatLonProjection llp = (LatLonProjection)this;
            llp.setCenterLon(latlonRect.getCenterLon());
        }
        LatLonPointImpl ll = latlonRect.getLowerLeftPoint();
        LatLonPointImpl ur = latlonRect.getUpperRightPoint();
        ProjectionPoint w1 = this.latLonToProj(ll);
        ProjectionPoint w2 = this.latLonToProj(ur);
        ProjectionRect world = new ProjectionRect(w1.getX(), w1.getY(), w2.getX(), w2.getY());
        LatLonPoint la = LatLonPoint.create(ur.getLatitude(), ll.getLongitude());
        LatLonPoint lb = LatLonPoint.create(ll.getLatitude(), ur.getLongitude());
        world.add(this.latLonToProj(la));
        world.add(this.latLonToProj(lb));
        return world;
    }

    @Override
    public LatLonRect projToLatLonBB(ProjectionRect bb) {
        LatLonRect llbb;
        LatLonPoint llpt = this.projToLatLon(bb.getLowerLeftPoint());
        LatLonPoint lrpt = this.projToLatLon(bb.getLowerRightPoint());
        LatLonPoint urpt = this.projToLatLon(bb.getUpperRightPoint());
        LatLonPoint ulpt = this.projToLatLon(bb.getUpperLeftPoint());
        boolean includesNorthPole = false;
        boolean includesSouthPole = false;
        if (includesNorthPole && !includesSouthPole) {
            llbb = new LatLonRect(llpt, LatLonPoint.create(90.0, 0.0));
            llbb.extend(lrpt);
            llbb.extend(urpt);
            llbb.extend(ulpt);
        } else if (includesSouthPole && !includesNorthPole) {
            llbb = new LatLonRect(llpt, LatLonPoint.create(-90.0, -180.0));
            llbb.extend(lrpt);
            llbb.extend(urpt);
            llbb.extend(ulpt);
        } else {
            double latMin = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            double latMax = Math.max(ulpt.getLatitude(), urpt.getLatitude());
            double lonMin = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            double lonMax = this.getMinOrMaxLon(lrpt.getLongitude(), urpt.getLongitude(), false);
            LatLonPoint min = LatLonPoint.create(latMin, lonMin);
            LatLonPoint max = LatLonPoint.create(latMax, lonMax);
            llbb = new LatLonRect(min, max);
        }
        return llbb;
    }

    ProjectionRect latLonToProjBB2(LatLonRect latlonRect) {
        double maxy;
        double maxx;
        double miny;
        double minx;
        LatLonPointImpl llpt = latlonRect.getLowerLeftPoint();
        LatLonPointImpl urpt = latlonRect.getUpperRightPoint();
        LatLonPointImpl lrpt = latlonRect.getLowerRightPoint();
        LatLonPointImpl ulpt = latlonRect.getUpperLeftPoint();
        if (this.isLatLon()) {
            minx = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            maxx = this.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
            maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
        } else {
            ProjectionPoint ll = this.latLonToProj(llpt);
            ProjectionPoint ur = this.latLonToProj(urpt);
            ProjectionPoint lr = this.latLonToProj(lrpt);
            ProjectionPoint ul = this.latLonToProj(ulpt);
            minx = Math.min(ll.getX(), ul.getX());
            miny = Math.min(ll.getY(), lr.getY());
            maxx = Math.max(ur.getX(), lr.getX());
            maxy = Math.max(ul.getY(), ur.getY());
        }
        return new ProjectionRect(minx, miny, maxx, maxy);
    }

    private double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
        double midpoint = (lon1 + lon2) / 2.0;
        lon1 = LatLonPoints.lonNormal(lon1, midpoint);
        lon2 = LatLonPoints.lonNormal(lon2, midpoint);
        return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
    }

    @Deprecated
    public LatLonRect projToLatLonBBold(ProjectionRect world) {
        ProjectionPoint min = world.getMinPoint();
        ProjectionPoint max = world.getMaxPoint();
        LatLonPoint llmin = this.projToLatLon(min);
        LatLonPoint llmax = this.projToLatLon(max);
        LatLonRect llbb = new LatLonRect(llmin, llmax);
        ProjectionPoint w1 = ProjectionPoint.create(min.getX(), max.getY());
        ProjectionPoint w2 = ProjectionPoint.create(max.getX(), min.getY());
        llmin = this.projToLatLon(w1);
        llbb.extend(llmin);
        llmax = this.projToLatLon(w2);
        llbb.extend(llmax);
        return llbb;
    }
}

