/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.WriterCFPointAbstract;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.EarthLocation;

class WriterCFPointCollection
extends WriterCFPointAbstract {
    private int obsRecno;

    WriterCFPointCollection(String fileOut, AttributeContainer globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writerb.addAttribute(new Attribute("featureType", CF.FeatureType.point.name()));
        this.writerb.addAttribute(new Attribute("DSG_representation", "Point Data, H.1"));
    }

    void writeHeader(PointFeature pf) throws IOException {
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        coords.add(VariableSimpleBuilder.makeScalar("time", "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        coords.add(VariableSimpleBuilder.makeScalar("latitude", "latitude of measurement", "degrees_north", DataType.DOUBLE).build());
        coords.add(VariableSimpleBuilder.makeScalar("longitude", "longitude of measurement", "degrees_east", DataType.DOUBLE).build());
        Formatter coordNames = new Formatter().format("%s %s %s", "time", "latitude", "longitude");
        if (this.altUnits != null) {
            coords.add(VariableSimpleBuilder.makeScalar("altitude", "altitude of measurement", this.altUnits, DataType.DOUBLE).addAttribute("positive", CF1Convention.getZisPositive("altitude", this.altUnits)).build());
            coordNames.format(" %s", "altitude");
        }
        super.writeHeader(coords, null, null, pf.getDataAll(), coordNames.toString());
    }

    @Override
    void makeFeatureVariables(StructureData featureData, boolean isExtended) {
    }

    void writeRecord(PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sobs.getLocation(), sdata);
    }

    private void writeRecord(double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(loc.getLatLon(), obsDate);
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("time", null, null, DataType.DOUBLE, timeCoordValue);
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, loc.getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, loc.getLongitude());
        if (this.altUnits != null) {
            smb.addMemberScalar("altitude", null, null, DataType.DOUBLE, loc.getAltitude());
        }
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create((Iterable<StructureData>)ImmutableList.of((Object)coords, (Object)sdata));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

